/*
 * Copyright 2022, OpenRemote Inc.
 *
 * See the CONTRIBUTORS.txt file in the distribution for a
 * full listing of individual contributors.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.openremote.container;

import org.hibernate.dialect.PostgreSQL10Dialect;
import org.openremote.container.persistence.LTreeType;

import java.sql.Types;

public class PostgreSQL10LTreeDialect extends PostgreSQL10Dialect {
    public PostgreSQL10LTreeDialect() {
        super();
        registerHibernateType(Types.OTHER, LTreeType.class.getName());
    }
}
