/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.zwave;

import io.netty.channel.ChannelHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openremote.agent.protocol.io.AbstractNettyIOClient;
import org.openremote.agent.protocol.serial.SerialIOClient;
import org.openremote.agent.protocol.zwave.ZWavePacketDecoder;
import org.openremote.agent.protocol.zwave.ZWavePacketEncoder;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.protocol.zwave.LoggerUtil;
import org.openremote.protocol.zwave.port.ConnectionStatus;
import org.openremote.protocol.zwave.port.TransportLayer;
import org.openremote.protocol.zwave.port.TransportLayerListener;

public class ZWaveSerialIOClient
extends SerialIOClient<byte[]>
implements TransportLayer {
    public static final String SERIAL_PORT_LOG_HEADER = "Serial_Port                 : ";
    private static final Logger log = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, (String)"OpenRemote.Controller.protocol.zwave");
    private volatile TransportLayerListener listener;

    public ZWaveSerialIOClient(String port) {
        super(port, 115200);
        this.setEncoderDecoderProvider(() -> new ChannelHandler[]{new ZWavePacketEncoder(), new ZWavePacketDecoder(), new AbstractNettyIOClient.MessageToMessageDecoder<byte[]>(byte[].class, this)});
        this.addMessageConsumer(this::onPacketReceived);
        this.addConnectionStatusConsumer(this::onConnectionStatusUpdate);
    }

    public void open() {
        try {
            this.connect();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to open serial port: " + this.getClientUri(), e);
        }
    }

    public void close() {
        this.disconnect();
    }

    public void setListener(TransportLayerListener listener) {
        this.listener = listener;
    }

    public void write(byte[] data) {
        this.sendMessage(data);
    }

    protected void onPacketReceived(byte[] data) {
        if (this.listener != null) {
            this.logDataBytes(data, false);
            this.listener.dataReceived(data);
        }
    }

    protected void onConnectionStatusUpdate(org.openremote.model.asset.agent.ConnectionStatus connectionStatus) {
        if (this.listener != null) {
            switch (connectionStatus) {
                case CONNECTING: {
                    this.listener.onConnectionStatusChanged(ConnectionStatus.CONNECTING);
                    break;
                }
                case CONNECTED: {
                    this.listener.onConnectionStatusChanged(ConnectionStatus.CONNECTED);
                    break;
                }
                case DISCONNECTING: {
                    this.listener.onConnectionStatusChanged(ConnectionStatus.DISCONNECTING);
                    break;
                }
                case DISCONNECTED: {
                    this.listener.onConnectionStatusChanged(ConnectionStatus.DISCONNECTED);
                    break;
                }
                case ERROR: {
                    this.listener.onConnectionStatusChanged(ConnectionStatus.ERROR);
                }
            }
        }
    }

    private void logDataBytes(byte[] data, boolean isTransmit) {
        if (data == null || data.length == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < data.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(String.format("0x%02X", data[i] & 0xFF));
        }
        builder.append("]");
        LoggerUtil.debug((String)(SERIAL_PORT_LOG_HEADER + (isTransmit ? "Data bytes transmitted (TX) : {0}" : "Data bytes received (RX) : {0}")), (Object[])new Object[]{builder.toString()});
    }
}

