/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.zwave;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openremote.agent.protocol.AbstractProtocol;
import org.openremote.agent.protocol.zwave.ZWaveAgent;
import org.openremote.agent.protocol.zwave.ZWaveAgentLink;
import org.openremote.agent.protocol.zwave.ZWaveNetwork;
import org.openremote.model.Container;
import org.openremote.model.asset.AssetTreeNode;
import org.openremote.model.asset.agent.AgentLink;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.attribute.AttributeState;
import org.openremote.model.protocol.ProtocolAssetDiscovery;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.value.impl.ColourRGB;
import org.openremote.protocol.zwave.model.commandclasses.channel.value.ArrayValue;
import org.openremote.protocol.zwave.model.commandclasses.channel.value.Value;

public class ZWaveProtocol
extends AbstractProtocol<ZWaveAgent, ZWaveAgentLink>
implements ProtocolAssetDiscovery {
    public static final String PROTOCOL_DISPLAY_NAME = "Z-Wave";
    public static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, (String)ZWaveProtocol.class.getName());
    protected ZWaveNetwork network;
    protected Map<AttributeRef, Consumer<Value>> sensorValueConsumerMap = new HashMap<AttributeRef, Consumer<Value>>();

    public ZWaveProtocol(ZWaveAgent agent) {
        super(agent);
    }

    public String getProtocolName() {
        return PROTOCOL_DISPLAY_NAME;
    }

    public synchronized String getProtocolInstanceUri() {
        return this.network != null && this.network.ioClient != null ? this.network.ioClient.getClientUri() : "";
    }

    @Override
    protected synchronized void doStart(Container container) throws Exception {
        String serialPort = (String)((ZWaveAgent)this.agent).getSerialPort().orElseThrow(() -> new IllegalStateException("Invalid serial port property"));
        this.network = new ZWaveNetwork(serialPort, this.executorService);
        this.network.addConnectionStatusConsumer(x$0 -> this.setConnectionStatus((ConnectionStatus)x$0));
        this.network.connect();
    }

    @Override
    protected synchronized void doStop(Container container) throws Exception {
        if (this.network != null) {
            this.network.removeConnectionStatusConsumer(x$0 -> this.setConnectionStatus((ConnectionStatus)x$0));
            this.network.disconnect();
            this.network = null;
        }
    }

    @Override
    protected synchronized void doLinkAttribute(String assetId, Attribute<?> attribute, ZWaveAgentLink agentLink) {
        if (this.network == null) {
            return;
        }
        int nodeId = agentLink.getDeviceNodeId().orElse(0);
        int endpoint = agentLink.getDeviceEndpoint().orElse(0);
        String linkName = agentLink.getDeviceValue().orElse("");
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        Class clazz = attribute == null ? null : attribute.getType().getType();
        Consumer<Value> sensorValueConsumer = value -> this.updateLinkedAttribute(new AttributeState(attributeRef, this.toAttributeValue((Value)value, clazz)));
        this.sensorValueConsumerMap.put(attributeRef, sensorValueConsumer);
        this.network.addSensorValueConsumer(nodeId, endpoint, linkName, sensorValueConsumer);
    }

    @Override
    protected synchronized void doUnlinkAttribute(String assetId, Attribute<?> attribute, ZWaveAgentLink agentLink) {
        if (this.network == null) {
            return;
        }
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        Consumer<Value> sensorValueConsumer = this.sensorValueConsumerMap.remove(attributeRef);
        this.network.removeSensorValueConsumer(sensorValueConsumer);
    }

    @Override
    protected synchronized void doLinkedAttributeWrite(Attribute<?> attribute, ZWaveAgentLink agentLink, AttributeEvent event, Object processedValue) {
        if (this.network == null) {
            return;
        }
        int nodeId = (Integer)AgentLink.getOrThrowAgentLinkProperty(agentLink.getDeviceNodeId(), (String)"device node ID");
        int endpoint = (Integer)AgentLink.getOrThrowAgentLinkProperty(agentLink.getDeviceEndpoint(), (String)"device endpoint");
        String linkName = (String)AgentLink.getOrThrowAgentLinkProperty(agentLink.getDeviceValue(), (String)"device property");
        this.network.writeChannel(nodeId, endpoint, linkName, processedValue);
    }

    public synchronized Future<Void> startAssetDiscovery(Consumer<AssetTreeNode[]> assetConsumer) {
        if (this.network == null || this.network.getConnectionStatus() != ConnectionStatus.CONNECTED) {
            LOG.info("Network not connected so cannot perform discovery");
            return CompletableFuture.completedFuture(null);
        }
        return this.executorService.submit(() -> {
            try {
                AssetTreeNode[] assetTreeNodes = this.network.discoverDevices((ZWaveAgent)this.agent);
                assetConsumer.accept(assetTreeNodes);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Exception thrown during asset discovery: " + this, e);
            }
        }, null);
    }

    private Object toAttributeValue(Value value, Class<?> clazz) {
        if (value == null || clazz == null) {
            return null;
        }
        Object retValue = null;
        if (clazz == String.class) {
            retValue = value.getString();
        } else if (clazz == Boolean.class) {
            retValue = value.getBoolean();
        } else if (clazz == Double.class) {
            retValue = value.getNumber();
        } else if (clazz == Integer.class) {
            retValue = value.getInteger();
        } else if (clazz == ColourRGB.class && value instanceof ArrayValue) {
            ArrayValue zwArray = (ArrayValue)value;
            if (zwArray.length() >= 3) {
                ArrayList<Object> values = new ArrayList<Object>(zwArray.length());
                for (int i = 0; i < zwArray.length(); ++i) {
                    values.add(this.toAttributeValue(zwArray.get(i), Integer.class));
                }
                if (values.stream().anyMatch(val -> val == null)) {
                    return null;
                }
                int offset = zwArray.length() == 3 ? 0 : 1;
                retValue = new ColourRGB(((Integer)values.get(0 + offset)).intValue(), ((Integer)values.get(1 + offset)).intValue(), ((Integer)values.get(2 + offset)).intValue());
            }
        } else {
            LOG.warning("Couldn't update Z-Wave sensor value because of unexpected attribute type: " + clazz);
        }
        return retValue;
    }
}

