/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.zwave;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.openremote.agent.protocol.zwave.ChannelConsumerLink;
import org.openremote.agent.protocol.zwave.NettyConnectionManager;
import org.openremote.agent.protocol.zwave.TypeMapper;
import org.openremote.agent.protocol.zwave.ZWaveAgent;
import org.openremote.agent.protocol.zwave.ZWaveAgentLink;
import org.openremote.agent.protocol.zwave.ZWaveProtocol;
import org.openremote.agent.protocol.zwave.ZWaveSerialIOClient;
import org.openremote.controller.exception.ConfigurationException;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.AssetTreeNode;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.asset.impl.ThingAsset;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.MetaItem;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.AbstractNameValueHolder;
import org.openremote.model.value.MetaItemType;
import org.openremote.model.value.ValueType;
import org.openremote.model.value.impl.ColourRGB;
import org.openremote.protocol.zwave.ConnectionException;
import org.openremote.protocol.zwave.ZWConnectionManager;
import org.openremote.protocol.zwave.model.Controller;
import org.openremote.protocol.zwave.model.ZWEndPoint;
import org.openremote.protocol.zwave.model.ZWManufacturerID;
import org.openremote.protocol.zwave.model.ZWNodeInitializerListener;
import org.openremote.protocol.zwave.model.ZWaveNode;
import org.openremote.protocol.zwave.model.commandclasses.ZWCommandClass;
import org.openremote.protocol.zwave.model.commandclasses.ZWCommandClassID;
import org.openremote.protocol.zwave.model.commandclasses.ZWParameterByte;
import org.openremote.protocol.zwave.model.commandclasses.ZWParameterInt;
import org.openremote.protocol.zwave.model.commandclasses.ZWParameterItem;
import org.openremote.protocol.zwave.model.commandclasses.ZWParameterShort;
import org.openremote.protocol.zwave.model.commandclasses.channel.Channel;
import org.openremote.protocol.zwave.model.commandclasses.channel.value.ArrayValue;
import org.openremote.protocol.zwave.model.commandclasses.channel.value.BooleanValue;
import org.openremote.protocol.zwave.model.commandclasses.channel.value.NumberValue;
import org.openremote.protocol.zwave.model.commandclasses.channel.value.StringValue;
import org.openremote.protocol.zwave.model.commandclasses.channel.value.Value;
import org.openremote.protocol.zwave.port.ZWavePortConfiguration;

public class ZWaveNetwork {
    protected Controller controller;
    private final List<Consumer<ConnectionStatus>> connectionStatusConsumers = new CopyOnWriteArrayList<Consumer<ConnectionStatus>>();
    private final Map<Consumer<Value>, ChannelConsumerLink> consumerLinkMap = new HashMap<Consumer<Value>, ChannelConsumerLink>();
    protected String serialPort;
    protected ZWaveSerialIOClient ioClient;
    protected ScheduledExecutorService executorService;

    public ZWaveNetwork(String serialPort, ScheduledExecutorService executorService) {
        this.serialPort = serialPort;
        this.executorService = executorService;
    }

    public synchronized void connect() {
        if (this.controller != null) {
            return;
        }
        ZWavePortConfiguration configuration = new ZWavePortConfiguration();
        configuration.setCommLayer(ZWavePortConfiguration.CommLayer.NETTY);
        configuration.setComPort(this.serialPort);
        this.ioClient = new ZWaveSerialIOClient(this.serialPort);
        this.ioClient.addConnectionStatusConsumer(this::onConnectionStatusChanged);
        this.controller = new Controller((ZWConnectionManager)NettyConnectionManager.create(configuration, this.ioClient));
        try {
            this.controller.connect();
        }
        catch (ConfigurationException | ConnectionException e) {
            this.disposeClient();
            this.controller = null;
            this.ioClient = null;
            this.onConnectionStatusChanged(ConnectionStatus.ERROR);
        }
    }

    public synchronized void disconnect() {
        if (this.controller == null) {
            return;
        }
        try {
            this.controller.disconnect();
        }
        catch (ConnectionException e) {
            ZWaveProtocol.LOG.log(Level.WARNING, "Exception thrown whilst disconnecting the controller", e);
        }
        finally {
            this.disposeClient();
            this.ioClient = null;
            this.controller = null;
            this.onConnectionStatusChanged(ConnectionStatus.DISCONNECTED);
        }
    }

    public synchronized ConnectionStatus getConnectionStatus() {
        if (this.ioClient != null) {
            return this.ioClient.getConnectionStatus();
        }
        return ConnectionStatus.DISCONNECTED;
    }

    public synchronized void addConnectionStatusConsumer(Consumer<ConnectionStatus> connectionStatusConsumer) {
        this.connectionStatusConsumers.add(connectionStatusConsumer);
    }

    public synchronized void removeConnectionStatusConsumer(Consumer<ConnectionStatus> connectionStatusConsumer) {
        this.connectionStatusConsumers.remove(connectionStatusConsumer);
    }

    public synchronized void addSensorValueConsumer(int nodeId, int endpoint, String channelName, Consumer<Value> consumer) {
        ChannelConsumerLink link = ChannelConsumerLink.createLink(nodeId, endpoint, channelName, consumer, this.controller);
        this.consumerLinkMap.put(consumer, link);
    }

    public synchronized void removeSensorValueConsumer(Consumer<Value> consumer) {
        ChannelConsumerLink link = this.consumerLinkMap.get(consumer);
        if (link != null) {
            this.consumerLinkMap.remove(consumer);
            link.unlink();
        }
    }

    public synchronized void writeChannel(int nodeId, int endpoint, String linkName, Object value) {
        org.openremote.protocol.zwave.model.commandclasses.channel.value.ValueType type;
        Value zwValue;
        Channel channel = this.findChannel(nodeId, endpoint, linkName);
        if (channel != null && value != null && (zwValue = this.toZWValue(type = channel.getValueType(), value)) != null) {
            channel.executeSetCommand(zwValue);
        }
    }

    private void disposeClient() {
        if (this.ioClient != null) {
            this.ioClient.removeConnectionStatusConsumer(this::onConnectionStatusChanged);
            this.ioClient.disconnect();
        }
    }

    protected void onConnectionStatusChanged(ConnectionStatus status) {
        this.connectionStatusConsumers.forEach(consumer -> consumer.accept(status));
    }

    protected Value toZWValue(org.openremote.protocol.zwave.model.commandclasses.channel.value.ValueType type, Object value) {
        Value zwValue = null;
        switch (type) {
            case STRING: {
                zwValue = ValueUtil.getString((Object)value).map(StringValue::new).orElse(null);
                break;
            }
            case NUMBER: {
                zwValue = ValueUtil.getDouble((Object)value).map(NumberValue::new).orElse(null);
                break;
            }
            case INTEGER: {
                zwValue = ValueUtil.getInteger((Object)value).map(NumberValue::new).orElse(null);
                break;
            }
            case BOOLEAN: {
                zwValue = ValueUtil.getBoolean((Object)value).map(BooleanValue::new).orElse(null);
                break;
            }
            case ARRAY: {
                if (!(value instanceof ColourRGB)) break;
                ArrayValue zwArray = new ArrayValue();
                zwArray.add((Value)new NumberValue((double)((ColourRGB)value).getR()));
                zwArray.add((Value)new NumberValue((double)((ColourRGB)value).getG()));
                zwArray.add((Value)new NumberValue((double)((ColourRGB)value).getB()));
                zwValue = zwArray;
            }
        }
        return zwValue;
    }

    private static void addAttributeChannelMetaItems(String agentId, Attribute<?> attribute, Channel channel) {
        int nodeId = channel.getCommandClass() != null ? channel.getCommandClass().getContext().getNodeID() : 0;
        int endpoint = channel.getCommandClass() != null ? channel.getCommandClass().getContext().getDestEndPoint() : 0;
        String linkValue = channel.getLinkName();
        ZWaveAgentLink agentLink = new ZWaveAgentLink(agentId, nodeId, endpoint, linkValue);
        attribute.addOrReplaceMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, (Object)agentLink), new MetaItem(MetaItemType.LABEL, (Object)channel.getDisplayName())});
        if (channel.isReadOnly()) {
            attribute.getMeta().add((AbstractNameValueHolder)new MetaItem(MetaItemType.READ_ONLY, (Object)true));
        }
    }

    private Channel findChannel(int nodeId, int endpointNumber, String channelName) {
        Channel channel = null;
        if (this.controller != null) {
            channel = this.controller.findChannel(nodeId, endpointNumber, channelName);
        }
        return channel;
    }

    public synchronized AssetTreeNode[] discoverDevices(ZWaveAgent agent) {
        if (this.controller == null) {
            return new AssetTreeNode[0];
        }
        List nodes = this.controller.getNodes().stream().filter(node -> node.getState() == ZWNodeInitializerListener.NodeInitState.INITIALIZATION_FINISHED).filter(node -> {
            ArrayList cmdClasses = new ArrayList(node.getSupportedCommandClasses());
            for (ZWEndPoint curEndpoint : node.getEndPoints()) {
                cmdClasses.addAll(curEndpoint.getCmdClasses());
            }
            return cmdClasses.stream().map(ZWCommandClass::getChannels).flatMap(Collection::stream).noneMatch(channel -> this.consumerLinkMap.values().stream().anyMatch(link -> link.getChannel() == channel));
        }).collect(Collectors.toList());
        List<AssetTreeNode> assetNodes = nodes.stream().map(node -> {
            AssetTreeNode deviceNode = this.createDeviceNode(agent.getId(), node.getSupportedCommandClasses(), node.getGenericDeviceClassID().getDisplayName(node.getSpecificDeviceClassID()));
            ThingAsset deviceInfoAsset = new ThingAsset("Info");
            deviceInfoAsset.getAttributes().addAll(ZWaveNetwork.createNodeInfoAttributes(agent.getId(), node));
            deviceNode.addChild(new AssetTreeNode((Asset)deviceInfoAsset));
            for (ZWEndPoint curEndpoint : node.getEndPoints()) {
                String subDeviceName = curEndpoint.getGenericDeviceClassID().getDisplayName(curEndpoint.getSpecificDeviceClassID()) + " - " + curEndpoint.getEndPointNumber();
                AssetTreeNode subDeviceNode = this.createDeviceNode(agent.getId(), curEndpoint.getCmdClasses(), subDeviceName);
                deviceNode.addChild(subDeviceNode);
            }
            List parameters = node.getParameters();
            if (parameters.size() > 0) {
                AssetTreeNode parameterListNode = new AssetTreeNode((Asset)new ThingAsset("Parameters"));
                deviceNode.addChild(parameterListNode);
                List<AssetTreeNode> parameterNodes = parameters.stream().filter(parameter -> parameter.getChannels().size() > 0).map(parameter -> {
                    int number = parameter.getNumber();
                    String parameterLabel = number + " : " + parameter.getDisplayName();
                    String description = parameter.getDescription();
                    ThingAsset parameterAsset = new ThingAsset(parameterLabel);
                    AssetTreeNode parameterNode = new AssetTreeNode((Asset)parameterAsset);
                    List attributes = parameter.getChannels().stream().map(channel -> {
                        Attribute<?> attribute = TypeMapper.createAttribute(channel.getName(), channel.getChannelType());
                        ZWaveNetwork.addAttributeChannelMetaItems(agent.getId(), attribute, channel);
                        this.addValidRangeMeta(attribute, (ZWParameterItem)parameter);
                        return attribute;
                    }).collect(Collectors.toList());
                    if (description != null && description.length() > 0) {
                        Attribute descriptionAttribute = new Attribute("description", ValueType.TEXT, (Object)description);
                        descriptionAttribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Description"), new MetaItem(MetaItemType.READ_ONLY, (Object)true)});
                        attributes.add(descriptionAttribute);
                    }
                    parameterAsset.getAttributes().addAll(attributes);
                    return parameterNode;
                }).collect(Collectors.toList());
                parameterNodes.forEach(arg_0 -> ((AssetTreeNode)parameterListNode).addChild(arg_0));
            }
            return deviceNode;
        }).collect(Collectors.toList());
        ThingAsset networkManagementAsset = new ThingAsset("Z-Wave Controller");
        List attributes = this.controller.getSystemCommandManager().getChannels().stream().filter(channel -> this.consumerLinkMap.values().stream().noneMatch(link -> link.getChannel() == channel)).map(channel -> {
            Attribute<?> attribute = TypeMapper.createAttribute(channel.getName(), channel.getChannelType());
            ZWaveNetwork.addAttributeChannelMetaItems(agent.getId(), attribute, channel);
            return attribute;
        }).collect(Collectors.toList());
        if (attributes.size() > 0) {
            networkManagementAsset.getAttributes().addAll(attributes);
            assetNodes.add(new AssetTreeNode((Asset)networkManagementAsset));
        }
        return assetNodes.toArray(new AssetTreeNode[0]);
    }

    private AssetTreeNode createDeviceNode(String agentId, List<ZWCommandClass> cmdClasses, String name) {
        ThingAsset device = new ThingAsset(name);
        List attributes = cmdClasses.stream().filter(commandClass -> commandClass.getID().toRaw() != ZWCommandClassID.COMMAND_CLASS_CONFIGURATION.toRaw() && commandClass.getID().toRaw() != ZWCommandClassID.COMMAND_CLASS_ZWAVEPLUS_INFO.toRaw() && commandClass.getID().toRaw() != ZWCommandClassID.COMMAND_CLASS_NO_OPERATION.toRaw() && commandClass.getID().toRaw() != ZWCommandClassID.COMMAND_CLASS_BASIC.toRaw()).map(ZWCommandClass::getChannels).flatMap(Collection::stream).map(channel -> {
            int endpoint = channel.getCommandClass().getContext().getDestEndPoint();
            String attributeName = channel.getName() + (String)(endpoint == 0 ? "" : "_" + endpoint);
            String displayName = channel.getDisplayName() + (String)(endpoint == 0 ? "" : " - " + endpoint);
            Attribute<?> attribute = TypeMapper.createAttribute(attributeName, channel.getChannelType());
            ZWaveNetwork.addAttributeChannelMetaItems(agentId, attribute, channel);
            attribute.addOrReplaceMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)displayName)});
            return attribute;
        }).collect(Collectors.toList());
        device.getAttributes().addOrReplace(attributes);
        return new AssetTreeNode((Asset)device);
    }

    private static List<Attribute<?>> createNodeInfoAttributes(String agentId, ZWaveNode node) {
        ArrayList attributes = new ArrayList();
        Attribute nodeIdAttrib = new Attribute("nodeId", ValueType.INTEGER, (Object)node.getNodeID()).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Node ID"), new MetaItem(MetaItemType.READ_ONLY, (Object)true)});
        attributes.add(nodeIdAttrib);
        Attribute manufacturerIdAttrib = new Attribute("manufacturerId", ValueType.TEXT, (Object)String.format("0x%04X", node.getManufacturerId()));
        manufacturerIdAttrib.addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Manufacturer ID"), new MetaItem(MetaItemType.READ_ONLY, (Object)true)});
        attributes.add(manufacturerIdAttrib);
        Attribute manufacturerAttrib = new Attribute("manufacturerName", ValueType.TEXT, (Object)ZWManufacturerID.fromRaw((int)node.getManufacturerId()).getName());
        manufacturerAttrib.addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Manufacturer"), new MetaItem(MetaItemType.READ_ONLY, (Object)true)});
        attributes.add(manufacturerAttrib);
        Attribute flirsAttrib = new Attribute("isFlirs", ValueType.BOOLEAN, (Object)node.getNodeInfo().isFLIRS());
        flirsAttrib.addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"FLIRS"), new MetaItem(MetaItemType.READ_ONLY, (Object)true)});
        attributes.add(flirsAttrib);
        Attribute routingAttrib = new Attribute("isRouting", ValueType.BOOLEAN, (Object)node.getNodeInfo().isRouting());
        routingAttrib.addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Routing"), new MetaItem(MetaItemType.READ_ONLY, (Object)true)});
        attributes.add(routingAttrib);
        Attribute listeningAttrib = new Attribute("isListening", ValueType.BOOLEAN, (Object)node.getNodeInfo().isListening());
        listeningAttrib.addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Listening"), new MetaItem(MetaItemType.READ_ONLY, (Object)true)});
        attributes.add(listeningAttrib);
        Attribute productTypeIdAttrib = new Attribute("productTypeId", ValueType.TEXT, (Object)String.format("0x%04X", node.getProductTypeID()));
        productTypeIdAttrib.addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Product Type ID"), new MetaItem(MetaItemType.READ_ONLY, (Object)true)});
        attributes.add(productTypeIdAttrib);
        Attribute productIdAttrib = new Attribute("productId", ValueType.TEXT, (Object)String.format("0x%04X", node.getProductID()));
        productIdAttrib.addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Product ID"), new MetaItem(MetaItemType.READ_ONLY, (Object)true)});
        attributes.add(productIdAttrib);
        String modelName = node.getModelName();
        if (modelName != null) {
            Attribute modelNameAttrib = new Attribute("modelName", ValueType.TEXT, (Object)modelName);
            modelNameAttrib.addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Model"), new MetaItem(MetaItemType.READ_ONLY, (Object)true)});
            attributes.add(modelNameAttrib);
        }
        List zwPlusAttributes = node.getSupportedCommandClasses().stream().filter(commandClass -> commandClass.getID().toRaw() == ZWCommandClassID.COMMAND_CLASS_ZWAVEPLUS_INFO.toRaw()).map(ZWCommandClass::getChannels).flatMap(Collection::stream).map(channel -> {
            String attributeName = channel.getName();
            Attribute<?> attribute = TypeMapper.createAttribute(attributeName, channel.getChannelType());
            ZWaveNetwork.addAttributeChannelMetaItems(agentId, attribute, channel);
            return attribute;
        }).collect(Collectors.toList());
        attributes.addAll(zwPlusAttributes);
        return attributes;
    }

    private void addValidRangeMeta(Attribute<?> attribute, ZWParameterItem parameter) {
        Long min = null;
        Long max = null;
        if (parameter instanceof ZWParameterByte) {
            min = ((ZWParameterByte)parameter).getMinValue();
            max = ((ZWParameterByte)parameter).getMaxValue();
        } else if (parameter instanceof ZWParameterShort) {
            min = ((ZWParameterShort)parameter).getMinValue();
            max = ((ZWParameterShort)parameter).getMaxValue();
        } else if (parameter instanceof ZWParameterInt) {
            min = ((ZWParameterInt)parameter).getMinValue();
            max = ((ZWParameterInt)parameter).getMaxValue();
        }
    }
}

