/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.zwave;

import java.util.HashMap;
import java.util.Map;
import org.openremote.model.Constants;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.MetaItem;
import org.openremote.model.value.MetaItemType;
import org.openremote.model.value.ValueConstraint;
import org.openremote.model.value.ValueDescriptor;
import org.openremote.model.value.ValueFormat;
import org.openremote.model.value.ValueType;
import org.openremote.protocol.zwave.model.commandclasses.channel.ChannelType;

public class TypeMapper {
    private static final Map<ChannelType, TypeInfo> typeMap = new HashMap<ChannelType, TypeInfo>();

    public static Attribute<?> createAttribute(String name, ChannelType channelType) {
        ValueDescriptor valueType = ValueType.TEXT;
        ValueConstraint[] constraints = null;
        ValueFormat format = null;
        String[] units = null;
        if (typeMap.containsKey(channelType)) {
            TypeInfo typeInfo = typeMap.get(channelType);
            valueType = typeInfo.valueDescriptor;
            constraints = typeInfo.constraints;
            format = typeInfo.valueFormat;
            units = typeInfo.units;
        } else {
            switch (channelType.getValueType()) {
                case INTEGER: {
                    valueType = ValueType.INTEGER;
                    break;
                }
                case NUMBER: {
                    valueType = ValueType.NUMBER;
                    break;
                }
                case BOOLEAN: {
                    valueType = ValueType.BOOLEAN;
                    break;
                }
                case STRING: {
                    valueType = ValueType.TEXT;
                    break;
                }
                case ARRAY: {
                    valueType = ValueDescriptor.UNKNOWN.asArray();
                }
            }
        }
        Attribute attribute = new Attribute(name, valueType);
        if (constraints != null) {
            attribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.CONSTRAINTS, (Object)constraints)});
        }
        if (format != null) {
            attribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.FORMAT, (Object)format)});
        }
        if (units != null) {
            attribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.UNITS, (Object)units)});
        }
        return attribute;
    }

    static {
        typeMap.put(ChannelType.INTEGER, new TypeInfo(ValueType.INTEGER));
        typeMap.put(ChannelType.NUMBER, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.STRING, new TypeInfo(ValueType.TEXT));
        typeMap.put(ChannelType.BOOLEAN, new TypeInfo(ValueType.BOOLEAN));
        typeMap.put(ChannelType.ARRAY, new TypeInfo(ValueType.JSON_OBJECT.asArray()));
        typeMap.put(ChannelType.TEMPERATURE_CELSIUS, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"celsius"}), ValueFormat.NUMBER_1_DP()));
        typeMap.put(ChannelType.TEMPERATURE_FAHRENHEIT, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"fahrenheit"}), ValueFormat.NUMBER_1_DP()));
        typeMap.put(ChannelType.PERCENTAGE, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"percentage"})));
        typeMap.put(ChannelType.LUMINANCE_PERCENTAGE, new TypeInfo(ValueType.INTEGER, Constants.units((String[])new String[]{"percentage"}), null, ValueConstraint.constraints((ValueConstraint[])new ValueConstraint[]{new ValueConstraint.Min((Number)0), new ValueConstraint.Max((Number)100)})));
        typeMap.put(ChannelType.LUMINANCE_LUX, new TypeInfo(ValueType.INTEGER, Constants.units((String[])new String[]{"lux"})));
        typeMap.put(ChannelType.POWER_WATT, new TypeInfo(ValueType.INTEGER, Constants.units((String[])new String[]{"watt"})));
        typeMap.put(ChannelType.POWER_BTU_H, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"btu", "per", "hour"})));
        typeMap.put(ChannelType.HUMIDITY_PERCENTAGE, new TypeInfo(ValueType.INTEGER, Constants.units((String[])new String[]{"percentage"})));
        typeMap.put(ChannelType.HUMIDITY_ABSOLUTE, new TypeInfo(ValueType.INTEGER.withUnits(new String[]{"gram", "per", "metre", "cubed"})));
        typeMap.put(ChannelType.SPEED_MS, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"metre", "per", "second"})));
        typeMap.put(ChannelType.SPEED_MPH, new TypeInfo(ValueType.INTEGER.withUnits(new String[]{"mile", "per", "hour"})));
        typeMap.put(ChannelType.DIRECTION_DECIMAL_DEGREES, new TypeInfo(ValueType.INTEGER, Constants.units((String[])new String[]{"degree"})));
        typeMap.put(ChannelType.PRESSURE_KPA, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"kilo", "pascal"})));
        typeMap.put(ChannelType.PRESSURE_IN_HG, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"inch_mercury"})));
        typeMap.put(ChannelType.SOLAR_RADIATION_WATT_M2, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"watt", "per", "metre", "squared"})));
        typeMap.put(ChannelType.DEW_POINT_CELSIUS, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"celsius"})));
        typeMap.put(ChannelType.DEW_POINT_FAHRENHEIT, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"fahrenheit"})));
        typeMap.put(ChannelType.RAINFALL_MMPH, new TypeInfo(ValueType.INTEGER.withUnits(new String[]{"milli", "metre", "per", "hour"})));
        typeMap.put(ChannelType.RAINFALL_INPH, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"inch", "per", "hour"})));
        typeMap.put(ChannelType.TIDE_LEVEL_M, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"metre"})));
        typeMap.put(ChannelType.TIDE_LEVEL_FT, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"foot"})));
        typeMap.put(ChannelType.WEIGHT_KG, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"kilo", "gram"})));
        typeMap.put(ChannelType.WEIGHT_LB, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"pound"})));
        typeMap.put(ChannelType.VOLTAGE_V, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"volt"})));
        typeMap.put(ChannelType.VOLTAGE_MV, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"milli", "volt"})));
        typeMap.put(ChannelType.CURRENT_A, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"amp"})));
        typeMap.put(ChannelType.CURRENT_MA, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"milli", "amp"})));
        typeMap.put(ChannelType.CO2_PPM, new TypeInfo(ValueType.INTEGER, Constants.units((String[])new String[]{"ppm"})));
        typeMap.put(ChannelType.AIR_FLOW_CMPH, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"metre", "cubed", "per", "minute"})));
        typeMap.put(ChannelType.AIR_FLOW_CFTPM, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"foot", "cubed", "per", "minute"})));
        typeMap.put(ChannelType.TANK_CAPACITY_L, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"litre"})));
        typeMap.put(ChannelType.TANK_CAPACITY_CBM, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"metre", "cubed"})));
        typeMap.put(ChannelType.TANK_CAPACITY_GAL, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"gallon"})));
        typeMap.put(ChannelType.DISTANCE_M, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"metre"})));
        typeMap.put(ChannelType.DISTANCE_CM, new TypeInfo(ValueType.POSITIVE_NUMBER.withUnits(new String[]{"centi", "metre"})));
        typeMap.put(ChannelType.DISTANCE_FT, new TypeInfo(ValueType.POSITIVE_NUMBER, Constants.units((String[])new String[]{"foot"})));
        typeMap.put(ChannelType.ANGLE_POSITION_PERCENT, new TypeInfo(ValueType.INTEGER, Constants.units((String[])new String[]{"percentage"}), null, ValueConstraint.constraints((ValueConstraint[])new ValueConstraint[]{new ValueConstraint.Min((Number)0), new ValueConstraint.Max((Number)100)})));
        typeMap.put(ChannelType.ANGLE_POSITION_DEGREE_NORTH_POLE, new TypeInfo(ValueType.INTEGER, Constants.units((String[])new String[]{"degree"})));
        typeMap.put(ChannelType.ANGLE_POSITION_DEGREE_SOUTH_POLE, new TypeInfo(ValueType.INTEGER, Constants.units((String[])new String[]{"degree"})));
        typeMap.put(ChannelType.ROTATION_HZ, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"hertz"})));
        typeMap.put(ChannelType.ROTATION_RPM, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"rpm"})));
        typeMap.put(ChannelType.WATER_TEMPERATURE_CELSIUS, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"celsius"})));
        typeMap.put(ChannelType.WATER_TEMPERATURE_FAHRENHEIT, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"fahrenheit"})));
        typeMap.put(ChannelType.SOIL_TEMPERATURE_CELSIUS, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"celsius"})));
        typeMap.put(ChannelType.SOIL_TEMPERATURE_FAHRENHEIT, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"fahrenheit"})));
        typeMap.put(ChannelType.SEISMIC_INTENSITY_MERCALLI, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.SEISMIC_INTENSITY_EU_MACROSEISMIC, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.SEISMIC_INTENSITY_LIEDU, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.SEISMIC_INTENSITY_SHINDO, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.SEISMIC_MAGNITUDE_LOCAL, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.SEISMIC_MAGNITUDE_MOMENT, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.SEISMIC_MAGNITUDE_SURFACE_WAVE, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.SEISMIC_MAGNITUDE_BODY_WAVE, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.ULTRAVIOLET_UV_INDEX, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.RESISTIVITY_OHM, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"ohm"})));
        typeMap.put(ChannelType.CONDUCTIVITY_SPM, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.LOUDNESS_DB, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"decibel"})));
        typeMap.put(ChannelType.LOUDNESS_DBA, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"decibel_attenuated"})));
        typeMap.put(ChannelType.MOISTURE_PERCENTAGE, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"percentage"})));
        typeMap.put(ChannelType.MOISTURE_VOLUME_WATER_CONTENT, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.MOISTURE_IMPEDANCE, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.MOISTURE_WATER_ACTIVITY, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.FREQUENCY_HZ, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"hertz"})));
        typeMap.put(ChannelType.FREQUENCY_KHZ, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"kilo", "hertz"})));
        typeMap.put(ChannelType.TIME_SECONDS, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"second"})));
        typeMap.put(ChannelType.TARGET_TEMPERATUE_CELSIUS, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"celsius"})));
        typeMap.put(ChannelType.TARGET_TEMPERATUE_FAHRENHEIT, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"fahrenheit"})));
        typeMap.put(ChannelType.PARTICULATE_MATTER_2_5_MOLPCM, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.PARTICULATE_MATTER_2_5_MCGPCM, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.FORMALDEHYDE_LEVEL_MOLPCM, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.RADON_CONCENTRATION_BQPCM, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.RADON_CONCENTRATION_PCIPL, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.METHANE_DENSITY_MOLPCM, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.VOLATILE_ORGANIC_COMPOUND_MOLPCM, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.VOLATILE_ORGANIC_COMPOUND_PPM, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.CO_MOLPCM, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.CO_PPM, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.SOIL_HUMIDITY_PERCENTAGE, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"percentage"})));
        typeMap.put(ChannelType.SOIL_REACTIVITY_PH, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.SOIL_SALINITY_MOLPCM, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.HEART_RATE_BPM, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.BLOOD_PRESSURE_SYSTOLIC, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.BLOOD_PRESSURE_DIASTOLIC, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.MUSCLE_MASS_KG, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"kilo", "gram"})));
        typeMap.put(ChannelType.FAT_MASS_KG, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"kilo", "gram"})));
        typeMap.put(ChannelType.BONE_MASS_KG, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"kilo", "gram"})));
        typeMap.put(ChannelType.TOTAL_BODY_WATER_KG, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"kilo", "gram"})));
        typeMap.put(ChannelType.BASIC_METABOLIC_RATE_JOULE, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"joule"})));
        typeMap.put(ChannelType.BODY_MASS_INDEX, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.ACCELERATION_X_MPSS, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"metre", "per", "second", "squared"})));
        typeMap.put(ChannelType.ACCELERATION_Y_MPSS, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"metre", "per", "second", "squared"})));
        typeMap.put(ChannelType.ACCELERATION_Z_MPSS, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"metre", "per", "second", "squared"})));
        typeMap.put(ChannelType.SMOKE_DENSITY_PERCENTAGE, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"percentage"})));
        typeMap.put(ChannelType.WATER_FLOW_LPH, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"litre", "per", "hour"})));
        typeMap.put(ChannelType.WATER_PRESSURE_KPA, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"kilo", "pascal"})));
        typeMap.put(ChannelType.RF_SIGNAL_STRENGTH_RSSI, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.RF_SIGNAL_STRENGTH_DBM, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.PARTICULATE_MATTER_MOLPCM, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.PARTICULATE_MATTER_MCGPCM, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.RESPIRATORY_RATE_BPM, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.ELECTRIC_METER_ENERGY_KWH, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"kilo", "watt", "per", "hour"})));
        typeMap.put(ChannelType.ELECTRIC_METER_ENERGY_KVAH, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"kilo", "watt", "per", "hour"})));
        typeMap.put(ChannelType.ELECTRIC_METER_POWER_W, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"watt"})));
        typeMap.put(ChannelType.ELECTRIC_METER_PULSE_COUNT, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.ELECTRIC_METER_VOLTAGE_V, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"volt"})));
        typeMap.put(ChannelType.ELECTRIC_METER_CURRENT_A, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"amp"})));
        typeMap.put(ChannelType.ELECTRIC_METER_POWER_FACTOR, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.ELECTRIC_METER_POWER_KVAR, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"kilo", "watt"})));
        typeMap.put(ChannelType.ELECTRIC_METER_ENERGY_KVARH, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"kilo", "watt", "per", "hour"})));
        typeMap.put(ChannelType.GAS_METER_VOLUME_CM, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"metre", "cubed"})));
        typeMap.put(ChannelType.GAS_METER_VOLUME_CFT, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"foot", "cubed"})));
        typeMap.put(ChannelType.GAS_METER_PULSE_COUNT, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.WATER_METER_VOLUME_CM, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"metre", "cubed"})));
        typeMap.put(ChannelType.WATER_METER_VOLUME_CFT, new TypeInfo(ValueType.NUMBER.withUnits(new String[]{"foot", "cubed"})));
        typeMap.put(ChannelType.WATER_METER_VOLUME_GAL, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"gallon"})));
        typeMap.put(ChannelType.WATER_METER_PULSE_COUNT, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.COLOR_WARM_WHITE, new TypeInfo(ValueType.INT_BYTE));
        typeMap.put(ChannelType.COLOR_COLD_WHITE, new TypeInfo(ValueType.INT_BYTE));
        typeMap.put(ChannelType.COLOR_RED, new TypeInfo(ValueType.INT_BYTE));
        typeMap.put(ChannelType.COLOR_GREEN, new TypeInfo(ValueType.INT_BYTE));
        typeMap.put(ChannelType.COLOR_BLUE, new TypeInfo(ValueType.INT_BYTE));
        typeMap.put(ChannelType.COLOR_AMBER, new TypeInfo(ValueType.INT_BYTE));
        typeMap.put(ChannelType.COLOR_CYAN, new TypeInfo(ValueType.INT_BYTE));
        typeMap.put(ChannelType.COLOR_PURPLE, new TypeInfo(ValueType.INT_BYTE));
        typeMap.put(ChannelType.COLOR_INDEXED, new TypeInfo(ValueType.NUMBER));
        typeMap.put(ChannelType.COLOR_RGB, new TypeInfo(ValueType.COLOUR_RGB));
        typeMap.put(ChannelType.COLOR_ARGB, new TypeInfo(ValueType.COLOUR_RGB));
        typeMap.put(ChannelType.GENERAL_PURPOSE_ALARM, new TypeInfo(ValueType.BOOLEAN, null, ValueFormat.BOOLEAN_ON_OFF()));
        typeMap.put(ChannelType.SMOKE_ALARM, new TypeInfo(ValueType.BOOLEAN, null, ValueFormat.BOOLEAN_ON_OFF()));
        typeMap.put(ChannelType.CO_ALARM, new TypeInfo(ValueType.BOOLEAN, null, ValueFormat.BOOLEAN_ON_OFF()));
        typeMap.put(ChannelType.CO2_ALARM, new TypeInfo(ValueType.BOOLEAN, null, ValueFormat.BOOLEAN_ON_OFF()));
        typeMap.put(ChannelType.HEAT_ALARM, new TypeInfo(ValueType.BOOLEAN, null, ValueFormat.BOOLEAN_ON_OFF()));
        typeMap.put(ChannelType.WATER_LEAK_ALARM, new TypeInfo(ValueType.BOOLEAN, null, ValueFormat.BOOLEAN_ON_OFF()));
        typeMap.put(ChannelType.FIRST_SUPPORTED_ALARM, new TypeInfo(ValueType.BOOLEAN, null, ValueFormat.BOOLEAN_ON_OFF()));
        typeMap.put(ChannelType.CHARGE_PERCENTAGE, new TypeInfo(ValueType.NUMBER, Constants.units((String[])new String[]{"percentage"})));
        typeMap.put(ChannelType.DATETIME, new TypeInfo(ValueType.TIMESTAMP_ISO8601));
    }

    public static final class TypeInfo {
        protected ValueDescriptor<?> valueDescriptor;
        protected String[] units;
        protected ValueConstraint[] constraints;
        protected ValueFormat valueFormat;

        public TypeInfo(ValueDescriptor<?> valueDescriptor) {
            this.valueDescriptor = valueDescriptor;
        }

        public TypeInfo(ValueDescriptor<?> valueDescriptor, String[] units) {
            this.valueDescriptor = valueDescriptor;
            this.units = units;
        }

        public TypeInfo(ValueDescriptor<?> valueDescriptor, String[] units, ValueFormat valueFormat) {
            this.valueDescriptor = valueDescriptor;
            this.units = units;
            this.valueFormat = valueFormat;
        }

        public TypeInfo(ValueDescriptor<?> valueDescriptor, String[] units, ValueFormat valueFormat, ValueConstraint[] constraints) {
            this.valueDescriptor = valueDescriptor;
            this.units = units;
            this.constraints = constraints;
            this.valueFormat = valueFormat;
        }
    }
}

