/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.zwave;

import java.util.function.Consumer;
import org.openremote.protocol.zwave.model.Controller;
import org.openremote.protocol.zwave.model.ControllerListener;
import org.openremote.protocol.zwave.model.ZWaveNode;
import org.openremote.protocol.zwave.model.commandclasses.channel.Channel;
import org.openremote.protocol.zwave.model.commandclasses.channel.ChannelListener;
import org.openremote.protocol.zwave.model.commandclasses.channel.value.Value;

public class ChannelConsumerLink
implements ChannelListener,
ControllerListener {
    private final Consumer<Value> consumer;
    private Channel channel;
    private final Controller controller;
    private final int nodeId;
    private final int endpoint;
    private final String channelName;

    public static ChannelConsumerLink createLink(int nodeId, int endpoint, String channelName, Consumer<Value> consumer, Controller controller) {
        Channel channel = null;
        channel = controller.findChannel(nodeId, endpoint, channelName);
        ChannelConsumerLink link = new ChannelConsumerLink(nodeId, endpoint, channelName, channel, consumer, controller);
        if (channel != null) {
            channel.addValueListener((ChannelListener)link);
        }
        controller.addListener((ControllerListener)link);
        return link;
    }

    private ChannelConsumerLink(int nodeId, int endpoint, String channelName, Channel channel, Consumer<Value> consumer, Controller controller) {
        this.nodeId = nodeId;
        this.endpoint = endpoint;
        this.channelName = channelName;
        this.channel = channel;
        this.consumer = consumer;
        this.controller = controller;
    }

    public synchronized void valueHasChanged(Channel channel, Value channelValue) {
        this.consumer.accept(channelValue);
    }

    public synchronized void onNodeAdded(ZWaveNode node) {
        if (this.channel == null && this.nodeId == node.getNodeID()) {
            this.channel = this.controller.findChannel(this.nodeId, this.endpoint, this.channelName);
            if (this.channel != null) {
                this.channel.addValueListener((ChannelListener)this);
            }
        }
    }

    public synchronized void onNodeRemoved(ZWaveNode node) {
        if (this.nodeId == node.getNodeID()) {
            if (this.channel != null) {
                this.channel.removeValueListener((ChannelListener)this);
            }
            this.controller.removeListener((ControllerListener)this);
        }
    }

    public synchronized Channel getChannel() {
        return this.channel;
    }

    public synchronized void unlink() {
        if (this.channel != null) {
            this.channel.removeValueListener((ChannelListener)this);
        }
        this.controller.removeListener((ControllerListener)this);
    }
}

