/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.openremote.agent.protocol.io.AbstractNettyIOClient;
import org.openremote.container.web.OAuthFilter;
import org.openremote.container.web.WebTargetBuilder;
import org.openremote.model.auth.OAuthGrant;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.TextUtil;

public class WebsocketIOClient<T>
extends AbstractNettyIOClient<T, InetSocketAddress> {
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, WebsocketIOClient.class);
    protected boolean useSsl;
    protected URI uri;
    protected SslContext sslCtx;
    protected WebSocketClientHandler handler;
    protected Map<String, List<String>> headers;
    protected OAuthGrant oAuthGrant;
    protected String authHeaderValue;
    protected String host;
    protected int port;
    protected CompletableFuture<Boolean> connectedFuture;

    public WebsocketIOClient(URI uri, Map<String, List<String>> headers, OAuthGrant oAuthGrant) {
        this.uri = uri;
        this.headers = headers;
        this.oAuthGrant = oAuthGrant;
        String scheme = uri.getScheme() == null ? "ws" : uri.getScheme();
        String string = this.host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
        this.port = uri.getPort() == -1 ? ("ws".equalsIgnoreCase(scheme) ? 80 : ("wss".equalsIgnoreCase(scheme) ? 443 : -1)) : uri.getPort();
        this.useSsl = "wss".equalsIgnoreCase(scheme);
    }

    @Override
    protected Class<? extends Channel> getChannelClass() {
        return NioSocketChannel.class;
    }

    @Override
    public String getClientUri() {
        return this.uri.toString();
    }

    @Override
    protected EventLoopGroup getWorkerGroup() {
        return new NioEventLoopGroup(1);
    }

    @Override
    protected ChannelFuture startChannel() {
        return this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.host, this.port));
    }

    @Override
    protected void initChannel(Channel channel) {
        try {
            this.sslCtx = this.useSsl ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
            DefaultHttpHeaders hdrs = new DefaultHttpHeaders();
            if (this.headers != null) {
                this.headers.forEach((arg_0, arg_1) -> ((HttpHeaders)hdrs).add(arg_0, arg_1));
            }
            if (this.authHeaderValue != null) {
                hdrs.set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)this.authHeaderValue);
            }
            this.handler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)this.uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)hdrs));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to initialise channel: " + this.getClientUri(), e);
            this.setPermanentError(e.getMessage());
            return;
        }
        super.initChannel(channel);
    }

    protected void onHandshakeComplete(ChannelFuture handshakeFuture) {
        super.onConnectedFutureComplete((Future<Void>)handshakeFuture, this.connectedFuture);
    }

    @Override
    protected void addEncodersDecoders(Channel channel) {
        if (this.sslCtx != null) {
            channel.pipeline().addLast(new ChannelHandler[]{this.sslCtx.newHandler(channel.alloc(), this.host, this.port)});
        }
        channel.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), WebSocketClientCompressionHandler.INSTANCE, this.handler});
        channel.pipeline().addLast(new ChannelHandler[]{new MessageToMessageEncoder<ByteBuf>(){

            protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
                out.add(new TextWebSocketFrame(msg));
            }
        }});
        super.addEncodersDecoders(channel);
        channel.pipeline().addLast(new ChannelHandler[]{new MessageToMessageEncoder<String>(){

            protected void encode(ChannelHandlerContext ctx, String msg, List<Object> out) {
                out.add(new TextWebSocketFrame(msg));
            }
        }});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected java.util.concurrent.Future<Boolean> doConnect() {
        if (this.oAuthGrant != null) {
            LOG.fine("Retrieving OAuth access token: " + this.getClientUri());
            try (ResteasyClient client = WebTargetBuilder.createClient((ExecutorService)this.executorService, (int)1, (long)10000L, null);){
                OAuthFilter oAuthFilter = new OAuthFilter(client, this.oAuthGrant);
                this.authHeaderValue = oAuthFilter.getAuthHeader();
                if (TextUtil.isNullOrEmpty((String)this.authHeaderValue)) {
                    throw new RuntimeException("Returned access token is null");
                }
                LOG.fine("Retrieved access token via OAuth: " + this.getClientUri());
            }
        }
        return super.doConnect();
    }

    @Override
    protected CompletableFuture<Boolean> createConnectedFuture() {
        this.connectedFuture = new CompletableFuture();
        return this.connectedFuture;
    }

    protected class WebSocketClientHandler
    extends SimpleChannelInboundHandler<Object> {
        private final WebSocketClientHandshaker handshaker;
        private ChannelPromise handshakeFuture;

        public WebSocketClientHandler(WebSocketClientHandshaker handshaker) {
            this.handshaker = handshaker;
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            this.handshakeFuture = ctx.newPromise();
        }

        public void channelActive(ChannelHandlerContext ctx) {
            this.handshaker.handshake(ctx.channel());
        }

        public void channelRead0(ChannelHandlerContext ctx, Object msg) {
            WebSocketFrame frame;
            Channel ch = ctx.channel();
            if (!this.handshaker.isHandshakeComplete()) {
                try {
                    this.handshaker.finishHandshake(ch, (FullHttpResponse)msg);
                    this.handshakeFuture.setSuccess();
                }
                catch (WebSocketHandshakeException e) {
                    this.handshakeFuture.setFailure((Throwable)e);
                }
                WebsocketIOClient.this.onHandshakeComplete((ChannelFuture)this.handshakeFuture);
                return;
            }
            if (msg instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)msg;
                LOG.severe("Websocket client unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ")");
            }
            if ((frame = (WebSocketFrame)msg) instanceof TextWebSocketFrame) {
                TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
                String str = textFrame.text();
                ctx.fireChannelRead((Object)str);
            } else if (frame instanceof PongWebSocketFrame) {
                LOG.finest("Websocket client pong received");
            } else if (frame instanceof CloseWebSocketFrame) {
                ch.close();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            LOG.log(Level.SEVERE, "Websocket client exception caught", cause);
            if (!this.handshakeFuture.isDone()) {
                this.handshakeFuture.setFailure(cause);
            }
            ctx.close();
            WebsocketIOClient.this.onDecodeException(ctx, cause);
        }
    }
}

