/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.websocket;

import io.netty.channel.ChannelHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.util.BasicAuthHelper;
import org.openremote.agent.protocol.io.AbstractNettyIOClient;
import org.openremote.agent.protocol.io.AbstractNettyIOClientProtocol;
import org.openremote.agent.protocol.io.IOAgent;
import org.openremote.agent.protocol.websocket.WebsocketAgent;
import org.openremote.agent.protocol.websocket.WebsocketAgentLink;
import org.openremote.agent.protocol.websocket.WebsocketHTTPSubscription;
import org.openremote.agent.protocol.websocket.WebsocketIOClient;
import org.openremote.agent.protocol.websocket.WebsocketSubscription;
import org.openremote.container.timer.TimerService;
import org.openremote.container.web.WebTargetBuilder;
import org.openremote.model.Container;
import org.openremote.model.asset.agent.AgentLink;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeExecuteStatus;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.attribute.AttributeState;
import org.openremote.model.auth.UsernamePassword;
import org.openremote.model.protocol.ProtocolUtil;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.Pair;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.ValueType;

public class WebsocketAgentProtocol
extends AbstractNettyIOClientProtocol<WebsocketAgentProtocol, WebsocketAgent, String, WebsocketIOClient<String>, WebsocketAgentLink> {
    public static final String PROTOCOL_DISPLAY_NAME = "Websocket Client";
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, WebsocketAgentProtocol.class);
    public static final int CONNECTED_SEND_DELAY_MILLIS = 2000;
    protected static final ResteasyClient resteasyClient = WebTargetBuilder.createClient((ExecutorService)org.openremote.container.Container.EXECUTOR_SERVICE);
    protected List<Runnable> protocolConnectedTasks;
    protected Map<AttributeRef, Runnable> attributeConnectedTasks;
    protected Map<String, List<String>> clientHeaders;
    protected final List<Pair<AttributeRef, Consumer<String>>> protocolMessageConsumers = new ArrayList<Pair<AttributeRef, Consumer<String>>>();

    public WebsocketAgentProtocol(WebsocketAgent agent) {
        super(agent);
    }

    public String getProtocolName() {
        return PROTOCOL_DISPLAY_NAME;
    }

    @Override
    protected void doStop(Container container) throws Exception {
        super.doStop(container);
        this.clientHeaders = null;
        this.protocolConnectedTasks = null;
        this.attributeConnectedTasks = null;
        this.protocolMessageConsumers.clear();
    }

    @Override
    protected Supplier<ChannelHandler[]> getEncoderDecoderProvider() {
        return WebsocketAgentProtocol.getGenericStringEncodersAndDecoders((AbstractNettyIOClient)this.client, (IOAgent)this.agent);
    }

    @Override
    protected void onMessageReceived(String message) {
        this.protocolMessageConsumers.forEach(c -> {
            if (c.value != null) {
                ((Consumer)c.value).accept(message);
            }
        });
    }

    @Override
    protected String createWriteMessage(Attribute<?> attribute, WebsocketAgentLink agentLink, AttributeEvent event, Object processedValue) {
        boolean isRequestStart;
        if (attribute.getType().equals((Object)ValueType.EXECUTION_STATUS) && !(isRequestStart = event.getValue().flatMap(v -> ValueUtil.getValue((Object)v, AttributeExecuteStatus.class)).map(status -> status == AttributeExecuteStatus.REQUEST_START).orElse(false).booleanValue())) {
            LOG.fine("Unsupported execution status: " + event);
            return null;
        }
        return (String)ValueUtil.convert((Object)processedValue, String.class);
    }

    @Override
    protected WebsocketIOClient<String> doCreateIoClient() throws Exception {
        String uriStr = ((WebsocketAgent)this.agent).getConnectUri().orElseThrow(() -> new IllegalArgumentException("Missing or invalid connectUri: " + this.agent));
        URI uri = new URI(uriStr);
        Optional oAuthGrant = ((WebsocketAgent)this.agent).getOAuthGrant();
        Optional usernameAndPassword = ((WebsocketAgent)this.agent).getUsernamePassword();
        Optional<ValueType.MultivaluedStringMap> headers = ((WebsocketAgent)this.agent).getConnectHeaders();
        Optional<WebsocketSubscription[]> subscriptions = ((WebsocketAgent)this.agent).getConnectSubscriptions();
        if (!oAuthGrant.isPresent() && usernameAndPassword.isPresent()) {
            String authValue = BasicAuthHelper.createHeader((String)((UsernamePassword)usernameAndPassword.get()).getUsername(), (String)((UsernamePassword)usernameAndPassword.get()).getPassword());
            headers = Optional.of(headers.map(h -> {
                h.remove((Object)"Authorization");
                h.replace((Object)"Authorization", Collections.singletonList(authValue));
                return h;
            }).orElseGet(() -> {
                ValueType.MultivaluedStringMap h = new ValueType.MultivaluedStringMap();
                h.put((Object)"Authorization", Collections.singletonList(authValue));
                return h;
            }));
        }
        this.clientHeaders = headers.orElse(null);
        WebsocketIOClient<String> websocketClient = new WebsocketIOClient<String>(uri, headers.orElse(null), oAuthGrant.orElse(null));
        Map finalHeaders = headers.orElse(null);
        subscriptions.ifPresent(websocketSubscriptions -> this.addProtocolConnectedTask(() -> this.doSubscriptions(finalHeaders, (WebsocketSubscription[])websocketSubscriptions)));
        return websocketClient;
    }

    @Override
    protected void setConnectionStatus(ConnectionStatus connectionStatus) {
        super.setConnectionStatus(connectionStatus);
        if (connectionStatus == ConnectionStatus.CONNECTED) {
            this.onConnected();
        }
    }

    @Override
    protected void doLinkAttribute(String assetId, Attribute<?> attribute, WebsocketAgentLink agentLink) {
        Optional<WebsocketSubscription[]> subscriptions = agentLink.getWebsocketSubscriptions();
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        subscriptions.ifPresent(websocketSubscriptions -> {
            Runnable task = () -> this.doSubscriptions(this.clientHeaders, (WebsocketSubscription[])websocketSubscriptions);
            this.addAttributeConnectedTask(attributeRef, task);
            if (((WebsocketIOClient)this.client).getConnectionStatus() == ConnectionStatus.CONNECTED) {
                this.executorService.schedule(task, 1000L, TimeUnit.MILLISECONDS);
            }
        });
        Consumer messageConsumer = ProtocolUtil.createGenericAttributeMessageConsumer((String)assetId, attribute, (AgentLink)((WebsocketAgent)this.agent).getAgentLink(attribute), () -> ((TimerService)this.timerService).getCurrentTimeMillis(), x$0 -> this.updateLinkedAttribute((AttributeState)x$0));
        if (messageConsumer != null) {
            this.protocolMessageConsumers.add((Pair<AttributeRef, Consumer<String>>)new Pair((Object)attributeRef, (Object)messageConsumer));
        }
    }

    @Override
    protected void doUnlinkAttribute(String assetId, Attribute<?> attribute, WebsocketAgentLink agentLink) {
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        this.protocolMessageConsumers.removeIf(attrRefConsumer -> ((AttributeRef)attrRefConsumer.key).equals((Object)attributeRef));
        this.attributeConnectedTasks.remove(attributeRef);
    }

    protected void onConnected() {
        if (this.protocolConnectedTasks != null) {
            this.executorService.schedule(() -> this.protocolConnectedTasks.forEach(Runnable::run), 2000L, TimeUnit.MILLISECONDS);
        }
        if (this.attributeConnectedTasks != null) {
            this.executorService.schedule(() -> this.attributeConnectedTasks.forEach((ref, task) -> task.run()), 2000L, TimeUnit.MILLISECONDS);
        }
    }

    protected void addProtocolConnectedTask(Runnable task) {
        if (this.protocolConnectedTasks == null) {
            this.protocolConnectedTasks = new ArrayList<Runnable>();
        }
        this.protocolConnectedTasks.add(task);
    }

    protected void addAttributeConnectedTask(AttributeRef attributeRef, Runnable task) {
        if (this.attributeConnectedTasks == null) {
            this.attributeConnectedTasks = new HashMap<AttributeRef, Runnable>();
        }
        this.attributeConnectedTasks.put(attributeRef, task);
    }

    protected void doSubscriptions(Map<String, List<String>> headers, WebsocketSubscription[] subscriptions) {
        LOG.info("Executing subscriptions for websocket: " + ((WebsocketIOClient)this.client).getClientUri());
        if (!TextUtil.isNullOrEmpty((String)((WebsocketIOClient)this.client).authHeaderValue)) {
            if (headers == null) {
                headers = new MultivaluedHashMap();
            }
            headers.remove("Authorization");
            headers.put("Authorization", Collections.singletonList(((WebsocketIOClient)this.client).authHeaderValue));
        }
        MultivaluedHashMap finalHeaders = headers;
        Arrays.stream(subscriptions).forEach(arg_0 -> this.lambda$doSubscriptions$15((Map)finalHeaders, arg_0));
    }

    protected void doSubscription(Map<String, List<String>> headers, WebsocketSubscription subscription) {
        if (subscription instanceof WebsocketHTTPSubscription) {
            URI uri;
            WebsocketHTTPSubscription httpSubscription = (WebsocketHTTPSubscription)subscription;
            if (TextUtil.isNullOrEmpty((String)httpSubscription.uri)) {
                LOG.warning("Websocket subscription missing or empty URI so skipping: " + subscription);
                return;
            }
            try {
                uri = new URI(httpSubscription.uri);
            }
            catch (URISyntaxException e) {
                LOG.warning("Websocket subscription invalid URI so skipping: " + subscription);
                return;
            }
            if (httpSubscription.method == null) {
                httpSubscription.method = WebsocketHTTPSubscription.Method.valueOf("GET");
            }
            if (TextUtil.isNullOrEmpty((String)httpSubscription.contentType)) {
                httpSubscription.contentType = "text/plain";
            }
            if (httpSubscription.headers != null) {
                Map<String, List<String>> finalHeaders = headers = headers != null ? new HashMap<String, List<String>>(headers) : new HashMap();
                httpSubscription.headers.forEach((header, values) -> {
                    if (values == null || values.isEmpty()) {
                        finalHeaders.remove(header);
                    } else {
                        ArrayList vals = new ArrayList(finalHeaders.compute((String)header, (h, l) -> l != null ? l : Collections.emptyList()));
                        vals.addAll(values);
                        finalHeaders.put((String)header, vals);
                    }
                });
            }
            WebTargetBuilder webTargetBuilder = new WebTargetBuilder(resteasyClient, uri);
            if (headers != null) {
                webTargetBuilder.setInjectHeaders(headers);
            }
            LOG.fine("Creating web target client for subscription '" + uri + "'");
            ResteasyWebTarget target = webTargetBuilder.build();
            Invocation invocation = httpSubscription.body == null ? target.request().build(httpSubscription.method.toString()) : target.request().build(httpSubscription.method.toString(), Entity.entity((Object)httpSubscription.body, (String)httpSubscription.contentType));
            Response response = invocation.invoke();
            response.close();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                LOG.warning("WebsocketHttpSubscription returned an un-successful response code: " + response.getStatus());
            }
        } else {
            ((WebsocketIOClient)this.client).sendMessage((String)ValueUtil.convert((Object)subscription.body, String.class));
        }
    }

    private /* synthetic */ void lambda$doSubscriptions$15(Map finalHeaders, WebsocketSubscription subscription) {
        this.doSubscription(finalHeaders, subscription);
    }
}

