/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.websocket;

import java.util.Optional;
import javax.persistence.Entity;
import org.openremote.agent.protocol.io.IOAgent;
import org.openremote.agent.protocol.websocket.WebsocketAgentLink;
import org.openremote.agent.protocol.websocket.WebsocketAgentProtocol;
import org.openremote.agent.protocol.websocket.WebsocketSubscription;
import org.openremote.model.asset.agent.AgentDescriptor;
import org.openremote.model.value.AttributeDescriptor;
import org.openremote.model.value.ValueConstraint;
import org.openremote.model.value.ValueDescriptor;
import org.openremote.model.value.ValueType;

@Entity
public class WebsocketAgent
extends IOAgent<WebsocketAgent, WebsocketAgentProtocol, WebsocketAgentLink> {
    public static final ValueDescriptor<WebsocketSubscription> WEBSOCKET_SUBSCRIPTION_VALUE_DESCRIPTOR = new ValueDescriptor("websocketSubscription", WebsocketSubscription.class, new ValueConstraint[0]);
    public static final AttributeDescriptor<String> CONNECT_URL = new AttributeDescriptor("connectURL", ValueType.WS_URL);
    public static final AttributeDescriptor<ValueType.MultivaluedStringMap> CONNECT_HEADERS = new AttributeDescriptor("connectHeaders", ValueType.MULTIVALUED_TEXT_MAP);
    public static final AttributeDescriptor<WebsocketSubscription[]> CONNECT_SUBSCRIPTIONS = new AttributeDescriptor("connectSubscriptions", WEBSOCKET_SUBSCRIPTION_VALUE_DESCRIPTOR.asArray());
    public static final AgentDescriptor<WebsocketAgent, WebsocketAgentProtocol, WebsocketAgentLink> DESCRIPTOR = new AgentDescriptor(WebsocketAgent.class, WebsocketAgentProtocol.class, WebsocketAgentLink.class, null);

    protected WebsocketAgent() {
    }

    public WebsocketAgent(String name) {
        super(name);
    }

    public Optional<String> getConnectUri() {
        return this.getAttributes().getValue(CONNECT_URL);
    }

    public WebsocketAgent setConnectURI(String value) {
        this.getAttributes().getOrCreate(CONNECT_URL).setValue((Object)value);
        return this;
    }

    public Optional<ValueType.MultivaluedStringMap> getConnectHeaders() {
        return this.getAttributes().getValue(CONNECT_HEADERS);
    }

    public WebsocketAgent setConnectHeaders(ValueType.MultivaluedStringMap value) {
        this.getAttributes().getOrCreate(CONNECT_HEADERS).setValue((Object)value);
        return this;
    }

    public Optional<WebsocketSubscription[]> getConnectSubscriptions() {
        return this.getAttributes().getValue(CONNECT_SUBSCRIPTIONS);
    }

    public WebsocketAgent setConnectSubscriptions(WebsocketSubscription[] value) {
        this.getAttributes().getOrCreate(CONNECT_SUBSCRIPTIONS).setValue((Object)value);
        return this;
    }

    public WebsocketAgentProtocol getProtocolInstance() {
        return new WebsocketAgentProtocol(this);
    }
}

