/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus.device;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.openremote.agent.protocol.velbus.AbstractVelbusProtocol;
import org.openremote.agent.protocol.velbus.device.AnalogInputProcessor;
import org.openremote.agent.protocol.velbus.device.AnalogOutputProcessor;
import org.openremote.agent.protocol.velbus.device.BlindProcessor;
import org.openremote.agent.protocol.velbus.device.CounterProcessor;
import org.openremote.agent.protocol.velbus.device.FeatureProcessor;
import org.openremote.agent.protocol.velbus.device.InputProcessor;
import org.openremote.agent.protocol.velbus.device.OLEDProcessor;
import org.openremote.agent.protocol.velbus.device.ProgramsProcessor;
import org.openremote.agent.protocol.velbus.device.RelayProcessor;
import org.openremote.agent.protocol.velbus.device.TemperatureProcessor;
import org.openremote.agent.protocol.velbus.device.ThermostatProcessor;

public enum VelbusDeviceType {
    UNKNOWN(0, false, new Class[0]),
    VMB4RYNO(17, false, RelayProcessor.class),
    VMB4RYLD(16, false, RelayProcessor.class),
    VMB1RYNO(27, false, RelayProcessor.class),
    VMB1RYNOS(41, false, RelayProcessor.class),
    VMB1RY(2, false, RelayProcessor.class),
    VMBGP1(30, true, InputProcessor.class, TemperatureProcessor.class, ThermostatProcessor.class, ProgramsProcessor.class),
    VMBGP2(31, true, InputProcessor.class, TemperatureProcessor.class, ThermostatProcessor.class, ProgramsProcessor.class),
    VMBGP4(32, true, InputProcessor.class, TemperatureProcessor.class, ThermostatProcessor.class, ProgramsProcessor.class),
    VMBGPO(33, true, InputProcessor.class, TemperatureProcessor.class, ThermostatProcessor.class, ProgramsProcessor.class, OLEDProcessor.class),
    VMBGPOD(40, true, InputProcessor.class, TemperatureProcessor.class, ThermostatProcessor.class, ProgramsProcessor.class, OLEDProcessor.class),
    VMB7IN(34, false, InputProcessor.class, ProgramsProcessor.class, CounterProcessor.class),
    VMB8PBU(22, false, InputProcessor.class, ProgramsProcessor.class),
    VMB6PBN(23, false, InputProcessor.class, ProgramsProcessor.class),
    VMBDMI(21, false, AnalogOutputProcessor.class),
    VMBDMIR(47, false, AnalogOutputProcessor.class),
    VMBDME(20, false, AnalogOutputProcessor.class),
    VMB4DC(18, false, AnalogOutputProcessor.class),
    VMB2BLE(29, false, BlindProcessor.class),
    VMB1BL(3, false, BlindProcessor.class),
    VMBGP4PIR(45, true, InputProcessor.class, TemperatureProcessor.class, ThermostatProcessor.class, ProgramsProcessor.class),
    VMBPIRM(42, false, InputProcessor.class, ProgramsProcessor.class),
    VMBPIRO(44, false, InputProcessor.class, TemperatureProcessor.class, ProgramsProcessor.class),
    VMBPIRC(43, false, InputProcessor.class, ProgramsProcessor.class),
    VMBMETEO(49, false, InputProcessor.class, TemperatureProcessor.class, AnalogInputProcessor.class, ProgramsProcessor.class),
    VMB4AN(50, false, InputProcessor.class, ProgramsProcessor.class, AnalogInputProcessor.class, AnalogOutputProcessor.class),
    VMB1TS(12, false, TemperatureProcessor.class, ThermostatProcessor.class);

    private static final Map<Class<? extends FeatureProcessor>, FeatureProcessor> processors;
    private final int code;
    private final boolean hasSubAddresses;
    private final Class<? extends FeatureProcessor>[] featureProcessors;

    @SafeVarargs
    private VelbusDeviceType(int code, boolean hasSubAddresses, Class<? extends FeatureProcessor> ... featureProcessors) {
        this.code = code;
        this.hasSubAddresses = hasSubAddresses;
        this.featureProcessors = featureProcessors;
    }

    public static VelbusDeviceType fromCode(int code) {
        for (VelbusDeviceType type : VelbusDeviceType.values()) {
            if (type.getCode() != code) continue;
            return type;
        }
        return UNKNOWN;
    }

    public int getCode() {
        return this.code;
    }

    public boolean hasSubAddresses() {
        return this.hasSubAddresses;
    }

    public FeatureProcessor[] getFeatureProcessors() {
        if (this.featureProcessors == null) {
            return null;
        }
        return (FeatureProcessor[])Arrays.stream(this.featureProcessors).map(processorClazz -> processors.computeIfAbsent((Class<? extends FeatureProcessor>)processorClazz, clazz -> {
            try {
                return (FeatureProcessor)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                AbstractVelbusProtocol.LOG.log(Level.SEVERE, "Failed to instantiate feature processor: " + clazz.getSimpleName(), e);
                return null;
            }
        })).filter(Objects::nonNull).toArray(FeatureProcessor[]::new);
    }

    static {
        processors = new HashMap<Class<? extends FeatureProcessor>, FeatureProcessor>();
    }
}

