/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus.device;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.openremote.agent.protocol.velbus.AbstractVelbusProtocol;
import org.openremote.agent.protocol.velbus.VelbusPacket;
import org.openremote.agent.protocol.velbus.device.FeatureProcessor;
import org.openremote.agent.protocol.velbus.device.InputProcessor;
import org.openremote.agent.protocol.velbus.device.VelbusDevice;
import org.openremote.agent.protocol.velbus.device.VelbusDeviceType;
import org.openremote.model.util.EnumUtil;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.ValueType;

public class ThermostatProcessor
extends FeatureProcessor {
    protected static final List<FeatureProcessor.PropertyDescriptor> THERMOSTAT_PROPERTIES = Arrays.asList(new FeatureProcessor.PropertyDescriptor("heater", "Heater", "HEATER", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("boost", "Boost", "BOOST", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("pump", "Pump", "PUMP", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("cooler", "Cooler", "COOLER", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("tempAlarm1", "Temp Alarm 1", "TEMP_ALARM1", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("tempAlarm2", "Temp Alarm 2", "TEMP_ALARM2", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("tempAlarm3", "Temp Alarm 3", "TEMP_ALARM3", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("tempAlarm4", "Temp Alarm 4", "TEMP_ALARM4", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("tempState", "Thermostat State", "TEMP_STATE", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("tempStateDisable", "Thermostat Disable (s)", "TEMP_STATE_DISABLE_SECONDS", ValueType.POSITIVE_INTEGER), new FeatureProcessor.PropertyDescriptor("tempMode", "Thermostat Mode", "TEMP_MODE", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("coolComfortMins", "Thermostat Cool Comfort (mins)", "TEMP_MODE_COOL_COMFORT_MINS", ValueType.POSITIVE_INTEGER), new FeatureProcessor.PropertyDescriptor("coolDayMins", "Cool Day (mins)", "TEMP_MODE_COOL_DAY_MINS", ValueType.POSITIVE_INTEGER), new FeatureProcessor.PropertyDescriptor("coolNightMins", "Cool Night (mins)", "TEMP_MODE_COOL_NIGHT_MINS", ValueType.POSITIVE_INTEGER), new FeatureProcessor.PropertyDescriptor("coolSafeMins", "Cool Safe (mins)", "TEMP_MODE_COOL_SAFE_MINS", ValueType.POSITIVE_INTEGER), new FeatureProcessor.PropertyDescriptor("heatComfortMins", "Heat Comfort (mins)", "TEMP_MODE_HEAT_COMFORT_MINS", ValueType.POSITIVE_INTEGER), new FeatureProcessor.PropertyDescriptor("heatDayMins", "Heat Day (mins)", "TEMP_MODE_HEAT_DAY_MINS", ValueType.POSITIVE_INTEGER), new FeatureProcessor.PropertyDescriptor("heatNightMins", "Heat Night (mins)", "TEMP_MODE_HEAT_NIGHT_MINS", ValueType.POSITIVE_INTEGER), new FeatureProcessor.PropertyDescriptor("heatSafeMins", "Heat Safe (mins)", "TEMP_MODE_HEAT_SAFE_MINS", ValueType.POSITIVE_INTEGER), new FeatureProcessor.PropertyDescriptor("tempTargetCurrent", "Temp Target Current", "TEMP_TARGET_CURRENT", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("tempTargetCoolComfort", "Temp Target Cool Comfort", "TEMP_TARGET_COOL_COMFORT", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("tempTargetCoolDay", "Temp Target Cool Day", "TEMP_TARGET_COOL_DAY", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("tempTargetCoolNight", "Temp Target Cool Night", "TEMP_TARGET_COOL_NIGHT", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("tempTargetCoolSafe", "Temp Target Cool Safe", "TEMP_TARGET_COOL_SAFE", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("tempTargetHeatComfort", "Temp Target Heat Comfort", "TEMP_TARGET_HEAT_COMFORT", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("tempTargetHeatDay", "Temp Target Heat Day", "TEMP_TARGET_HEAT_DAY", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("tempTargetHeatNight", "Temp Target Heat Night", "TEMP_TARGET_HEAT_NIGHT", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("tempTargetHeatSafe", "Temp Target Heat Safe", "TEMP_TARGET_HEAT_SAFE", ValueType.NUMBER));

    @Override
    public List<FeatureProcessor.PropertyDescriptor> getPropertyDescriptors(VelbusDeviceType deviceType) {
        return THERMOSTAT_PROPERTIES;
    }

    @Override
    public List<VelbusPacket> getStatusRequestPackets(VelbusDevice device) {
        return Collections.singletonList(new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.SENSOR_SETTINGS.getCode(), 0));
    }

    @Override
    public List<VelbusPacket> getPropertyWritePackets(VelbusDevice device, String property, Object value) {
        if (property.startsWith("TEMP_TARGET_")) {
            String modeStr = property.substring("TEMP_TARGET_".length());
            return EnumUtil.enumFromString(TemperatureMode.class, (String)modeStr).map(mode -> ValueUtil.getDoubleCoerced((Object)value).map(newTemp -> Math.round(newTemp * 2.0)).map(newTemp -> {
                int busValue = Math.toIntExact(newTemp);
                if (busValue >= -110 && busValue <= 125) {
                    return Collections.singletonList(new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.TEMP_SET.getCode(), VelbusPacket.PacketPriority.LOW, (byte)mode.getPointerIndex(), (byte)busValue));
                }
                return null;
            }).orElse(null)).orElse(null);
        }
        if ("TEMP_MODE".equals(property)) {
            return EnumUtil.enumFromValue(TemperatureMode.class, (Object)value).map(mode -> ThermostatProcessor.getTempModePackets(device, mode, 65280)).orElse(null);
        }
        if (property.startsWith("TEMP_MODE_") && property.endsWith("_MINS")) {
            return ValueUtil.getIntegerCoerced((Object)value).map(durationMinutes -> {
                String modeStr = property.substring("TEMP_MODE_".length(), property.length() - "_MINS".length());
                return EnumUtil.enumFromString(TemperatureMode.class, (String)modeStr).map(mode -> ThermostatProcessor.getTempModePackets(device, mode, durationMinutes)).orElse(null);
            }).orElse(null);
        }
        if ("TEMP_STATE".equals(property)) {
            return EnumUtil.enumFromValue(TemperatureState.class, (Object)value).map(state -> state == TemperatureState.TIMER ? null : state).map(state -> ThermostatProcessor.getTempStatePackets(device, state, -1)).orElse(null);
        }
        if ("TEMP_STATE_DISABLE_SECONDS".equals(property)) {
            return ValueUtil.getIntegerCoerced((Object)value).map(durationSeconds -> ThermostatProcessor.getTempStatePackets(device, TemperatureState.DISABLED, durationSeconds)).orElse(null);
        }
        return null;
    }

    @Override
    public boolean processReceivedPacket(VelbusDevice device, VelbusPacket packet) {
        VelbusPacket.InboundCommand packetCommand = VelbusPacket.InboundCommand.fromCode(packet.getCommand());
        switch (packetCommand) {
            case PUSH_BUTTON_STATUS: {
                if (ThermostatProcessor.isPacketForThermostat(device, packet.getAddress())) {
                    for (int i = 0; i < 2; ++i) {
                        InputProcessor.ChannelState state = i == 0 ? InputProcessor.ChannelState.PRESSED : InputProcessor.ChannelState.RELEASED;
                        byte stateByte = packet.getByte(i + 1);
                        if ((stateByte & 1) == 1) {
                            device.setProperty("HEATER", (Object)state);
                        }
                        if ((stateByte & 2) == 2) {
                            device.setProperty("BOOST", (Object)state);
                        }
                        if ((stateByte & 4) == 4) {
                            device.setProperty("PUMP", (Object)state);
                        }
                        if ((stateByte & 8) == 8) {
                            device.setProperty("COOLER", (Object)state);
                        }
                        if ((stateByte & 0x10) == 16) {
                            device.setProperty("TEMP_ALARM1", (Object)state);
                        }
                        if ((stateByte & 0x20) == 32) {
                            device.setProperty("TEMP_ALARM2", (Object)state);
                        }
                        if ((stateByte & 0x40) == 64) {
                            device.setProperty("TEMP_ALARM3", (Object)state);
                        }
                        if ((stateByte & 0x80) != 128) continue;
                        device.setProperty("TEMP_ALARM4", (Object)state);
                    }
                    return true;
                }
                return false;
            }
            case SENSOR_STATUS: {
                TemperatureState temperatureState = TemperatureState.fromCode(packet.getByte(1) & 6).orElse(TemperatureState.NORMAL);
                device.setProperty("TEMP_STATE", (Object)temperatureState);
                TemperatureMode mode = TemperatureMode.fromCode(packet.getByte(1) & 0xF0).orElse(TemperatureMode.HEAT_SAFE);
                device.setProperty("TEMP_MODE", (Object)mode);
                device.setProperty("HEATER", (Object)((packet.getByte(3) & 1) == 1 ? InputProcessor.ChannelState.PRESSED : InputProcessor.ChannelState.RELEASED));
                device.setProperty("BOOST", (Object)((packet.getByte(3) & 2) == 2 ? InputProcessor.ChannelState.PRESSED : InputProcessor.ChannelState.RELEASED));
                device.setProperty("PUMP", (Object)((packet.getByte(3) & 4) == 4 ? InputProcessor.ChannelState.PRESSED : InputProcessor.ChannelState.RELEASED));
                device.setProperty("COOLER", (Object)((packet.getByte(3) & 8) == 8 ? InputProcessor.ChannelState.PRESSED : InputProcessor.ChannelState.RELEASED));
                device.setProperty("TEMP_CURRENT", (double)packet.getByte(4) / 2.0);
                device.setProperty("TEMP_TARGET_CURRENT", (double)packet.getByte(5) / 2.0);
                if (device.getDeviceType() == VelbusDeviceType.VMB1TS) {
                    device.setProperty("TEMP_ALARM1", (Object)((packet.getByte(3) & 0x20) == 32 ? InputProcessor.ChannelState.PRESSED : InputProcessor.ChannelState.RELEASED));
                    device.setProperty("TEMP_ALARM2", (Object)((packet.getByte(3) & 0x40) == 64 ? InputProcessor.ChannelState.PRESSED : InputProcessor.ChannelState.RELEASED));
                } else {
                    device.setProperty("TEMP_ALARM1", (Object)((packet.getByte(3) & 0x10) == 16 ? InputProcessor.ChannelState.PRESSED : InputProcessor.ChannelState.RELEASED));
                    device.setProperty("TEMP_ALARM2", (Object)((packet.getByte(3) & 0x20) == 32 ? InputProcessor.ChannelState.PRESSED : InputProcessor.ChannelState.RELEASED));
                    device.setProperty("TEMP_ALARM3", (Object)((packet.getByte(3) & 0x40) == 64 ? InputProcessor.ChannelState.PRESSED : InputProcessor.ChannelState.RELEASED));
                    device.setProperty("TEMP_ALARM4", (Object)((packet.getByte(3) & 0x80) == 128 ? InputProcessor.ChannelState.PRESSED : InputProcessor.ChannelState.RELEASED));
                }
                return true;
            }
            case TEMP_SETTINGS1: {
                device.setProperty("TEMP_TARGET_CURRENT", (double)packet.getByte(1) / 2.0);
                device.setProperty("TEMP_TARGET_HEAT_COMFORT", (double)packet.getByte(2) / 2.0);
                device.setProperty("TEMP_TARGET_HEAT_DAY", (double)packet.getByte(3) / 2.0);
                device.setProperty("TEMP_TARGET_HEAT_NIGHT", (double)packet.getByte(4) / 2.0);
                device.setProperty("TEMP_TARGET_HEAT_SAFE", (double)packet.getByte(5) / 2.0);
                return true;
            }
            case TEMP_SETTINGS2: {
                device.setProperty("TEMP_TARGET_COOL_COMFORT", (double)packet.getByte(1) / 2.0);
                device.setProperty("TEMP_TARGET_COOL_DAY", (double)packet.getByte(2) / 2.0);
                device.setProperty("TEMP_TARGET_COOL_NIGHT", (double)packet.getByte(3) / 2.0);
                device.setProperty("TEMP_TARGET_COOL_SAFE", (double)packet.getByte(4) / 2.0);
                return true;
            }
        }
        return false;
    }

    protected static boolean isPacketForThermostat(VelbusDevice device, int packetAddress) {
        int thermoIndex;
        int addressIndex = device.getAddressIndex(packetAddress);
        return addressIndex == (thermoIndex = ThermostatProcessor.getThermostatAddressIndex(device));
    }

    protected static int getThermostatAddressIndex(VelbusDevice device) {
        if (device.getDeviceType() == VelbusDeviceType.VMBGPO || device.getDeviceType() == VelbusDeviceType.VMBGPOD) {
            return 4;
        }
        if (device.getDeviceType() == VelbusDeviceType.VMB1TS) {
            return 0;
        }
        return 1;
    }

    protected static Optional<Integer> getThermostatChannelNumber(VelbusDevice device) {
        int thermoIndex = ThermostatProcessor.getThermostatAddressIndex(device);
        return Optional.ofNullable(thermoIndex > 0 ? Integer.valueOf(thermoIndex * 8 + 1) : null);
    }

    protected static boolean isThermostatEnabled(VelbusDevice device) {
        int thermoIndex = ThermostatProcessor.getThermostatAddressIndex(device);
        int thermostatAddress = device.getAddress(thermoIndex);
        return thermostatAddress > 0 && thermostatAddress < 255;
    }

    protected static List<VelbusPacket> getTempModePackets(VelbusDevice device, TemperatureMode mode, int durationMinutes) {
        Optional<Integer> thermostatChannel = ThermostatProcessor.getThermostatChannelNumber(device);
        if (!thermostatChannel.isPresent()) {
            AbstractVelbusProtocol.LOG.info("Thermostat mode is not supported on this device");
            return null;
        }
        if ((durationMinutes = Math.min(durationMinutes, 65280)) < 0) {
            durationMinutes = 65535;
        }
        ArrayList<VelbusPacket> packets = new ArrayList<VelbusPacket>();
        if (device.getPropertyValue("TEMP_STATE") == TemperatureState.DISABLED) {
            packets.addAll(InputProcessor.getLockStatePackets(device, thermostatChannel.get(), 0));
        }
        packets.add(new VelbusPacket(device.getBaseAddress(), mode.getMode1Command().getCode(), VelbusPacket.PacketPriority.LOW, 0));
        packets.add(new VelbusPacket(device.getBaseAddress(), mode.getMode2Command().getCode(), VelbusPacket.PacketPriority.LOW, (byte)(durationMinutes >> 8), (byte)durationMinutes));
        return packets;
    }

    protected static List<VelbusPacket> getTempStatePackets(VelbusDevice device, TemperatureState state, int durationSeconds) {
        Optional<Integer> thermostatChannel = ThermostatProcessor.getThermostatChannelNumber(device);
        if (!thermostatChannel.isPresent()) {
            AbstractVelbusProtocol.LOG.info("Thermostat state is not supported on this device");
            return null;
        }
        TemperatureState currentState = (TemperatureState)((Object)device.getPropertyValue("TEMP_STATE"));
        if (state == currentState) {
            return null;
        }
        ArrayList<VelbusPacket> packets = new ArrayList<VelbusPacket>();
        if (currentState == TemperatureState.DISABLED) {
            packets.addAll(InputProcessor.getLockStatePackets(device, thermostatChannel.get(), 0));
        }
        switch (state) {
            case DISABLED: {
                packets.addAll(InputProcessor.getLockStatePackets(device, thermostatChannel.get(), durationSeconds));
                break;
            }
            case MANUAL: {
                TemperatureMode currentMode = (TemperatureMode)((Object)device.getPropertyValue("TEMP_MODE"));
                List<VelbusPacket> tempModePackets = ThermostatProcessor.getTempModePackets(device, currentMode, -1);
                if (tempModePackets == null) break;
                packets.addAll(tempModePackets);
                break;
            }
            case NORMAL: {
                TemperatureMode currentMode = (TemperatureMode)((Object)device.getPropertyValue("TEMP_MODE"));
                List<VelbusPacket> tempModePackets = ThermostatProcessor.getTempModePackets(device, currentMode, 0);
                if (tempModePackets == null) break;
                packets.addAll(tempModePackets);
            }
        }
        return packets;
    }

    public static enum TemperatureMode {
        CURRENT(-1, -1, null, null),
        COOL_COMFORT(192, 7, VelbusPacket.OutboundCommand.TEMP_MODE1_COOL, VelbusPacket.OutboundCommand.TEMP_MODE2_COMFORT),
        COOL_DAY(160, 8, VelbusPacket.OutboundCommand.TEMP_MODE1_COOL, VelbusPacket.OutboundCommand.TEMP_MODE2_DAY),
        COOL_NIGHT(144, 9, VelbusPacket.OutboundCommand.TEMP_MODE1_COOL, VelbusPacket.OutboundCommand.TEMP_MODE2_NIGHT),
        COOL_SAFE(128, 10, VelbusPacket.OutboundCommand.TEMP_MODE1_COOL, VelbusPacket.OutboundCommand.TEMP_MODE2_SAFE),
        HEAT_COMFORT(64, 1, VelbusPacket.OutboundCommand.TEMP_MODE1_HEAT, VelbusPacket.OutboundCommand.TEMP_MODE2_COMFORT),
        HEAT_DAY(32, 2, VelbusPacket.OutboundCommand.TEMP_MODE1_HEAT, VelbusPacket.OutboundCommand.TEMP_MODE2_DAY),
        HEAT_NIGHT(16, 3, VelbusPacket.OutboundCommand.TEMP_MODE1_HEAT, VelbusPacket.OutboundCommand.TEMP_MODE2_NIGHT),
        HEAT_SAFE(0, 4, VelbusPacket.OutboundCommand.TEMP_MODE1_HEAT, VelbusPacket.OutboundCommand.TEMP_MODE2_SAFE);

        private static final TemperatureMode[] values;
        private final int code;
        private final int pointerIndex;
        private final VelbusPacket.OutboundCommand mode1Command;
        private final VelbusPacket.OutboundCommand mode2Command;

        private TemperatureMode(int code, int pointerIndex, VelbusPacket.OutboundCommand mode1Command, VelbusPacket.OutboundCommand mode2Command) {
            this.code = code;
            this.pointerIndex = pointerIndex;
            this.mode1Command = mode1Command;
            this.mode2Command = mode2Command;
        }

        public int getPointerIndex() {
            return this.pointerIndex;
        }

        public int getCode() {
            return this.code;
        }

        public VelbusPacket.OutboundCommand getMode1Command() {
            return this.mode1Command;
        }

        public VelbusPacket.OutboundCommand getMode2Command() {
            return this.mode2Command;
        }

        public static Optional<TemperatureMode> fromCode(int integer) {
            for (TemperatureMode value : values) {
                if (value.getCode() != integer) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }

        static {
            values = TemperatureMode.values();
        }
    }

    public static enum TemperatureState {
        DISABLED(6),
        MANUAL(2),
        TIMER(4),
        NORMAL(0);

        private static final TemperatureState[] values;
        private final int code;

        private TemperatureState(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Optional<TemperatureState> fromCode(int integer) {
            for (TemperatureState value : values) {
                if (value.getCode() != integer) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }

        static {
            values = TemperatureState.values();
        }
    }
}

