/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus.device;

import java.util.Arrays;
import java.util.List;
import org.openremote.agent.protocol.velbus.VelbusPacket;
import org.openremote.agent.protocol.velbus.device.FeatureProcessor;
import org.openremote.agent.protocol.velbus.device.VelbusDevice;
import org.openremote.agent.protocol.velbus.device.VelbusDeviceType;
import org.openremote.model.value.ValueType;

public class TemperatureProcessor
extends FeatureProcessor {
    protected static final List<FeatureProcessor.PropertyDescriptor> SUPPORTED_PROPERTIES = Arrays.asList(new FeatureProcessor.PropertyDescriptor("tempCurrent", "Temp Current", "TEMP_CURRENT", ValueType.NUMBER, true), new FeatureProcessor.PropertyDescriptor("tempMin", "Temp Min", "TEMP_MIN", ValueType.NUMBER, true), new FeatureProcessor.PropertyDescriptor("tempMax", "Temp Max", "TEMP_MAX", ValueType.NUMBER, true));

    @Override
    public List<FeatureProcessor.PropertyDescriptor> getPropertyDescriptors(VelbusDeviceType deviceType) {
        return SUPPORTED_PROPERTIES;
    }

    @Override
    public List<VelbusPacket> getStatusRequestPackets(VelbusDevice device) {
        return Arrays.asList(new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.MODULE_STATUS.getCode(), 0), new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.SENSOR_READOUT.getCode(), 0));
    }

    @Override
    public List<VelbusPacket> getPropertyWritePackets(VelbusDevice device, String property, Object value) {
        return null;
    }

    @Override
    public boolean processReceivedPacket(VelbusDevice device, VelbusPacket packet) {
        VelbusPacket.InboundCommand packetCommand = VelbusPacket.InboundCommand.fromCode(packet.getCommand());
        switch (packetCommand) {
            case CURRENT_TEMP_STATUS: {
                TemperatureProcessor.processCurrentTemp(device, packet);
                return true;
            }
        }
        return false;
    }

    protected static void processCurrentTemp(VelbusDevice device, VelbusPacket packet) {
        short currentValue = (short)(packet.getByte(1) << 8 | (short)packet.getByte(2) & 0xFF);
        short minValue = (short)(packet.getByte(3) << 8 | (short)packet.getByte(4) & 0xFF);
        short maxValue = (short)(packet.getByte(5) << 8 | (short)packet.getByte(6) & 0xFF);
        byte msb = (byte)(currentValue >> 15);
        if (msb > 0) {
            currentValue = (short)(currentValue - 1);
            currentValue = ~currentValue;
            currentValue = (short)(currentValue * -1);
        }
        if ((msb = (byte)(minValue >> 15)) > 0) {
            minValue = (short)(minValue - 1);
            minValue = ~minValue;
            minValue = (short)(minValue * -1);
        }
        if ((msb = (byte)(maxValue >> 15)) > 0) {
            maxValue = (short)(maxValue - 1);
            maxValue = ~maxValue;
            maxValue = (short)(maxValue * -1);
        }
        currentValue = (short)(currentValue >> 5);
        minValue = (short)(minValue >> 5);
        maxValue = (short)(maxValue >> 5);
        double current = (double)Math.round(0.625 * (double)currentValue) / 10.0;
        double min = (double)Math.round(0.625 * (double)minValue) / 10.0;
        double max = (double)Math.round(0.625 * (double)maxValue) / 10.0;
        device.setProperty("TEMP_CURRENT", current);
        device.setProperty("TEMP_MIN", min);
        device.setProperty("TEMP_MAX", max);
    }
}

