/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus.device;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openremote.agent.protocol.velbus.VelbusPacket;
import org.openremote.agent.protocol.velbus.device.FeatureProcessor;
import org.openremote.agent.protocol.velbus.device.OutputChannelProcessor;
import org.openremote.agent.protocol.velbus.device.VelbusDevice;
import org.openremote.agent.protocol.velbus.device.VelbusDeviceType;
import org.openremote.model.util.EnumUtil;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.ValueType;

public class RelayProcessor
extends OutputChannelProcessor {
    protected static final List<FeatureProcessor.PropertyDescriptor> SUPPORTED_PROPERTIES = Arrays.asList(new FeatureProcessor.PropertyDescriptor("ch1State", "CH1", "CH1", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("ch2State", "CH2", "CH2", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("ch3State", "CH3", "CH3", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("ch4State", "CH4", "CH4", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("ch5State", "CH5", "CH5", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("ch1Setting", "CH1 Setting", "CH1_SETTING", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("ch2Setting", "CH2 Setting", "CH2_SETTING", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("ch3Setting", "CH3 Setting", "CH3_SETTING", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("ch4Setting", "CH4 Setting", "CH4_SETTING", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("ch5Setting", "CH5 Setting", "CH5_SETTING", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("ch1Locked", "CH1 Locked", "CH1_LOCKED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("ch2Locked", "CH2 Locked", "CH2_LOCKED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("ch3Locked", "CH3 Locked", "CH3_LOCKED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("ch4Locked", "CH4 Locked", "CH4_LOCKED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("ch5Locked", "CH5 Locked", "CH5_LOCKED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("ch1Forced", "CH1 Forced", "CH1_FORCED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("ch2Forced", "CH2 Forced", "CH2_FORCED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("ch3Forced", "CH3 Forced", "CH3_FORCED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("ch4Forced", "CH4 Forced", "CH4_FORCED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("ch5Forced", "CH5 Forced", "CH5_FORCED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("ch1Inhibited", "CH1 Inhibited", "CH1_INHIBITED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("ch2Inhibited", "CH2 Inhibited", "CH2_INHIBITED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("ch3Inhibited", "CH3 Inhibited", "CH3_INHIBITED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("ch4Inhibited", "CH4 Inhibited", "CH4_INHIBITED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("ch5Inhibited", "CH5 Inhibited", "CH5_INHIBITED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("ch1LedState", "CH1 LED State", "CH1_LED", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("ch2LedState", "CH2 LED State", "CH2_LED", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("ch3LedState", "CH3 LED State", "CH3_LED", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("ch4LedState", "CH4 LED State", "CH4_LED", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("ch5LedState", "CH5 LED State", "CH5_LED", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("ch1OnSeconds", "CH1 On (s)", "CH1_ON", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch2OnSeconds", "CH2 On (s)", "CH2_ON", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch3OnSeconds", "CH3 On (s)", "CH3_ON", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch4OnSeconds", "CH4 On (s)", "CH4_ON", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch5OnSeconds", "CH5 On (s)", "CH5_ON", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch1IntermittentSeconds", "CH1 Intermittent (s)", "CH1_INTERMITTENT", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch2IntermittentSeconds", "CH2 Intermittent (s)", "CH2_INTERMITTENT", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch3IntermittentSeconds", "CH3 Intermittent (s)", "CH3_INTERMITTENT", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch4IntermittentSeconds", "CH4 Intermittent (s)", "CH4_INTERMITTENT", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch5IntermittentSeconds", "CH5 Intermittent (s)", "CH5_INTERMITTENT", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch1LockSeconds", "CH1 Lock (s)", "CH1_LOCK", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch2LockSeconds", "CH2 Lock (s)", "CH2_LOCK", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch3LockSeconds", "CH3 Lock (s)", "CH3_LOCK", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch4LockSeconds", "CH4 Lock (s)", "CH4_LOCK", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch5LockSeconds", "CH5 Lock (s)", "CH5_LOCK", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch1ForceOnSeconds", "CH1 Force On (s)", "CH1_FORCE_ON", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch2ForceOnSeconds", "CH2 Force On (s)", "CH2_FORCE_ON", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch3ForceOnSeconds", "CH3 Force On (s)", "CH3_FORCE_ON", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch4ForceOnSeconds", "CH4 Force On (s)", "CH4_FORCE_ON", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch5ForceOnSeconds", "CH5 Force On (s)", "CH5_FORCE_ON", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch1InhibitSeconds", "CH1 Inhibit (s)", "CH1_INHIBIT", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch2InhibitSeconds", "CH2 Inhibit (s)", "CH2_INHIBIT", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch3InhibitSeconds", "CH3 Inhibit (s)", "CH3_INHIBIT", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch4InhibitSeconds", "CH4 Inhibit (s)", "CH4_INHIBIT", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("ch5InhibitSeconds", "CH5 Inhibit (s)", "CH5_INHIBIT", ValueType.NUMBER));

    @Override
    public List<VelbusPacket> getStatusRequestPackets(VelbusDevice device) {
        return Collections.singletonList(new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.MODULE_STATUS.getCode(), 31));
    }

    @Override
    public List<FeatureProcessor.PropertyDescriptor> getPropertyDescriptors(VelbusDeviceType deviceType) {
        return SUPPORTED_PROPERTIES;
    }

    @Override
    public List<VelbusPacket> getPropertyWritePackets(VelbusDevice device, String property, Object value) {
        return this.getChannelNumberAndPropertySuffix(device, CHANNEL_REGEX, property).map(channelNumberAndPropertySuffix -> {
            int channelNumber = (Integer)channelNumberAndPropertySuffix.key;
            VelbusPacket.OutboundCommand command = null;
            Integer[] params = new Integer[1];
            switch ((String)channelNumberAndPropertySuffix.value) {
                case "": {
                    command = ChannelState.fromValue(value).map(state -> {
                        switch (state) {
                            case OFF: {
                                return VelbusPacket.OutboundCommand.RELAY_OFF;
                            }
                            case ON: {
                                return VelbusPacket.OutboundCommand.RELAY_ON;
                            }
                            case INTERMITTENT: {
                                params[0] = 0xFFFFFF;
                                return VelbusPacket.OutboundCommand.RELAY_BLINK_TIMER;
                            }
                        }
                        return null;
                    }).orElse(null);
                    break;
                }
                case "_SETTING": {
                    Optional<OutputChannelProcessor.ChannelSetting> setting = OutputChannelProcessor.ChannelSetting.fromValue(value);
                    if (!setting.isPresent()) {
                        return null;
                    }
                    switch (setting.get()) {
                        case NORMAL: {
                            return Stream.of(RelayProcessor.getPackets(device, channelNumber, VelbusPacket.OutboundCommand.INHIBIT_CANCEL, 0xFFFFFF), RelayProcessor.getPackets(device, channelNumber, VelbusPacket.OutboundCommand.FORCE_ON_CANCEL, 0xFFFFFF), RelayProcessor.getPackets(device, channelNumber, VelbusPacket.OutboundCommand.LOCK_CANCEL, 0xFFFFFF)).flatMap(Collection::stream).collect(Collectors.toList());
                        }
                        case INHIBITED: {
                            params[0] = 0xFFFFFF;
                            command = VelbusPacket.OutboundCommand.INHIBIT;
                            break;
                        }
                        case FORCED: {
                            params[0] = 0xFFFFFF;
                            command = VelbusPacket.OutboundCommand.FORCE_ON;
                            break;
                        }
                        case LOCKED: {
                            params[0] = 0xFFFFFF;
                            command = VelbusPacket.OutboundCommand.LOCK;
                        }
                    }
                    break;
                }
                case "_LOCKED": {
                    command = ValueUtil.getBoolean((Object)value).map(locked -> {
                        params[0] = 0xFFFFFF;
                        return locked != false ? VelbusPacket.OutboundCommand.LOCK : VelbusPacket.OutboundCommand.LOCK_CANCEL;
                    }).orElse(null);
                    break;
                }
                case "_INHIBITED": {
                    command = ValueUtil.getBoolean((Object)value).map(inhibited -> {
                        params[0] = 0xFFFFFF;
                        return inhibited != false ? VelbusPacket.OutboundCommand.INHIBIT : VelbusPacket.OutboundCommand.INHIBIT_CANCEL;
                    }).orElse(null);
                    break;
                }
                case "_FORCED": {
                    command = ValueUtil.getBoolean((Object)value).map(inhibited -> {
                        params[0] = 0xFFFFFF;
                        return inhibited != false ? VelbusPacket.OutboundCommand.FORCE_ON : VelbusPacket.OutboundCommand.FORCE_ON_CANCEL;
                    }).orElse(null);
                    break;
                }
                case "_ON": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[0] = duration;
                        return duration == 0 ? VelbusPacket.OutboundCommand.RELAY_OFF : VelbusPacket.OutboundCommand.RELAY_ON_TIMER;
                    }).orElse(null);
                    break;
                }
                case "_INTERMITTENT": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[0] = duration;
                        return duration == 0 ? VelbusPacket.OutboundCommand.RELAY_OFF : VelbusPacket.OutboundCommand.RELAY_BLINK_TIMER;
                    }).orElse(null);
                    break;
                }
                case "_LOCK": 
                case "_FORCE_OFF": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[0] = duration;
                        return duration == 0 ? VelbusPacket.OutboundCommand.LOCK_CANCEL : VelbusPacket.OutboundCommand.LOCK;
                    }).orElse(null);
                    break;
                }
                case "_FORCE_ON": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[0] = duration;
                        return duration == 0 ? VelbusPacket.OutboundCommand.FORCE_ON_CANCEL : VelbusPacket.OutboundCommand.FORCE_ON;
                    }).orElse(null);
                    break;
                }
                case "_INHIBIT": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[0] = duration;
                        return duration == 0 ? VelbusPacket.OutboundCommand.INHIBIT_CANCEL : VelbusPacket.OutboundCommand.INHIBIT;
                    }).orElse(null);
                }
            }
            if (command != null) {
                return RelayProcessor.getPackets(device, channelNumber, command, params[0] == null ? 0 : params[0]);
            }
            return null;
        }).orElse(null);
    }

    @Override
    public boolean processReceivedPacket(VelbusDevice device, VelbusPacket packet) {
        VelbusPacket.InboundCommand packetCommand = VelbusPacket.InboundCommand.fromCode(packet.getCommand());
        switch (packetCommand) {
            case RELAY_STATUS: {
                int channelNumber = (int)(Math.log(packet.getByte(1) & 0xFF) / Math.log(2.0)) + 1;
                OutputChannelProcessor.ChannelSetting setting = device.getDeviceType() == VelbusDeviceType.VMB1RY ? OutputChannelProcessor.ChannelSetting.NORMAL : OutputChannelProcessor.ChannelSetting.fromCode(packet.getByte(2) & 0xFF);
                ChannelState state = (packet.getByte(3) & 0xFF) == 17 ? ChannelState.INTERMITTENT : ChannelState.fromCode(packet.getByte(3) & 0xFF);
                FeatureProcessor.LedState ledStatus = device.getDeviceType() == VelbusDeviceType.VMB1RY ? null : FeatureProcessor.LedState.fromCode(packet.getByte(4) & 0xFF);
                device.setProperty("CH" + channelNumber, (Object)state);
                device.setProperty("CH" + channelNumber + "_SETTING", (Object)setting);
                device.setProperty("CH" + channelNumber + "_LOCKED", setting == OutputChannelProcessor.ChannelSetting.LOCKED);
                device.setProperty("CH" + channelNumber + "_INHIBITED", setting == OutputChannelProcessor.ChannelSetting.INHIBITED);
                device.setProperty("CH" + channelNumber + "_LED", (Object)ledStatus);
                return true;
            }
        }
        return false;
    }

    protected static List<VelbusPacket> getPackets(VelbusDevice velbusDevice, int channelNumber, VelbusPacket.OutboundCommand command, int durationSeconds) {
        byte[] packetBytes = null;
        switch (command) {
            case FORCE_ON: 
            case RELAY_ON_TIMER: 
            case RELAY_BLINK_TIMER: 
            case LOCK: 
            case INHIBIT: {
                durationSeconds = durationSeconds == -1 ? 0xFFFFFF : durationSeconds;
                durationSeconds = Math.min(0xFFFFFF, Math.max(0, durationSeconds));
                packetBytes = new byte[4];
                packetBytes[1] = (byte)(durationSeconds >> 16);
                packetBytes[2] = (byte)(durationSeconds >> 8);
                packetBytes[3] = (byte)durationSeconds;
                break;
            }
            case RELAY_ON: 
            case RELAY_OFF: 
            case INHIBIT_CANCEL: 
            case FORCE_ON_CANCEL: 
            case LOCK_CANCEL: {
                packetBytes = new byte[1];
            }
        }
        if (packetBytes != null) {
            packetBytes[0] = (byte)Math.pow(2.0, channelNumber - 1);
            return Collections.singletonList(new VelbusPacket(velbusDevice.getBaseAddress(), command.getCode(), VelbusPacket.PacketPriority.HIGH, packetBytes));
        }
        return null;
    }

    static enum ChannelState {
        OFF(0),
        ON(1),
        INTERMITTENT(3);

        private final int code;

        private ChannelState(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ChannelState fromCode(int code) {
            for (ChannelState type : ChannelState.values()) {
                if (type.getCode() != code) continue;
                return type;
            }
            return OFF;
        }

        public static Optional<ChannelState> fromValue(Object value) {
            if (value == null) {
                return Optional.empty();
            }
            if (ValueUtil.isBoolean(value.getClass())) {
                return ChannelState.fromBoolean(ValueUtil.getBoolean((Object)value).orElse(null));
            }
            return EnumUtil.enumFromValue(ChannelState.class, (Object)value);
        }

        public static Optional<ChannelState> fromBoolean(Boolean value) {
            if (value == null) {
                return Optional.of(INTERMITTENT);
            }
            if (value.booleanValue()) {
                return Optional.of(ON);
            }
            return Optional.of(OFF);
        }
    }
}

