/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus.device;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.openremote.agent.protocol.velbus.AbstractVelbusProtocol;
import org.openremote.agent.protocol.velbus.VelbusPacket;
import org.openremote.agent.protocol.velbus.device.ChannelProcessor;
import org.openremote.agent.protocol.velbus.device.FeatureProcessor;
import org.openremote.agent.protocol.velbus.device.VelbusDevice;
import org.openremote.agent.protocol.velbus.device.VelbusDeviceType;
import org.openremote.model.util.EnumUtil;
import org.openremote.model.util.Pair;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.ValueType;

public class ProgramsProcessor
extends ChannelProcessor {
    protected static final String PROGRAM_STEPS_ENABLED_SUFFIX = "_PROGRAM_STEPS_ENABLED";
    protected static final String PROGRAM_STEPS_DISABLED_SECONDS_SUFFIX = "_PROGRAM_STEPS_DISABLED_SECONDS";
    protected static final List<FeatureProcessor.PropertyDescriptor> STATIC_PROPERTIES = Arrays.asList(new FeatureProcessor.PropertyDescriptor("allProgramStepsEnabled", "All Program Steps Enabled", "ALL_PROGRAM_STEPS_ENABLED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("allProgramStepsDisableSeconds", "All Program Steps Disable (s)", "ALL_PROGRAM_STEPS_DISABLED_SECONDS", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("sunriseEnabled", "Sunrise Enabled", "SUNRISE_ENABLED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("sunsetEnabled", "Sunset Enabled", "SUNSET_ENABLED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("alarm1Enabled", "Alarm 1 Enabled", "ALARM1_ENABLED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("alarm2Enabled", "Alarm 2 Enabled", "ALARM2_ENABLED", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("alarm1Master", "Alarm 1 Master", "ALARM1_MASTER", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("alarm2Master", "Alarm 2 Master", "ALARM2_MASTER", ValueType.BOOLEAN), new FeatureProcessor.PropertyDescriptor("alarm1WakeTime", "Alarm 1 Wake Time", "ALARM1_WAKE_TIME", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("alarm2WakeTime", "Alarm 2 Wake Time", "ALARM2_WAKE_TIME", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("alarm1BedTime", "Alarm 1 Bed Time", "ALARM1_BED_TIME", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("alarm2BedTime", "Alarm 2 Bed Time", "ALARM2_BED_TIME", ValueType.TEXT), new FeatureProcessor.PropertyDescriptor("program", "Current Program", "Program", ValueType.TEXT));

    @Override
    public List<FeatureProcessor.PropertyDescriptor> getPropertyDescriptors(VelbusDeviceType deviceType) {
        int maxChannelNumber = ChannelProcessor.getMaxChannelNumber(deviceType);
        ArrayList<FeatureProcessor.PropertyDescriptor> properties = new ArrayList<FeatureProcessor.PropertyDescriptor>(maxChannelNumber * 2 + STATIC_PROPERTIES.size());
        for (int i = 1; i <= maxChannelNumber; ++i) {
            properties.add(new FeatureProcessor.PropertyDescriptor("ch" + i + "ProgramStepsEnabled", "CH" + i + " Program Steps Enabled", "CH" + i + PROGRAM_STEPS_ENABLED_SUFFIX, ValueType.BOOLEAN));
            properties.add(new FeatureProcessor.PropertyDescriptor("ch" + i + "ProgramStepsDisableSeconds", "CH" + i + " Program Steps Disable (s)", "CH" + i + PROGRAM_STEPS_DISABLED_SECONDS_SUFFIX, ValueType.NUMBER));
        }
        properties.addAll(STATIC_PROPERTIES);
        return properties;
    }

    @Override
    public List<VelbusPacket> getStatusRequestPackets(VelbusDevice device) {
        Integer alarm1 = ProgramsProcessor.getAlarmMemoryLocation(1, device.getDeviceType());
        Integer alarm2 = ProgramsProcessor.getAlarmMemoryLocation(2, device.getDeviceType());
        if (alarm1 != null && alarm2 != null) {
            return Arrays.asList(new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.READ_MEMORY_BLOCK.getCode(), (byte)(alarm1 >> 8), alarm1.byteValue()), new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.READ_MEMORY_BLOCK.getCode(), (byte)(alarm2 >> 8), alarm2.byteValue()));
        }
        return Collections.emptyList();
    }

    @Override
    public List<VelbusPacket> getPropertyWritePackets(VelbusDevice device, String property, Object value) {
        Optional<Pair<Integer, String>> channelNumberAndPropertySuffix = this.getChannelNumberAndPropertySuffix(device, CHANNEL_REGEX, property);
        if (channelNumberAndPropertySuffix.isPresent()) {
            switch ((String)channelNumberAndPropertySuffix.get().value) {
                case "_PROGRAM_STEPS_ENABLED": {
                    return ValueUtil.getBooleanCoerced((Object)value).map(enabled -> ProgramsProcessor.getProgramStepsPackets(device, (Integer)((Pair)channelNumberAndPropertySuffix.get()).key, enabled, 1048575)).orElse(null);
                }
                case "_PROGRAM_STEPS_DISABLED_SECONDS": {
                    return ValueUtil.getIntegerCoerced((Object)value).map(durationSeconds -> ProgramsProcessor.getProgramStepsPackets(device, (Integer)((Pair)channelNumberAndPropertySuffix.get()).key, false, durationSeconds)).orElse(null);
                }
            }
            return null;
        }
        if (property.equals("ALL_PROGRAM_STEPS_ENABLED")) {
            return ValueUtil.getBooleanCoerced((Object)value).map(enabled -> ProgramsProcessor.getProgramStepsPackets(device, 255, enabled, 1048575)).orElse(null);
        }
        if (property.equals("ALL_PROGRAM_STEPS_DISABLED_SECONDS")) {
            return ValueUtil.getIntegerCoerced((Object)value).map(durationSeconds -> ProgramsProcessor.getProgramStepsPackets(device, 255, false, durationSeconds)).orElse(null);
        }
        if (property.equals("PROGRAM")) {
            return EnumUtil.enumFromValue(Program.class, (Object)value).map(program -> Collections.singletonList(new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.PROGRAM_SELECT.getCode(), VelbusPacket.PacketPriority.LOW, (byte)program.getCode()))).orElse(null);
        }
        if (property.equals("SUNRISE_ENABLED") || property.equals("SUNSET_ENABLED")) {
            return ValueUtil.getBooleanCoerced((Object)value).map(enabled -> {
                boolean sunsetEnabled;
                boolean sunriseEnabled = device.getPropertyValue("SUNRISE_ENABLED") != null && (Boolean)device.getPropertyValue("SUNRISE_ENABLED") != false;
                boolean bl = sunsetEnabled = device.getPropertyValue("SUNSET_ENABLED") != null && (Boolean)device.getPropertyValue("SUNSET_ENABLED") != false;
                if (property.equals("SUNRISE_ENABLED")) {
                    sunriseEnabled = enabled;
                } else {
                    sunsetEnabled = enabled;
                }
                int sunriseSunsetByte = 0;
                if (sunriseEnabled) {
                    ++sunriseSunsetByte;
                }
                if (sunsetEnabled) {
                    sunriseSunsetByte += 2;
                }
                device.setProperty("SUNRISE_ENABLED", sunriseEnabled);
                device.setProperty("SUNSET_ENABLED", sunsetEnabled);
                return Collections.singletonList(new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.SET_SUNRISE_SUNSET.getCode(), VelbusPacket.PacketPriority.LOW, -1, (byte)sunriseSunsetByte));
            }).orElse(null);
        }
        if (property.startsWith("ALARM")) {
            String alarmProperty;
            int alarmNumber;
            try {
                alarmNumber = Integer.parseInt(property.substring(5, 6));
            }
            catch (NumberFormatException e) {
                AbstractVelbusProtocol.LOG.log(Level.INFO, "Alarm number must be number 1 or 2");
                return null;
            }
            switch (alarmProperty = property.substring(7)) {
                case "ENABLED": 
                case "WAKE_TIME": 
                case "BED_TIME": {
                    int bedMins;
                    int bedHours;
                    int wakeMins;
                    int wakeHours;
                    String alarmEnabledProperty = "ALARM" + alarmNumber + "_ENABLED";
                    String alarmWakeTimeProperty = "ALARM" + alarmNumber + "_WAKE_TIME";
                    String alarmBedTimeProperty = "ALARM" + alarmNumber + "_BED_TIME";
                    String alarmMasterProperty = "ALARM" + alarmNumber + "_MASTER";
                    if (!(device.hasPropertyValue(alarmEnabledProperty) && device.hasPropertyValue(alarmWakeTimeProperty) && device.hasPropertyValue(alarmBedTimeProperty) && device.hasPropertyValue(alarmMasterProperty))) {
                        AbstractVelbusProtocol.LOG.info("Device cache doesn't contain alarm enabled, type and/or time properties");
                        return null;
                    }
                    boolean enabled2 = Optional.ofNullable((Boolean)device.getPropertyValue(alarmEnabledProperty)).orElse(false);
                    String wakeTime = (String)device.getPropertyValue(alarmWakeTimeProperty);
                    String bedTime = (String)device.getPropertyValue(alarmBedTimeProperty);
                    boolean isGlobal = Optional.ofNullable((Boolean)device.getPropertyValue(alarmMasterProperty)).orElse(false);
                    if ("ENABLED".equals(alarmProperty)) {
                        Optional setEnabled = ValueUtil.getBooleanCoerced((Object)value);
                        if (!setEnabled.isPresent()) {
                            return null;
                        }
                        enabled2 = (Boolean)setEnabled.get();
                    } else if ("WAKE_TIME".equals(alarmProperty)) {
                        if (value == null) {
                            return null;
                        }
                        wakeTime = value.toString();
                    } else if ("BED_TIME".equals(alarmProperty)) {
                        if (value == null) {
                            return null;
                        }
                        bedTime = value.toString();
                    }
                    String[] wakeTimeValues = wakeTime.split(":");
                    String[] bedTimeValues = bedTime.split(":");
                    if (wakeTimeValues.length != 2 || bedTimeValues.length != 2) {
                        AbstractVelbusProtocol.LOG.info("Time property values must be in the format HH:mm");
                        return null;
                    }
                    try {
                        wakeHours = Integer.parseInt(wakeTimeValues[0]);
                        wakeMins = Integer.parseInt(wakeTimeValues[1]);
                        bedHours = Integer.parseInt(bedTimeValues[0]);
                        bedMins = Integer.parseInt(bedTimeValues[1]);
                        if (wakeHours < 0 || wakeHours > 23 || wakeMins < 0 || wakeMins > 59 || bedHours < 0 || bedHours > 23 || bedMins < 0 || bedMins > 59) {
                            throw new NumberFormatException("Hours and/or minutes out of allowed range");
                        }
                    }
                    catch (NumberFormatException e) {
                        AbstractVelbusProtocol.LOG.log(Level.INFO, "Time property values must be in the format HH:mm", e);
                        return null;
                    }
                    device.setProperty(alarmEnabledProperty, enabled2);
                    device.setProperty(alarmWakeTimeProperty, wakeTime);
                    device.setProperty(alarmBedTimeProperty, bedTime);
                    device.velbusNetwork.scheduleTask(() -> {
                        List<VelbusPacket> packets = this.getStatusRequestPackets(device);
                        device.velbusNetwork.sendPackets(packets.toArray(new VelbusPacket[0]));
                    }, 500);
                    return Collections.singletonList(new VelbusPacket(isGlobal ? 0 : device.getBaseAddress(), VelbusPacket.OutboundCommand.SET_ALARM.getCode(), VelbusPacket.PacketPriority.LOW, (byte)alarmNumber, (byte)wakeHours, (byte)wakeMins, (byte)bedHours, (byte)bedMins, (byte)(enabled2 ? 1 : 0)));
                }
            }
        }
        return null;
    }

    @Override
    public boolean processReceivedPacket(VelbusDevice device, VelbusPacket packet) {
        VelbusPacket.InboundCommand packetCommand = VelbusPacket.InboundCommand.fromCode(packet.getCommand());
        switch (packetCommand) {
            case MODULE_STATUS: {
                int alarmByte;
                int programByte;
                int startChannel = ChannelProcessor.getStartChannelNumber(device, packet.getAddress());
                int maxChannelNumber = ChannelProcessor.getMaxChannelNumber(device.getDeviceType());
                if (startChannel < 0 || startChannel > maxChannelNumber) {
                    return false;
                }
                if (device.getDeviceType() == VelbusDeviceType.VMBMETEO || device.getDeviceType() == VelbusDeviceType.VMB4AN) {
                    programByte = packet.getByte(3) & 0xFF;
                    alarmByte = packet.getByte(4) & 0xFF;
                } else {
                    programByte = packet.getByte(5) & 0xFF;
                    alarmByte = packet.getByte(6) & 0xFF;
                }
                for (int i = startChannel; i < startChannel + 8; ++i) {
                    boolean programEnabled = (programByte & 1) == 0;
                    programByte >>>= 1;
                    device.setProperty("CH" + i + PROGRAM_STEPS_ENABLED_SUFFIX, programEnabled);
                }
                boolean allEnabled = true;
                for (int i = 1; i <= maxChannelNumber; ++i) {
                    boolean isChannelEnabled = Optional.ofNullable((Boolean)device.getPropertyValue("CH" + i + PROGRAM_STEPS_ENABLED_SUFFIX)).orElse(true);
                    if (isChannelEnabled) continue;
                    allEnabled = false;
                    break;
                }
                device.setProperty("ALL_PROGRAM_STEPS_ENABLED", allEnabled);
                if (startChannel == 1) {
                    device.setProperty("PROGRAM", (Object)Program.fromCode(alarmByte & 3));
                    device.setProperty("ALARM1_ENABLED", (alarmByte & 4) == 4);
                    device.setProperty("ALARM2_ENABLED", (alarmByte & 0x10) == 16);
                    device.setProperty("ALARM1_MASTER", (alarmByte & 8) == 8);
                    device.setProperty("ALARM2_MASTER", (alarmByte & 0x20) == 32);
                    device.setProperty("SUNRISE_ENABLED", (alarmByte & 0x40) == 64);
                    device.setProperty("SUNSET_ENABLED", (alarmByte & 0x80) == 128);
                }
                packet.setHandled(true);
                return false;
            }
            case MEMORY_BLOCK_DUMP: {
                Integer alarm1 = ProgramsProcessor.getAlarmMemoryLocation(1, device.getDeviceType());
                Integer alarm2 = ProgramsProcessor.getAlarmMemoryLocation(2, device.getDeviceType());
                int memoryLocation = (packet.getByte(1) & 0xFF) << 8 | packet.getByte(2) & 0xFF;
                int alarmNumber = 0;
                if (alarm1 != null && alarm1 == memoryLocation) {
                    alarmNumber = 1;
                } else if (alarm2 != null && alarm2 == memoryLocation) {
                    alarmNumber = 2;
                }
                if (alarmNumber == 0) {
                    return false;
                }
                int wakeHours = packet.getByte(3) & 0xFF;
                int wakeMins = packet.getByte(4) & 0xFF;
                int bedHours = packet.getByte(5) & 0xFF;
                int bedMins = packet.getByte(6) & 0xFF;
                String wakeTime = String.format("%02d:%02d", wakeHours, wakeMins);
                String bedTime = String.format("%02d:%02d", bedHours, bedMins);
                device.setProperty("ALARM" + alarmNumber + "_WAKE_TIME", wakeTime);
                device.setProperty("ALARM" + alarmNumber + "_BED_TIME", bedTime);
                return true;
            }
        }
        return false;
    }

    protected static List<VelbusPacket> getProgramStepsPackets(VelbusDevice device, int channelNumber, boolean enabled, int durationSeconds) {
        byte[] packetBytes = enabled ? new byte[1] : new byte[4];
        packetBytes[0] = (byte)channelNumber;
        if (!enabled) {
            int duration = (durationSeconds = Math.min(durationSeconds, 0xFFFFFE)) > 0 ? durationSeconds : 0xFFFFFF;
            packetBytes[1] = (byte)(duration >> 16);
            packetBytes[2] = (byte)(duration >> 8);
            packetBytes[3] = (byte)duration;
        }
        VelbusPacket.OutboundCommand command = enabled ? VelbusPacket.OutboundCommand.PROGRAM_STEPS_ENABLE : VelbusPacket.OutboundCommand.PROGRAM_STEPS_DISABLE;
        return Collections.singletonList(new VelbusPacket(device.getBaseAddress(), command.getCode(), VelbusPacket.PacketPriority.LOW, packetBytes));
    }

    protected static Integer getAlarmMemoryLocation(int alarmNumber, VelbusDeviceType deviceType) {
        Integer location = null;
        if (deviceType == VelbusDeviceType.VMBGPO || deviceType == VelbusDeviceType.VMBGPOD) {
            location = alarmNumber == 2 ? 649 : 645;
        } else if (deviceType == VelbusDeviceType.VMB6PBN || deviceType == VelbusDeviceType.VMB8PBU || deviceType == VelbusDeviceType.VMB7IN) {
            location = alarmNumber == 2 ? 152 : 148;
        } else if (deviceType == VelbusDeviceType.VMBGP1 || deviceType == VelbusDeviceType.VMBGP2 || deviceType == VelbusDeviceType.VMBGP4 || deviceType == VelbusDeviceType.VMBGP4PIR) {
            location = alarmNumber == 2 ? 169 : 165;
        } else if (deviceType == VelbusDeviceType.VMBPIRC || deviceType == VelbusDeviceType.VMBPIRO || deviceType == VelbusDeviceType.VMBPIRM) {
            location = alarmNumber == 2 ? 54 : 50;
        } else if (deviceType == VelbusDeviceType.VMBMETEO) {
            location = alarmNumber == 2 ? 136 : 132;
        } else if (deviceType == VelbusDeviceType.VMB4AN) {
            location = alarmNumber == 2 ? 74 : 70;
        }
        return location;
    }

    static enum Program {
        NONE(0),
        SUMMER(1),
        WINTER(2),
        HOLIDAY(3);

        private final int code;

        private Program(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public String toString() {
            return super.toString() + "(" + this.code + ")";
        }

        public static Program fromCode(int code) {
            for (Program type : Program.values()) {
                if (type.getCode() != code) continue;
                return type;
            }
            return NONE;
        }
    }
}

