/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus.device;

import java.util.Optional;
import org.openremote.agent.protocol.velbus.device.ChannelProcessor;
import org.openremote.model.util.EnumUtil;

public abstract class OutputChannelProcessor
extends ChannelProcessor {
    protected OutputChannelProcessor() {
    }

    public static enum ChannelSetting {
        NORMAL(0),
        INHIBITED(1),
        FORCED(2),
        LOCKED(3, 4);

        private final int code;
        private final int code2;

        private ChannelSetting(int code) {
            this(code, 0);
        }

        private ChannelSetting(int code, int code2) {
            this.code = code;
            this.code2 = code2;
        }

        public int getCode() {
            return this.code;
        }

        public static ChannelSetting fromCode(int code) {
            for (ChannelSetting type : ChannelSetting.values()) {
                if (type.getCode() != code && type.code2 != code) continue;
                return type;
            }
            return NORMAL;
        }

        public static Optional<ChannelSetting> fromValue(Object value) {
            if (value == null) {
                return Optional.empty();
            }
            return EnumUtil.enumFromValue(ChannelSetting.class, (Object)value);
        }
    }
}

