/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus.device;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openremote.agent.protocol.velbus.AbstractVelbusProtocol;
import org.openremote.agent.protocol.velbus.VelbusPacket;
import org.openremote.agent.protocol.velbus.device.FeatureProcessor;
import org.openremote.agent.protocol.velbus.device.VelbusDevice;
import org.openremote.agent.protocol.velbus.device.VelbusDeviceType;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.ValueType;

public class OLEDProcessor
extends FeatureProcessor {
    @Override
    public List<FeatureProcessor.PropertyDescriptor> getPropertyDescriptors(VelbusDeviceType deviceType) {
        return Collections.singletonList(new FeatureProcessor.PropertyDescriptor("memoText", "Memo Text", "MEMO_TEXT", ValueType.TEXT));
    }

    @Override
    public List<VelbusPacket> getPropertyWritePackets(VelbusDevice device, String property, Object value) {
        if (property.equals("MEMO_TEXT")) {
            return ValueUtil.getString((Object)value).map(text -> {
                int endPos;
                if (text.length() == 0) {
                    device.setProperty("MEMO_TEXT", "");
                    return Collections.singletonList(this.getCancelMemoTextPacket(device));
                }
                String[] vals = text.trim().split(":");
                int timeout = 5;
                if (vals.length > 1) {
                    try {
                        timeout = Integer.parseInt(vals[vals.length - 1]);
                    }
                    catch (NumberFormatException e) {
                        AbstractVelbusProtocol.LOG.fine("Last section of command value '" + vals[vals.length - 1] + "' is not a number so using default value");
                    }
                }
                endPos = (endPos = text.lastIndexOf(":")) > 0 ? endPos : text.length();
                endPos = Math.min(62, endPos);
                text = text.substring(0, endPos);
                ArrayList<VelbusPacket> packets = new ArrayList<VelbusPacket>();
                byte[] bytes = text.getBytes(StandardCharsets.ISO_8859_1);
                int counter = 0;
                byte[] packetBytes = new byte[7];
                packetBytes[0] = 0;
                packetBytes[1] = 0;
                for (int i = 0; i <= text.length(); ++i) {
                    byte by = packetBytes[counter + 2] = i == text.length() ? (byte)0 : bytes[i];
                    if (++counter <= 4 && i != text.length()) continue;
                    byte[] pBytes = Arrays.copyOf(packetBytes, counter + 2);
                    packets.add(new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.MEMO_TEXT.getCode(), VelbusPacket.PacketPriority.LOW, pBytes));
                    packetBytes[1] = (byte)((packetBytes[1] & 0xFF) + 5);
                    counter = 0;
                }
                int finalTimeout = timeout;
                device.velbusNetwork.scheduleTask(() -> {
                    device.velbusNetwork.sendPackets(this.getCancelMemoTextPacket(device));
                    device.setProperty("MEMO_TEXT", "");
                }, finalTimeout * 1000);
                device.setProperty("MEMO_TEXT", text);
                return packets;
            }).orElse(null);
        }
        return null;
    }

    @Override
    public boolean processReceivedPacket(VelbusDevice device, VelbusPacket packet) {
        VelbusPacket.InboundCommand packetCommand = VelbusPacket.InboundCommand.fromCode(packet.getCommand());
        switch (packetCommand) {
            case MODULE_STATUS: {
                device.setProperty("MEMO_TEXT", "");
                packet.setHandled(true);
                return false;
            }
        }
        return false;
    }

    protected VelbusPacket getCancelMemoTextPacket(VelbusDevice device) {
        return new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.MEMO_TEXT.getCode(), VelbusPacket.PacketPriority.LOW, 0, 0, 0, 0, 0, 0, 0);
    }
}

