/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus.device;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.openremote.agent.protocol.velbus.AbstractVelbusProtocol;
import org.openremote.agent.protocol.velbus.VelbusPacket;
import org.openremote.agent.protocol.velbus.device.ChannelProcessor;
import org.openremote.agent.protocol.velbus.device.FeatureProcessor;
import org.openremote.agent.protocol.velbus.device.VelbusDevice;
import org.openremote.agent.protocol.velbus.device.VelbusDeviceType;
import org.openremote.model.util.EnumUtil;
import org.openremote.model.util.Pair;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.ValueType;

public class InputProcessor
extends ChannelProcessor {
    @Override
    public List<FeatureProcessor.PropertyDescriptor> getPropertyDescriptors(VelbusDeviceType deviceType) {
        int maxChannelNumber = InputProcessor.getMaxChannelNumber(deviceType);
        ArrayList<FeatureProcessor.PropertyDescriptor> properties = new ArrayList<FeatureProcessor.PropertyDescriptor>(maxChannelNumber * PropertyType.values.length);
        for (int i = 1; i <= maxChannelNumber; ++i) {
            block9: for (PropertyType propertyType : PropertyType.values) {
                switch (propertyType) {
                    case CHANNEL_STATE: {
                        if (deviceType == VelbusDeviceType.VMB4AN) continue block9;
                        properties.add(new FeatureProcessor.PropertyDescriptor("ch" + i + "State", "CH" + i, "CH" + i, ValueType.TEXT));
                        continue block9;
                    }
                    case LED_STATE: {
                        if (deviceType == VelbusDeviceType.VMB4AN) continue block9;
                        properties.add(new FeatureProcessor.PropertyDescriptor("ch" + i + "LedState", "CH" + i + "LED State", "CH" + i + propertyType.getPropertySuffix(), ValueType.TEXT));
                        continue block9;
                    }
                    case LOCK_STATE: {
                        properties.add(new FeatureProcessor.PropertyDescriptor("ch" + i + "Locked", "CH" + i + " Locked", "CH" + i + propertyType.getPropertySuffix(), ValueType.BOOLEAN));
                        continue block9;
                    }
                    case LOCK_DURATION: {
                        properties.add(new FeatureProcessor.PropertyDescriptor("ch" + i + "LockDuration", "CH" + i + " Lock Duration (s)", "CH" + i + propertyType.getPropertySuffix(), ValueType.NUMBER));
                        continue block9;
                    }
                    case ENABLED_STATE: {
                        properties.add(new FeatureProcessor.PropertyDescriptor("ch" + i + "Enabled", "CH" + i + " Enabled", "CH" + i + propertyType.getPropertySuffix(), ValueType.BOOLEAN, true));
                        continue block9;
                    }
                    case INVERTED_STATE: {
                        properties.add(new FeatureProcessor.PropertyDescriptor("ch" + i + "Inverted", "CH" + i + " Inverted", "CH" + i + propertyType.getPropertySuffix(), ValueType.BOOLEAN, true));
                    }
                }
            }
        }
        return properties;
    }

    @Override
    public List<VelbusPacket> getStatusRequestPackets(VelbusDevice device) {
        for (int i = 1; i <= InputProcessor.getMaxChannelNumber(device.getDeviceType()); ++i) {
            device.setProperty("CH" + i, (Object)ChannelState.RELEASED);
            device.setProperty("CH" + i + "_ENABLED", false);
            device.setProperty("CH" + i + "_LOCKED", false);
            device.setProperty("CH" + i + "_INVERTED", false);
            device.setProperty("CH" + i + "_LED", (Object)FeatureProcessor.LedState.OFF);
        }
        if (device.getDeviceType() == VelbusDeviceType.VMB4AN) {
            return Collections.singletonList(new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.MODULE_STATUS.getCode(), -1));
        }
        return Collections.singletonList(new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.MODULE_STATUS.getCode(), 0));
    }

    @Override
    public List<VelbusPacket> getPropertyWritePackets(VelbusDevice device, String property, Object value) {
        return this.getChannelNumberAndPropertyType(device, property).map(channelNumberAndPropertyType -> {
            ArrayList packets = new ArrayList();
            int channelNumber = (Integer)channelNumberAndPropertyType.key;
            if (!InputProcessor.isChannelEnabled(device, channelNumber)) {
                AbstractVelbusProtocol.LOG.info("Write request to disabled channel so ignoring on device: " + device.getBaseAddress());
                return packets;
            }
            switch ((PropertyType)((Object)((Object)channelNumberAndPropertyType.value))) {
                case CHANNEL_STATE: {
                    if (device.getDeviceType() == VelbusDeviceType.VMB4AN) {
                        return null;
                    }
                    ChannelState.fromValue(value).ifPresent(channelState -> {
                        packets.addAll(InputProcessor.getChannelStatePackets(device, ChannelProcessor.getAddressForChannel(device, channelNumber), channelNumber, channelState));
                        device.setProperty(property, channelState);
                    });
                    break;
                }
                case LED_STATE: {
                    if (device.getDeviceType() == VelbusDeviceType.VMB4AN) {
                        return null;
                    }
                    EnumUtil.enumFromValue(FeatureProcessor.LedState.class, (Object)value).ifPresent(ledState -> {
                        packets.addAll(InputProcessor.getLedStatePackets(device, ChannelProcessor.getAddressForChannel(device, channelNumber), channelNumber, ledState));
                        device.setProperty(property, ledState);
                    });
                    break;
                }
                case LOCK_STATE: {
                    ValueUtil.getBoolean((Object)value).ifPresent(locked -> packets.addAll(InputProcessor.getLockStatePackets(device, channelNumber, locked != false ? -1 : 0)));
                    break;
                }
                case LOCK_DURATION: {
                    ValueUtil.getIntegerCoerced((Object)value).ifPresent(duration -> {
                        packets.addAll(InputProcessor.getLockStatePackets(device, channelNumber, duration));
                        device.setProperty(property, duration);
                    });
                }
            }
            return packets;
        }).orElse(null);
    }

    @Override
    public boolean processReceivedPacket(VelbusDevice device, VelbusPacket packet) {
        VelbusPacket.InboundCommand packetCommand = VelbusPacket.InboundCommand.fromCode(packet.getCommand());
        switch (packetCommand) {
            case MODULE_STATUS: {
                int lockByte;
                int statusByte;
                int startChannel = ChannelProcessor.getStartChannelNumber(device, packet.getAddress());
                if (startChannel < 0 || startChannel > InputProcessor.getMaxChannelNumber(device.getDeviceType())) {
                    return false;
                }
                int enabledByte = 255;
                int invertedByte = 0;
                if (device.getDeviceType() == VelbusDeviceType.VMBMETEO || device.getDeviceType() == VelbusDeviceType.VMB4AN) {
                    statusByte = packet.getByte(1) & 0xFF;
                    lockByte = packet.getByte(2) & 0xFF;
                } else {
                    statusByte = packet.getByte(1) & 0xFF;
                    enabledByte = packet.getByte(2) & 0xFF;
                    invertedByte = packet.getByte(3) & 0xFF;
                    lockByte = packet.getByte(4) & 0xFF;
                }
                for (int i = startChannel; i < startChannel + 8; ++i) {
                    ChannelState state = (statusByte & 1) == 1 ? ChannelState.PRESSED : ChannelState.RELEASED;
                    boolean enabled = (enabledByte & 1) == 1;
                    boolean inverted = (invertedByte & 1) == 0;
                    boolean locked = (lockByte & 1) == 1;
                    statusByte >>>= 1;
                    enabledByte >>>= 1;
                    invertedByte >>>= 1;
                    lockByte >>>= 1;
                    device.setProperty("CH" + i, (Object)state);
                    device.setProperty("CH" + i + "_ENABLED", enabled);
                    device.setProperty("CH" + i + "_LOCKED", locked);
                    device.setProperty("CH" + i + "_INVERTED", inverted);
                }
                packet.setHandled(true);
                return false;
            }
            case PUSH_BUTTON_STATUS: {
                int startChannel = ChannelProcessor.getStartChannelNumber(device, packet.getAddress());
                if (startChannel < 0 || startChannel > Math.max(1, ChannelProcessor.getMaxChannelNumber(device.getDeviceType()) - 7)) {
                    return false;
                }
                int pressedByte = packet.getByte(1) & 0xFF;
                int releasedByte = packet.getByte(2) & 0xFF;
                int longPressedByte = packet.getByte(3) & 0xFF;
                for (int i = startChannel; i < startChannel + 8; ++i) {
                    if ((pressedByte & 1) == 1) {
                        device.setProperty("CH" + i, (Object)ChannelState.PRESSED);
                    } else if ((releasedByte & 1) == 1) {
                        device.setProperty("CH" + i, (Object)ChannelState.RELEASED);
                    } else if ((longPressedByte & 1) == 1) {
                        device.setProperty("CH" + i, (Object)ChannelState.LONG_PRESSED);
                    }
                    pressedByte >>>= 1;
                    releasedByte >>>= 1;
                    longPressedByte >>>= 1;
                }
                return true;
            }
            case LED_STATUS: {
                int startChannel = ChannelProcessor.getStartChannelNumber(device, packet.getAddress());
                if (startChannel < 0 | startChannel < InputProcessor.getMaxChannelNumber(device.getDeviceType()) - 8) {
                    return false;
                }
                byte onByte = packet.getByte(1);
                byte slowByte = packet.getByte(2);
                byte fastByte = packet.getByte(3);
                for (int i = 0; i < 8; ++i) {
                    boolean on = (onByte >> i & 1) == 1;
                    boolean slow = (slowByte >> i & 1) == 1;
                    boolean fast = (fastByte >> i & 1) == 1;
                    String propertyName = "CH" + startChannel + i + "_LED";
                    if (on) {
                        device.setProperty(propertyName, (Object)FeatureProcessor.LedState.ON);
                        continue;
                    }
                    if (slow && fast) {
                        device.setProperty(propertyName, (Object)FeatureProcessor.LedState.VERYFAST);
                        continue;
                    }
                    if (slow) {
                        device.setProperty(propertyName, (Object)FeatureProcessor.LedState.SLOW);
                        continue;
                    }
                    if (!fast) continue;
                    device.setProperty(propertyName, (Object)FeatureProcessor.LedState.FAST);
                }
                return true;
            }
            case LED_OFF: 
            case LED_ON: 
            case LED_FAST: 
            case LED_SLOW: 
            case LED_VERYFAST: {
                int startChannel = ChannelProcessor.getStartChannelNumber(device, packet.getAddress());
                if (startChannel < 0 | startChannel < InputProcessor.getMaxChannelNumber(device.getDeviceType()) - 8) {
                    return false;
                }
                FeatureProcessor.LedState ledState = FeatureProcessor.LedState.valueOf(packetCommand.name().substring(4));
                byte ledByte = packet.getByte(1);
                for (int i = 0; i < 8; ++i) {
                    if ((ledByte >> i & 1) != 1) continue;
                    String propertyName = "CH" + startChannel + i + "_LED";
                    device.setProperty(propertyName, (Object)ledState);
                }
                return true;
            }
        }
        return false;
    }

    protected Optional<Pair<Integer, PropertyType>> getChannelNumberAndPropertyType(VelbusDevice device, String propertyName) {
        return this.getChannelNumberAndPropertySuffix(device, CHANNEL_REGEX, propertyName).map(pair -> PropertyType.fromPropertySuffix((String)pair.value).map(propertyType -> new Pair((Object)((Integer)pair.key), (Object)propertyType)).orElse(null));
    }

    protected static List<VelbusPacket> getChannelStatePackets(VelbusDevice velbusDevice, int address, int channelNumber, ChannelState channelState) {
        byte[] packetBytes = new byte[3];
        int byteIndex = channelState == ChannelState.PRESSED ? 0 : (channelState == ChannelState.RELEASED ? 1 : 2);
        packetBytes[byteIndex] = (byte)Math.pow(2.0, (channelNumber %= 8) - 1);
        return Collections.singletonList(new VelbusPacket(address, VelbusPacket.OutboundCommand.BUTTON_STATUS.getCode(), VelbusPacket.PacketPriority.HIGH, packetBytes));
    }

    protected static List<VelbusPacket> getLedStatePackets(VelbusDevice velbusDevice, int address, int channelNumber, FeatureProcessor.LedState ledState) {
        byte ledStateByte = (byte)(Math.pow(2.0, channelNumber) - 1.0);
        VelbusPacket.OutboundCommand ledCommand = VelbusPacket.OutboundCommand.valueOf("LED_" + ledState.toString());
        return Collections.singletonList(new VelbusPacket(address, ledCommand.getCode(), VelbusPacket.PacketPriority.LOW, ledStateByte));
    }

    static List<VelbusPacket> getLockStatePackets(VelbusDevice velbusDevice, int channelNumber, int lockDurationSeconds) {
        boolean locked = lockDurationSeconds != 0;
        byte[] packetBytes = locked ? new byte[4] : new byte[1];
        byte by = packetBytes[0] = velbusDevice.getDeviceType() == VelbusDeviceType.VMB4AN ? (byte)(channelNumber - 1) : (byte)channelNumber;
        if (locked) {
            int duration = (lockDurationSeconds = Math.min(lockDurationSeconds, 0xFFFFFE)) > 0 ? lockDurationSeconds : 0xFFFFFF;
            packetBytes[1] = (byte)(duration >> 16);
            packetBytes[2] = (byte)(duration >> 8);
            packetBytes[3] = (byte)duration;
        }
        VelbusPacket.OutboundCommand command = locked ? VelbusPacket.OutboundCommand.LOCK : VelbusPacket.OutboundCommand.LOCK_CANCEL;
        return Collections.singletonList(new VelbusPacket(velbusDevice.getBaseAddress(), command.getCode(), VelbusPacket.PacketPriority.HIGH, packetBytes));
    }

    protected static enum PropertyType {
        CHANNEL_STATE(""),
        LED_STATE("_LED"),
        LOCK_STATE("_LOCKED"),
        LOCK_DURATION("_LOCK"),
        ENABLED_STATE("_ENABLED"),
        INVERTED_STATE("_INVERTED");

        private static final PropertyType[] values;
        private String propertySuffix;

        private PropertyType(String propertySuffix) {
            this.propertySuffix = propertySuffix;
        }

        public String getPropertySuffix() {
            return this.propertySuffix;
        }

        public static Optional<PropertyType> fromPropertySuffix(String str) {
            for (PropertyType value : values) {
                if (!value.getPropertySuffix().equalsIgnoreCase(str)) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }

        static {
            values = PropertyType.values();
        }
    }

    public static enum ChannelState {
        PRESSED(1),
        RELEASED(2),
        LONG_PRESSED(4);

        private static final EnumSet<ChannelState> values;
        private final int code;

        private ChannelState(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Optional<ChannelState> fromValue(Object value) {
            if (value == null) {
                return Optional.empty();
            }
            if (ValueUtil.isBoolean(value.getClass())) {
                return ChannelState.fromBoolean(ValueUtil.getBoolean((Object)value).orElse(null));
            }
            return EnumUtil.enumFromValue(ChannelState.class, (Object)value);
        }

        public static Optional<ChannelState> fromCode(int integer) {
            for (ChannelState value : values) {
                if (value.getCode() != integer) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }

        public static Optional<ChannelState> fromBoolean(Boolean value) {
            if (value == null) {
                return Optional.of(RELEASED);
            }
            if (value.booleanValue()) {
                return Optional.of(LONG_PRESSED);
            }
            return Optional.of(PRESSED);
        }

        static {
            values = EnumSet.allOf(ChannelState.class);
        }
    }
}

