/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus.device;

import java.util.Collections;
import java.util.List;
import org.openremote.agent.protocol.velbus.VelbusPacket;
import org.openremote.agent.protocol.velbus.device.VelbusDevice;
import org.openremote.agent.protocol.velbus.device.VelbusDeviceType;
import org.openremote.model.value.ValueDescriptor;

public abstract class FeatureProcessor {
    protected FeatureProcessor() {
    }

    public abstract List<PropertyDescriptor> getPropertyDescriptors(VelbusDeviceType var1);

    public List<VelbusPacket> getStatusRequestPackets(VelbusDevice device) {
        return Collections.emptyList();
    }

    public abstract List<VelbusPacket> getPropertyWritePackets(VelbusDevice var1, String var2, Object var3);

    public abstract boolean processReceivedPacket(VelbusDevice var1, VelbusPacket var2);

    public static enum LedState {
        OFF(0),
        ON(128),
        SLOW(64),
        FAST(32),
        VERYFAST(16);

        private static final LedState[] values;
        private final int code;

        private LedState(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static LedState fromCode(int code) {
            for (LedState type : values) {
                if (type.getCode() != code) continue;
                return type;
            }
            return OFF;
        }

        static {
            values = LedState.values();
        }
    }

    public static class PropertyDescriptor {
        protected final String name;
        protected final String displayName;
        protected final String linkName;
        protected final ValueDescriptor<?> attributeValueDescriptor;
        protected final boolean readOnly;

        public PropertyDescriptor(String name, String displayName, String linkName, ValueDescriptor<?> attributeValueDescriptor) {
            this(name, displayName, linkName, attributeValueDescriptor, false);
        }

        public PropertyDescriptor(String name, String displayName, String linkName, ValueDescriptor<?> attributeValueDescriptor, boolean readOnly) {
            this.name = name;
            this.displayName = displayName;
            this.linkName = linkName;
            this.attributeValueDescriptor = attributeValueDescriptor;
            this.readOnly = readOnly;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public ValueDescriptor<?> getAttributeValueDescriptor() {
            return this.attributeValueDescriptor;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public String getLinkName() {
            return this.linkName;
        }
    }
}

