/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus.device;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.openremote.agent.protocol.velbus.VelbusPacket;
import org.openremote.agent.protocol.velbus.device.FeatureProcessor;
import org.openremote.agent.protocol.velbus.device.VelbusDevice;
import org.openremote.agent.protocol.velbus.device.VelbusDeviceType;
import org.openremote.model.attribute.AttributeExecuteStatus;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.ValueType;

public class CounterProcessor
extends FeatureProcessor {
    public static final List<FeatureProcessor.PropertyDescriptor> SUPPORTED_PROPERTIES = Arrays.asList(new FeatureProcessor.PropertyDescriptor("counter1Enabled", "Counter 1 Enabled", "COUNTER1_ENABLED", ValueType.BOOLEAN, true), new FeatureProcessor.PropertyDescriptor("counter2Enabled", "Counter 2 Enabled", "COUNTER2_ENABLED", ValueType.BOOLEAN, true), new FeatureProcessor.PropertyDescriptor("counter3Enabled", "Counter 3 Enabled", "COUNTER3_ENABLED", ValueType.BOOLEAN, true), new FeatureProcessor.PropertyDescriptor("counter4Enabled", "Counter 4 Enabled", "COUNTER4_ENABLED", ValueType.BOOLEAN, true), new FeatureProcessor.PropertyDescriptor("counter1Units", "Counter 1 Units", "COUNTER1_UNITS", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("counter2Units", "Counter 2 Units", "COUNTER2_UNITS", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("counter3Units", "Counter 3 Units", "COUNTER3_UNITS", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("counter4Units", "Counter 4 Units", "COUNTER4_UNITS", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("counter1Instant", "Counter 1 Instant", "COUNTER1_INSTANT", ValueType.NUMBER, true), new FeatureProcessor.PropertyDescriptor("counter2Instant", "Counter 2 Instant", "COUNTER2_INSTANT", ValueType.NUMBER, true), new FeatureProcessor.PropertyDescriptor("counter3Instant", "Counter 3 Instant", "COUNTER3_INSTANT", ValueType.NUMBER, true), new FeatureProcessor.PropertyDescriptor("counter4Instant", "Counter 4 Instant", "COUNTER4_INSTANT", ValueType.NUMBER, true), new FeatureProcessor.PropertyDescriptor("counter1", "Counter 1", "COUNTER1", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("counter2", "Counter 2", "COUNTER2", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("counter3", "Counter 3", "COUNTER3", ValueType.NUMBER), new FeatureProcessor.PropertyDescriptor("counter4", "Counter 4", "COUNTER4", ValueType.NUMBER));

    @Override
    public List<FeatureProcessor.PropertyDescriptor> getPropertyDescriptors(VelbusDeviceType deviceType) {
        return SUPPORTED_PROPERTIES;
    }

    @Override
    public List<VelbusPacket> getStatusRequestPackets(VelbusDevice device) {
        device.setProperty("COUNTER1_ENABLED", false);
        device.setProperty("COUNTER2_ENABLED", false);
        device.setProperty("COUNTER3_ENABLED", false);
        device.setProperty("COUNTER4_ENABLED", false);
        device.setProperty("COUNTER1", 0.0);
        device.setProperty("COUNTER2", 0.0);
        device.setProperty("COUNTER3", 0.0);
        device.setProperty("COUNTER4", 0.0);
        device.setProperty("COUNTER1_INSTANT", 0.0);
        device.setProperty("COUNTER2_INSTANT", 0.0);
        device.setProperty("COUNTER3_INSTANT", 0.0);
        device.setProperty("COUNTER4_INSTANT", 0.0);
        return Arrays.asList(new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.COUNTER_STATUS.getCode(), 15, 0), new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.READ_MEMORY.getCode(), 3, -2));
    }

    @Override
    public List<VelbusPacket> getPropertyWritePackets(VelbusDevice device, String property, Object value) {
        if (!property.endsWith("_RESET")) {
            return null;
        }
        return ValueUtil.getValueCoerced((Object)value, AttributeExecuteStatus.class).map(attributeExecuteStatus -> {
            if (attributeExecuteStatus != AttributeExecuteStatus.REQUEST_START) {
                return null;
            }
            Integer counter = null;
            if ("COUNTER1_RESET".equals(property)) {
                counter = 1;
            } else if ("COUNTER2_RESET".equals(property)) {
                counter = 2;
            } else if ("COUNTER3_RESET".equals(property)) {
                counter = 3;
            } else if ("COUNTER4_RESET".equals(property)) {
                counter = 4;
            }
            if (counter != null) {
                return Collections.singletonList(new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.COUNTER_RESET.getCode(), (byte)(counter - 1)));
            }
            return null;
        }).orElse(null);
    }

    @Override
    public boolean processReceivedPacket(VelbusDevice device, VelbusPacket packet) {
        VelbusPacket.InboundCommand packetCommand = VelbusPacket.InboundCommand.fromCode(packet.getCommand());
        switch (packetCommand) {
            case COUNTER_STATUS: {
                int channelNumber = (packet.getByte(1) & 3) + 1;
                int pulses = (packet.getByte(1) >> 2) * 100;
                int counter = ((packet.getByte(2) & 0xFF) << 24) + ((packet.getByte(3) & 0xFF) << 16) + ((packet.getByte(4) & 0xFF) << 8) + (packet.getByte(5) & 0xFF);
                int period = ((packet.getByte(6) & 0xFF) << 8) + (packet.getByte(7) & 0xFF);
                CounterUnits units = (CounterUnits)((Object)device.getPropertyValue("COUNTER" + channelNumber + "_UNITS"));
                boolean isElectric = units != null && units == CounterUnits.KILOWATTS;
                double value = (double)counter / (double)pulses;
                value = (double)Math.round(value * 100.0) / 100.0;
                device.setProperty("COUNTER" + channelNumber, value);
                double instant = 3600000.0 * (double)(isElectric ? 1000 : 1);
                instant /= (double)(period * pulses);
                instant = (double)Math.round(instant * 100.0) / 100.0;
                device.setProperty("COUNTER" + channelNumber + "_ENABLED", true);
                device.setProperty("COUNTER" + channelNumber + "_INSTANT", instant);
                return true;
            }
            case MEMORY_DATA: {
                if ((packet.getByte(1) & 0xFF) != 3 || (packet.getByte(2) & 0xFF) != 254) break;
                byte counterUnits = packet.getByte(3);
                CounterUnits[] counters = new CounterUnits[]{Optional.ofNullable((Boolean)device.getPropertyValue("COUNTER1_ENABLED")).orElse(false) != false ? CounterUnits.fromCode(counterUnits & 3) : null, Optional.ofNullable((Boolean)device.getPropertyValue("COUNTER2_ENABLED")).orElse(false) != false ? CounterUnits.fromCode((counterUnits & 0xC) >> 2) : null, Optional.ofNullable((Boolean)device.getPropertyValue("COUNTER3_ENABLED")).orElse(false) != false ? CounterUnits.fromCode((counterUnits & 0x30) >> 4) : null, Optional.ofNullable((Boolean)device.getPropertyValue("COUNTER4_ENABLED")).orElse(false) != false ? CounterUnits.fromCode((counterUnits & 0xC0) >> 6) : null};
                device.setProperty("COUNTER1_UNITS", (Object)counters[0]);
                device.setProperty("COUNTER2_UNITS", (Object)counters[1]);
                device.setProperty("COUNTER3_UNITS", (Object)counters[2]);
                device.setProperty("COUNTER4_UNITS", (Object)counters[3]);
                for (int i = 0; i < 4; ++i) {
                    if (counters[i] != CounterUnits.KILOWATTS) continue;
                    double val = Optional.ofNullable((Double)device.getPropertyValue("COUNTER" + (i + 1) + "_INSTANT")).orElse(0.0);
                    device.setProperty("COUNTER" + (i + 1) + "_INSTANT", val *= 1000.0);
                }
                return true;
            }
        }
        return false;
    }

    public static enum CounterUnits {
        RESERVED(0),
        LITRES(1),
        CUBICMETRES(2),
        KILOWATTS(3);

        private int code;

        private CounterUnits(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static CounterUnits fromCode(int code) {
            for (CounterUnits type : CounterUnits.values()) {
                if (type.getCode() != code) continue;
                return type;
            }
            return RESERVED;
        }
    }
}

