/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus.device;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openremote.agent.protocol.velbus.device.FeatureProcessor;
import org.openremote.agent.protocol.velbus.device.VelbusDevice;
import org.openremote.agent.protocol.velbus.device.VelbusDeviceType;
import org.openremote.model.util.Pair;

public abstract class ChannelProcessor
extends FeatureProcessor {
    protected static final Pattern CHANNEL_REGEX = Pattern.compile("^CH(\\d+)(.*$|$)");

    protected ChannelProcessor() {
    }

    protected static int getMaxChannelNumber(VelbusDeviceType velbusDeviceType) {
        if (velbusDeviceType == VelbusDeviceType.VMBGPOD || velbusDeviceType == VelbusDeviceType.VMBGPO) {
            return 32;
        }
        if (velbusDeviceType == VelbusDeviceType.VMB7IN || velbusDeviceType == VelbusDeviceType.VMB1TS) {
            return 7;
        }
        if (velbusDeviceType == VelbusDeviceType.VMB4RYNO || velbusDeviceType == VelbusDeviceType.VMB4RYLD) {
            return 5;
        }
        if (velbusDeviceType == VelbusDeviceType.VMB1RY || velbusDeviceType == VelbusDeviceType.VMBDME || velbusDeviceType == VelbusDeviceType.VMBDMI || velbusDeviceType == VelbusDeviceType.VMBDMIR || velbusDeviceType == VelbusDeviceType.VMB1BL) {
            return 1;
        }
        if (velbusDeviceType == VelbusDeviceType.VMB4DC) {
            return 4;
        }
        if (velbusDeviceType == VelbusDeviceType.VMB2BLE) {
            return 2;
        }
        return 8;
    }

    protected static int getAddressForChannel(VelbusDevice device, int channelNumber) {
        if (channelNumber < 1 || channelNumber > ChannelProcessor.getMaxChannelNumber(device.getDeviceType())) {
            return 0;
        }
        int addressIndex = Math.max(0, Math.min(3, (int)Math.floor((double)(channelNumber - 1) / 8.0)));
        return device.getAddress(addressIndex);
    }

    protected static boolean isChannelEnabled(VelbusDevice device, int channelNumber) {
        int channelAddress = ChannelProcessor.getAddressForChannel(device, channelNumber);
        return channelAddress > 0 && channelAddress < 255;
    }

    protected static int getStartChannelNumber(VelbusDevice velbusDevice, int address) {
        return velbusDevice.getAddressIndex(address) * 8 + 1;
    }

    protected Optional<Pair<Integer, String>> getChannelNumberAndPropertySuffix(VelbusDevice device, Pattern channelRegex, String property) {
        Matcher matcher = channelRegex.matcher(property);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        int channelNumber = Integer.parseInt(matcher.group(1));
        int address = ChannelProcessor.getAddressForChannel(device, channelNumber);
        if (address == 0 || address == 255) {
            return Optional.empty();
        }
        String propertySuffix = matcher.groupCount() == 2 ? matcher.group(2) : "";
        return Optional.of(new Pair((Object)channelNumber, (Object)propertySuffix));
    }
}

