/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus.device;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.openremote.agent.protocol.velbus.VelbusPacket;
import org.openremote.agent.protocol.velbus.device.ChannelProcessor;
import org.openremote.agent.protocol.velbus.device.FeatureProcessor;
import org.openremote.agent.protocol.velbus.device.OutputChannelProcessor;
import org.openremote.agent.protocol.velbus.device.VelbusDevice;
import org.openremote.agent.protocol.velbus.device.VelbusDeviceType;
import org.openremote.model.util.EnumUtil;
import org.openremote.model.util.Pair;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.ValueDescriptor;
import org.openremote.model.value.ValueType;

public class BlindProcessor
extends OutputChannelProcessor {
    protected static final List<Pair<String, ValueDescriptor<?>>> CHANNEL_PROPERTIES = Arrays.asList(new Pair((Object)"", (Object)ValueType.TEXT), new Pair((Object)"_SETTING", (Object)ValueType.TEXT), new Pair((Object)"_LED_UP", (Object)ValueType.TEXT), new Pair((Object)"_LED_DOWN", (Object)ValueType.TEXT), new Pair((Object)"_LOCKED", (Object)ValueType.BOOLEAN), new Pair((Object)"_INHIBITED", (Object)ValueType.BOOLEAN), new Pair((Object)"_POSITION", (Object)ValueType.NUMBER), new Pair((Object)"_UP", (Object)ValueType.NUMBER), new Pair((Object)"_DOWN", (Object)ValueType.NUMBER), new Pair((Object)"_FORCE_UP", (Object)ValueType.NUMBER), new Pair((Object)"_FORCE_DOWN", (Object)ValueType.NUMBER), new Pair((Object)"_LOCK", (Object)ValueType.NUMBER), new Pair((Object)"_INHIBIT", (Object)ValueType.NUMBER), new Pair((Object)"_INHIBIT_UP", (Object)ValueType.NUMBER), new Pair((Object)"_INHIBIT_DOWN", (Object)ValueType.NUMBER));

    @Override
    public List<VelbusPacket> getStatusRequestPackets(VelbusDevice device) {
        ArrayList<VelbusPacket> packets = new ArrayList<VelbusPacket>();
        for (int i = 1; i <= ChannelProcessor.getMaxChannelNumber(device.getDeviceType()); ++i) {
            byte channelByte = (byte)Math.pow(2.0, i - 1);
            packets.add(new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.MODULE_STATUS.getCode(), channelByte));
        }
        return packets;
    }

    @Override
    public List<FeatureProcessor.PropertyDescriptor> getPropertyDescriptors(VelbusDeviceType deviceType) {
        return IntStream.rangeClosed(1, ChannelProcessor.getMaxChannelNumber(deviceType)).mapToObj(Integer::toString).flatMap(chNumber -> CHANNEL_PROPERTIES.stream().map(propSuffix -> new FeatureProcessor.PropertyDescriptor("ch" + chNumber + TextUtil.toUpperCamelCase((String)((String)propSuffix.key)), ("CH" + chNumber + " " + TextUtil.toProperCase((String)((String)propSuffix.key), (boolean)true)).trim(), "CH" + chNumber + propSuffix, (ValueDescriptor)propSuffix.value))).collect(Collectors.toList());
    }

    @Override
    public List<VelbusPacket> getPropertyWritePackets(VelbusDevice device, String property, Object value) {
        return this.getChannelNumberAndPropertySuffix(device, CHANNEL_REGEX, property).map(channelNumberAndPropertySuffix -> {
            int channelNumber = (Integer)channelNumberAndPropertySuffix.key;
            VelbusPacket.OutboundCommand command = null;
            Integer[] params = new Integer[2];
            switch ((String)channelNumberAndPropertySuffix.value) {
                case "": {
                    command = ChannelState.fromValue(value).map(state -> {
                        switch (state) {
                            case UP: {
                                return VelbusPacket.OutboundCommand.BLIND_UP;
                            }
                            case DOWN: {
                                return VelbusPacket.OutboundCommand.BLIND_DOWN;
                            }
                            case HALT: {
                                return VelbusPacket.OutboundCommand.BLIND_HALT;
                            }
                        }
                        return null;
                    }).orElse(null);
                    break;
                }
                case "_SETTING": {
                    Optional<ChannelSetting> setting = ChannelSetting.fromValue(value);
                    if (!setting.isPresent()) {
                        return null;
                    }
                    switch (setting.get()) {
                        case NORMAL: {
                            return Stream.of(BlindProcessor.getPackets(device, channelNumber, VelbusPacket.OutboundCommand.INHIBIT_CANCEL, 0xFFFFFF, 0), BlindProcessor.getPackets(device, channelNumber, VelbusPacket.OutboundCommand.BLIND_FORCE_DOWN_CANCEL, 0xFFFFFF, 0), BlindProcessor.getPackets(device, channelNumber, VelbusPacket.OutboundCommand.BLIND_FORCE_UP_CANCEL, 0xFFFFFF, 0), BlindProcessor.getPackets(device, channelNumber, VelbusPacket.OutboundCommand.LOCK_CANCEL, 0xFFFFFF, 0)).flatMap(Collection::stream).collect(Collectors.toList());
                        }
                        case INHIBITED: {
                            params[0] = 0xFFFFFF;
                            command = VelbusPacket.OutboundCommand.INHIBIT;
                            break;
                        }
                        case INHIBITED_DOWN: {
                            params[0] = 0xFFFFFF;
                            command = VelbusPacket.OutboundCommand.BLIND_INHIBIT_DOWN;
                            break;
                        }
                        case INHIBITED_UP: {
                            params[0] = 0xFFFFFF;
                            command = VelbusPacket.OutboundCommand.BLIND_INHIBIT_UP;
                            break;
                        }
                        case FORCED_DOWN: {
                            params[0] = 0xFFFFFF;
                            command = VelbusPacket.OutboundCommand.BLIND_FORCE_DOWN;
                            break;
                        }
                        case FORCED_UP: {
                            params[0] = 0xFFFFFF;
                            command = VelbusPacket.OutboundCommand.BLIND_FORCE_UP;
                            break;
                        }
                        case LOCKED: {
                            params[0] = 0xFFFFFF;
                            command = VelbusPacket.OutboundCommand.LOCK;
                        }
                    }
                    break;
                }
                case "_LOCKED": {
                    command = ValueUtil.getBoolean((Object)value).map(locked -> {
                        params[0] = 0xFFFFFF;
                        return locked != false ? VelbusPacket.OutboundCommand.LOCK : VelbusPacket.OutboundCommand.LOCK_CANCEL;
                    }).orElse(null);
                    break;
                }
                case "_INHIBITED": {
                    command = ValueUtil.getBoolean((Object)value).map(inhibited -> {
                        params[0] = 0xFFFFFF;
                        return inhibited != false ? VelbusPacket.OutboundCommand.INHIBIT : VelbusPacket.OutboundCommand.INHIBIT_CANCEL;
                    }).orElse(null);
                    break;
                }
                case "_INHIBITED_UP": {
                    command = ValueUtil.getBoolean((Object)value).map(inhibited -> {
                        params[0] = 0xFFFFFF;
                        return inhibited != false ? VelbusPacket.OutboundCommand.BLIND_INHIBIT_UP : VelbusPacket.OutboundCommand.INHIBIT_CANCEL;
                    }).orElse(null);
                    break;
                }
                case "_INHIBITED_DOWN": {
                    command = ValueUtil.getBoolean((Object)value).map(inhibited -> {
                        params[0] = 0xFFFFFF;
                        return inhibited != false ? VelbusPacket.OutboundCommand.BLIND_INHIBIT_DOWN : VelbusPacket.OutboundCommand.INHIBIT_CANCEL;
                    }).orElse(null);
                    break;
                }
                case "_FORCED_DOWN": {
                    command = ValueUtil.getBoolean((Object)value).map(inhibited -> {
                        params[0] = 0xFFFFFF;
                        return inhibited != false ? VelbusPacket.OutboundCommand.BLIND_FORCE_DOWN : VelbusPacket.OutboundCommand.BLIND_FORCE_DOWN_CANCEL;
                    }).orElse(null);
                    break;
                }
                case "_FORCED_UP": {
                    command = ValueUtil.getBoolean((Object)value).map(inhibited -> {
                        params[0] = 0xFFFFFF;
                        return inhibited != false ? VelbusPacket.OutboundCommand.BLIND_FORCE_UP : VelbusPacket.OutboundCommand.BLIND_FORCE_UP_CANCEL;
                    }).orElse(null);
                    break;
                }
                case "_POSITION": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(position -> {
                        params[1] = position;
                        return position < 0 ? VelbusPacket.OutboundCommand.BLIND_HALT : VelbusPacket.OutboundCommand.BLIND_POSITION;
                    }).orElse(null);
                    break;
                }
                case "_LOCK": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[0] = duration;
                        return duration == 0 ? VelbusPacket.OutboundCommand.BLIND_LOCK_CANCEL : VelbusPacket.OutboundCommand.BLIND_LOCK;
                    }).orElse(null);
                    break;
                }
                case "_UP": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[0] = duration;
                        if (duration == 0) {
                            return VelbusPacket.OutboundCommand.BLIND_HALT;
                        }
                        return VelbusPacket.OutboundCommand.BLIND_UP;
                    }).orElse(null);
                    break;
                }
                case "_DOWN": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[0] = duration;
                        if (duration == 0) {
                            return VelbusPacket.OutboundCommand.BLIND_HALT;
                        }
                        return VelbusPacket.OutboundCommand.BLIND_DOWN;
                    }).orElse(null);
                    break;
                }
                case "_FORCE_UP": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[0] = duration;
                        return duration == 0 ? VelbusPacket.OutboundCommand.BLIND_FORCE_UP_CANCEL : VelbusPacket.OutboundCommand.BLIND_FORCE_UP;
                    }).orElse(null);
                    break;
                }
                case "_FORCE_DOWN": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[0] = duration;
                        return duration == 0 ? VelbusPacket.OutboundCommand.BLIND_FORCE_DOWN_CANCEL : VelbusPacket.OutboundCommand.BLIND_FORCE_DOWN;
                    }).orElse(null);
                    break;
                }
                case "_INHIBIT": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[0] = duration;
                        return duration == 0 ? VelbusPacket.OutboundCommand.INHIBIT_CANCEL : VelbusPacket.OutboundCommand.INHIBIT;
                    }).orElse(null);
                    break;
                }
                case "_INHIBIT_UP": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[0] = duration;
                        return duration == 0 ? VelbusPacket.OutboundCommand.INHIBIT_CANCEL : VelbusPacket.OutboundCommand.BLIND_INHIBIT_UP;
                    }).orElse(null);
                    break;
                }
                case "_INHIBIT_DOWN": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[0] = duration;
                        return duration == 0 ? VelbusPacket.OutboundCommand.INHIBIT_CANCEL : VelbusPacket.OutboundCommand.BLIND_INHIBIT_DOWN;
                    }).orElse(null);
                }
            }
            if (command != null) {
                return BlindProcessor.getPackets(device, channelNumber, command, params[0] == null ? 0 : params[0], params[1] == null ? 0 : params[1]);
            }
            return null;
        }).orElse(null);
    }

    @Override
    public boolean processReceivedPacket(VelbusDevice device, VelbusPacket packet) {
        VelbusPacket.InboundCommand packetCommand = VelbusPacket.InboundCommand.fromCode(packet.getCommand());
        if (packetCommand == VelbusPacket.InboundCommand.BLIND_STATUS) {
            int channelNumber = packet.getByte(1) & 0xFF;
            int blindPos = device.getDeviceType() == VelbusDeviceType.VMB2BLE ? packet.getByte(5) & 0xFF : 0;
            int stateValue = packet.getByte(3) & 0xFF;
            ChannelState state = stateValue == 0 ? ChannelState.HALT : (stateValue == 1 ? ChannelState.UP : ChannelState.DOWN);
            FeatureProcessor.LedState ledStateDown = FeatureProcessor.LedState.fromCode(packet.getByte(4) & 0xFF);
            FeatureProcessor.LedState ledStateUp = FeatureProcessor.LedState.fromCode(packet.getByte(4) << 4 & 0xFF);
            ChannelSetting setting = ChannelSetting.fromCode(packet.getByte(6) & 0xFF);
            boolean locked = setting == ChannelSetting.LOCKED;
            boolean inhibited = setting == ChannelSetting.INHIBITED;
            boolean inhibitedUp = setting == ChannelSetting.INHIBITED_UP;
            boolean inhibitedDown = setting == ChannelSetting.INHIBITED_DOWN;
            device.setProperty("CH" + channelNumber, (Object)state);
            device.setProperty("CH" + channelNumber + "_POSITION", blindPos);
            device.setProperty("CH" + channelNumber + "_SETTING", (Object)setting);
            device.setProperty("CH" + channelNumber + "_LED_DOWN", (Object)ledStateDown);
            device.setProperty("CH" + channelNumber + "_LED_UP", (Object)ledStateUp);
            device.setProperty("CH" + channelNumber + "_LOCKED", locked);
            device.setProperty("CH" + channelNumber + "_INHIBITED", inhibited);
            device.setProperty("CH" + channelNumber + "_INHIBITED_UP", inhibitedUp);
            device.setProperty("CH" + channelNumber + "_INHIBITED_DOWN", inhibitedDown);
            return true;
        }
        return false;
    }

    protected static List<VelbusPacket> getPackets(VelbusDevice velbusDevice, int channelNumber, VelbusPacket.OutboundCommand command, int durationSeconds, int position) {
        byte[] packetBytes = null;
        switch (command) {
            case BLIND_POSITION: {
                position = Math.min(100, Math.max(0, position));
                packetBytes = new byte[2];
                packetBytes[1] = (byte)position;
                break;
            }
            case BLIND_UP: 
            case BLIND_DOWN: 
            case BLIND_FORCE_UP: 
            case BLIND_FORCE_DOWN: 
            case BLIND_INHIBIT_UP: 
            case BLIND_INHIBIT_DOWN: 
            case LEVEL_ON_TIMER: 
            case BLIND_LOCK: 
            case INHIBIT: {
                durationSeconds = durationSeconds == -1 ? 0xFFFFFF : durationSeconds;
                durationSeconds = Math.min(0xFFFFFF, Math.max(0, durationSeconds));
                packetBytes = new byte[4];
                packetBytes[1] = (byte)(durationSeconds >> 16);
                packetBytes[2] = (byte)(durationSeconds >> 8);
                packetBytes[3] = (byte)durationSeconds;
                break;
            }
            case BLIND_HALT: 
            case INHIBIT_CANCEL: 
            case BLIND_FORCE_UP_CANCEL: 
            case BLIND_FORCE_DOWN_CANCEL: 
            case LOCK_CANCEL: 
            case BLIND_LOCK_CANCEL: {
                packetBytes = new byte[1];
            }
        }
        if (packetBytes != null) {
            packetBytes[0] = (byte)Math.pow(2.0, channelNumber - 1);
            return Collections.singletonList(new VelbusPacket(velbusDevice.getBaseAddress(), command.getCode(), VelbusPacket.PacketPriority.HIGH, packetBytes));
        }
        return null;
    }

    public static enum ChannelState {
        UP,
        DOWN,
        HALT;


        public static Optional<ChannelState> fromValue(Object value) {
            if (value == null) {
                return Optional.of(HALT);
            }
            if (ValueUtil.isBoolean(value.getClass())) {
                return ChannelState.fromBoolean(ValueUtil.getBoolean((Object)value).orElse(null));
            }
            return EnumUtil.enumFromValue(ChannelState.class, (Object)value);
        }

        public static Optional<ChannelState> fromBoolean(Boolean value) {
            if (value == null) {
                return Optional.of(HALT);
            }
            if (value.booleanValue()) {
                return Optional.of(DOWN);
            }
            return Optional.of(UP);
        }
    }

    public static enum ChannelSetting {
        NORMAL(0),
        INHIBITED(1),
        INHIBITED_DOWN(2),
        INHIBITED_UP(3),
        FORCED_DOWN(4),
        FORCED_UP(5),
        LOCKED(6);

        private final int code;

        private ChannelSetting(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ChannelSetting fromCode(int code) {
            for (ChannelSetting type : ChannelSetting.values()) {
                if (type.getCode() != code) continue;
                return type;
            }
            return NORMAL;
        }

        public static Optional<ChannelSetting> fromValue(Object value) {
            return EnumUtil.enumFromValue(ChannelSetting.class, (Object)value);
        }
    }
}

