/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus.device;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openremote.agent.protocol.velbus.VelbusPacket;
import org.openremote.agent.protocol.velbus.device.ChannelProcessor;
import org.openremote.agent.protocol.velbus.device.FeatureProcessor;
import org.openremote.agent.protocol.velbus.device.OutputChannelProcessor;
import org.openremote.agent.protocol.velbus.device.VelbusDevice;
import org.openremote.agent.protocol.velbus.device.VelbusDeviceType;
import org.openremote.model.util.EnumUtil;
import org.openremote.model.util.Pair;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.ValueDescriptor;
import org.openremote.model.value.ValueType;

public class AnalogOutputProcessor
extends OutputChannelProcessor {
    protected static final String DIMMER_PREFIX = "CH";
    protected static final String IO_PREFIX = "OUTPUT";
    protected static final Pattern IO_CHANNEL_REGEX = Pattern.compile("^OUTPUT(\\d+)(.*$|$)");
    protected static final List<Pair<String, ValueDescriptor<?>>> CHANNEL_PROPERTIES = Arrays.asList(new Pair((Object)"", (Object)ValueType.TEXT), new Pair((Object)"_SETTING", (Object)ValueType.TEXT), new Pair((Object)"_LED", (Object)ValueType.TEXT), new Pair((Object)"_LOCKED", (Object)ValueType.BOOLEAN), new Pair((Object)"_INHIBITED", (Object)ValueType.BOOLEAN), new Pair((Object)"_FORCED", (Object)ValueType.BOOLEAN), new Pair((Object)"_LEVEL_AND_SPEED", (Object)ValueType.TEXT), new Pair((Object)"_LEVEL", (Object)ValueType.NUMBER), new Pair((Object)"_ON", (Object)ValueType.NUMBER), new Pair((Object)"_FORCE_ON", (Object)ValueType.NUMBER), new Pair((Object)"_LOCK", (Object)ValueType.NUMBER), new Pair((Object)"_INHIBIT", (Object)ValueType.NUMBER));

    @Override
    public List<VelbusPacket> getStatusRequestPackets(VelbusDevice device) {
        byte channelRequest = device.getDeviceType() == VelbusDeviceType.VMB4DC ? (byte)15 : 1;
        return Collections.singletonList(new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.MODULE_STATUS.getCode(), channelRequest));
    }

    @Override
    public List<FeatureProcessor.PropertyDescriptor> getPropertyDescriptors(VelbusDeviceType deviceType) {
        String chPrefix;
        ArrayList propertySuffixes = new ArrayList(CHANNEL_PROPERTIES);
        String string = chPrefix = deviceType == VelbusDeviceType.VMB4AN ? "Output " : DIMMER_PREFIX;
        if (deviceType == VelbusDeviceType.VMB4AN) {
            propertySuffixes.add(new Pair((Object)"_VALUE", (Object)ValueType.NUMBER));
            propertySuffixes.add(new Pair((Object)"_VALUE_AND_SPEED", (Object)ValueType.TEXT));
        }
        int channelCount = deviceType == VelbusDeviceType.VMB4AN ? 4 : ChannelProcessor.getMaxChannelNumber(deviceType);
        return IntStream.rangeClosed(1, channelCount).mapToObj(Integer::toString).flatMap(chNumber -> propertySuffixes.stream().map(propSuffix -> new FeatureProcessor.PropertyDescriptor(TextUtil.toLowerCamelCase((String)chPrefix).trim() + chNumber + TextUtil.toUpperCamelCase((String)((String)propSuffix.key)), (chPrefix + chNumber + " " + TextUtil.toProperCase((String)((String)propSuffix.key), (boolean)true)).trim(), this.getChannelPrefix(deviceType) + chNumber + (String)propSuffix.key, (ValueDescriptor)propSuffix.value))).collect(Collectors.toList());
    }

    protected String getChannelPrefix(VelbusDeviceType deviceType) {
        return deviceType == VelbusDeviceType.VMB4AN ? IO_PREFIX : DIMMER_PREFIX;
    }

    @Override
    public List<VelbusPacket> getPropertyWritePackets(VelbusDevice device, String property, Object value) {
        return this.getChannelNumberAndPropertySuffix(device, device.getDeviceType() == VelbusDeviceType.VMB4AN ? IO_CHANNEL_REGEX : CHANNEL_REGEX, property).map(channelNumberAndPropertySuffix -> {
            int channelNumber = (Integer)channelNumberAndPropertySuffix.key;
            VelbusPacket.OutboundCommand command = null;
            Integer[] params = new Integer[3];
            switch ((String)channelNumberAndPropertySuffix.value) {
                case "": {
                    command = ChannelState.fromValue(value).map(state -> {
                        switch (state) {
                            case OFF: {
                                params[0] = 0;
                                return VelbusPacket.OutboundCommand.SET_LEVEL;
                            }
                            case ON: {
                                params[0] = 100;
                                return VelbusPacket.OutboundCommand.SET_LEVEL;
                            }
                            case LAST: {
                                return VelbusPacket.OutboundCommand.SET_LEVEL_LAST;
                            }
                            case HALT: {
                                return VelbusPacket.OutboundCommand.SET_LEVEL_HALT;
                            }
                        }
                        return null;
                    }).orElse(null);
                    break;
                }
                case "_LOCKED": {
                    command = ValueUtil.getBoolean((Object)value).map(locked -> {
                        params[2] = 0xFFFFFF;
                        return locked != false ? VelbusPacket.OutboundCommand.LOCK : VelbusPacket.OutboundCommand.LOCK_CANCEL;
                    }).orElse(null);
                    break;
                }
                case "_FORCED": {
                    command = ValueUtil.getBoolean((Object)value).map(locked -> {
                        params[2] = 0xFFFFFF;
                        return locked != false ? VelbusPacket.OutboundCommand.FORCE_ON : VelbusPacket.OutboundCommand.FORCE_ON_CANCEL;
                    }).orElse(null);
                    break;
                }
                case "_INHIBITED": {
                    command = ValueUtil.getBoolean((Object)value).map(inhibited -> {
                        params[2] = 0xFFFFFF;
                        return inhibited != false ? VelbusPacket.OutboundCommand.INHIBIT : VelbusPacket.OutboundCommand.INHIBIT_CANCEL;
                    }).orElse(null);
                    break;
                }
                case "_VALUE_AND_SPEED": 
                case "_LEVEL_AND_SPEED": {
                    command = this.getLevelAndSpeedFromValue(value).map(levelAndSpeed -> {
                        params[0] = (Integer)levelAndSpeed.key;
                        params[1] = (Integer)levelAndSpeed.value;
                        return (Integer)levelAndSpeed.key < 0 ? VelbusPacket.OutboundCommand.SET_LEVEL_HALT : (((String)channelNumberAndPropertySuffix.value).equals("_VALUE_AND_SPEED") ? VelbusPacket.OutboundCommand.SET_VALUE : VelbusPacket.OutboundCommand.SET_LEVEL);
                    }).orElse(null);
                    break;
                }
                case "_VALUE": 
                case "_LEVEL": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(level -> {
                        params[0] = level;
                        return level < 0 ? VelbusPacket.OutboundCommand.SET_LEVEL_HALT : (((String)channelNumberAndPropertySuffix.value).equals("_VALUE") ? VelbusPacket.OutboundCommand.SET_VALUE : VelbusPacket.OutboundCommand.SET_LEVEL);
                    }).orElse(null);
                    break;
                }
                case "_LOCK": 
                case "_FORCE_OFF": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[2] = duration;
                        return duration == 0 ? VelbusPacket.OutboundCommand.LOCK_CANCEL : VelbusPacket.OutboundCommand.LOCK;
                    }).orElse(null);
                    break;
                }
                case "_ON": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[2] = duration;
                        if (duration == 0) {
                            params[0] = 0;
                            return VelbusPacket.OutboundCommand.SET_LEVEL;
                        }
                        return VelbusPacket.OutboundCommand.LEVEL_ON_TIMER;
                    }).orElse(null);
                    break;
                }
                case "_FORCE_ON": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[2] = duration;
                        return duration == 0 ? VelbusPacket.OutboundCommand.FORCE_ON_CANCEL : VelbusPacket.OutboundCommand.FORCE_ON;
                    }).orElse(null);
                    break;
                }
                case "_INHIBIT": {
                    command = ValueUtil.getIntegerCoerced((Object)value).map(duration -> {
                        params[2] = duration;
                        return duration == 0 ? VelbusPacket.OutboundCommand.INHIBIT_CANCEL : VelbusPacket.OutboundCommand.INHIBIT;
                    }).orElse(null);
                }
            }
            if (command != null) {
                return this.getPackets(device, channelNumber, command, params[0] == null ? 0 : params[0], params[1] == null ? 0 : params[1], params[2] == null ? 0 : params[2]);
            }
            return null;
        }).orElse(null);
    }

    @Override
    public boolean processReceivedPacket(VelbusDevice device, VelbusPacket packet) {
        VelbusPacket.InboundCommand packetCommand = VelbusPacket.InboundCommand.fromCode(packet.getCommand());
        VelbusDeviceType deviceType = device.getDeviceType();
        switch (packetCommand) {
            case DIMMER_STATUS: 
            case OUT_LEVEL_STATUS: {
                int level;
                String levelPropertyName;
                int channelNumber = 1;
                String string = levelPropertyName = deviceType == VelbusDeviceType.VMB4AN ? "_VALUE" : "_LEVEL";
                if (packetCommand != VelbusPacket.InboundCommand.DIMMER_STATUS) {
                    if (device.getDeviceType() == VelbusDeviceType.VMB4AN) {
                        channelNumber = (packet.getByte(1) & 0xFF) - 11;
                        level = (packet.getByte(3) << 8) + packet.getByte(4);
                    } else {
                        channelNumber = (int)(Math.log(packet.getByte(1) & 0xFF) / Math.log(2.0)) + 1;
                        level = packet.getByte(3) & 0xFF;
                    }
                } else {
                    level = packet.getByte(3) & 0xFF;
                }
                OutputChannelProcessor.ChannelSetting setting = packetCommand == VelbusPacket.InboundCommand.DIMMER_STATUS ? OutputChannelProcessor.ChannelSetting.NORMAL : OutputChannelProcessor.ChannelSetting.fromCode(packet.getByte(2) & 3);
                ChannelState state = level > 0 ? ChannelState.ON : ChannelState.OFF;
                FeatureProcessor.LedState ledState = packetCommand == VelbusPacket.InboundCommand.DIMMER_STATUS ? FeatureProcessor.LedState.fromCode(packet.getByte(3) & 0xFF) : FeatureProcessor.LedState.fromCode(packet.getByte(4) & 0xFF);
                boolean locked = setting == OutputChannelProcessor.ChannelSetting.LOCKED;
                boolean inhibited = setting == OutputChannelProcessor.ChannelSetting.INHIBITED;
                device.setProperty(this.getChannelPrefix(deviceType) + channelNumber, (Object)state);
                device.setProperty(this.getChannelPrefix(deviceType) + channelNumber + "_SETTING", (Object)setting);
                device.setProperty(this.getChannelPrefix(deviceType) + channelNumber + levelPropertyName, level);
                device.setProperty(this.getChannelPrefix(deviceType) + channelNumber + "_LED", (Object)ledState);
                device.setProperty(this.getChannelPrefix(deviceType) + channelNumber + "_LOCKED", locked);
                device.setProperty(this.getChannelPrefix(deviceType) + channelNumber + "_INHIBITED", inhibited);
                return true;
            }
            case DIMMER_LEVEL_STATUS: {
                int channelNumber = (int)(Math.log(packet.getByte(1) & 0xFF) / Math.log(2.0)) + 1;
                int level = packet.getByte(2) & 0xFF;
                device.setProperty(this.getChannelPrefix(deviceType) + channelNumber + "_LEVEL", level);
                return true;
            }
            case PUSH_BUTTON_STATUS: {
                if (device.getDeviceType() == VelbusDeviceType.VMB4AN) break;
                int onByte = packet.getByte(1) & 0xFF;
                int offByte = packet.getByte(2) & 0xFF;
                for (int i = 1; i <= ChannelProcessor.getMaxChannelNumber(device.getDeviceType()); ++i) {
                    if ((onByte & 1) == 1) {
                        device.setProperty(this.getChannelPrefix(deviceType) + i, (Object)ChannelState.ON);
                    } else if ((offByte & 1) == 1) {
                        device.setProperty(this.getChannelPrefix(deviceType) + i, (Object)ChannelState.OFF);
                    }
                    onByte >>>= 1;
                    offByte >>>= 1;
                }
                return true;
            }
        }
        return false;
    }

    protected List<VelbusPacket> getPackets(VelbusDevice velbusDevice, int channelNumber, VelbusPacket.OutboundCommand command, int level, int speedSeconds, int durationSeconds) {
        byte[] packetBytes = null;
        switch (command) {
            case SET_VALUE: 
            case SET_LEVEL: 
            case SET_LEVEL_LAST: {
                speedSeconds = Math.min(65535, Math.max(0, speedSeconds));
                if (command == VelbusPacket.OutboundCommand.SET_VALUE) {
                    packetBytes = new byte[5];
                    packetBytes[1] = (byte)(level >> 8);
                    packetBytes[2] = (byte)level;
                    packetBytes[3] = (byte)(speedSeconds >> 8);
                    packetBytes[4] = (byte)speedSeconds;
                    break;
                }
                level = Math.min(100, Math.max(0, level));
                packetBytes = new byte[4];
                packetBytes[1] = (byte)level;
                packetBytes[2] = (byte)(speedSeconds >> 8);
                packetBytes[3] = (byte)speedSeconds;
                break;
            }
            case FORCE_ON: 
            case LEVEL_ON_TIMER: 
            case LOCK: 
            case INHIBIT: {
                durationSeconds = durationSeconds == -1 ? 0xFFFFFF : durationSeconds;
                durationSeconds = Math.min(0xFFFFFF, Math.max(0, durationSeconds));
                packetBytes = new byte[4];
                packetBytes[1] = (byte)(durationSeconds >> 16);
                packetBytes[2] = (byte)(durationSeconds >> 8);
                packetBytes[3] = (byte)durationSeconds;
                break;
            }
            case SET_LEVEL_HALT: {
                String ledProp = this.getChannelPrefix(velbusDevice.getDeviceType()) + channelNumber + "_LED";
                FeatureProcessor.LedState ledState = (FeatureProcessor.LedState)((Object)velbusDevice.getPropertyValue(ledProp));
                if (ledState == FeatureProcessor.LedState.FAST) {
                    velbusDevice.setProperty(ledProp, (Object)FeatureProcessor.LedState.ON);
                }
            }
            case INHIBIT_CANCEL: 
            case FORCE_ON_CANCEL: 
            case LOCK_CANCEL: {
                packetBytes = new byte[1];
            }
        }
        if (packetBytes != null) {
            packetBytes[0] = velbusDevice.getDeviceType() == VelbusDeviceType.VMB4AN ? (byte)(channelNumber + 11) : (byte)Math.pow(2.0, channelNumber - 1);
            if (command == VelbusPacket.OutboundCommand.LEVEL_ON_TIMER) {
                return Arrays.asList(new VelbusPacket(velbusDevice.getBaseAddress(), VelbusPacket.OutboundCommand.SET_LEVEL.getCode(), VelbusPacket.PacketPriority.HIGH, packetBytes[0], 100, 0, 0), new VelbusPacket(velbusDevice.getBaseAddress(), command.getCode(), VelbusPacket.PacketPriority.HIGH, packetBytes));
            }
            return Collections.singletonList(new VelbusPacket(velbusDevice.getBaseAddress(), command.getCode(), VelbusPacket.PacketPriority.HIGH, packetBytes));
        }
        return null;
    }

    protected Optional<Pair<Integer, Integer>> getLevelAndSpeedFromValue(Object value) {
        if (value == null) {
            return Optional.empty();
        }
        if (ValueUtil.isString(value.getClass())) {
            return ValueUtil.getString((Object)value).map(levelSpeedStr -> {
                String[] levelSpeedArr = levelSpeedStr.split("(?<=\\d):(?=\\d)");
                if (levelSpeedArr.length == 2) {
                    int level = Integer.parseInt(levelSpeedArr[0]);
                    int speed = Integer.parseInt(levelSpeedArr[1]);
                    return new Pair((Object)level, (Object)speed);
                }
                return null;
            });
        }
        if (ValueUtil.isArray(value.getClass())) {
            return ValueUtil.asJSONArray((Object)value).map(arr -> {
                Optional level = ValueUtil.getIntegerCoerced((Object)arr.get(0));
                Optional speed = ValueUtil.getIntegerCoerced((Object)arr.get(1));
                return level.isPresent() && speed.isPresent() ? new Pair((Object)((Integer)level.get()), (Object)((Integer)speed.get())) : null;
            });
        }
        if (ValueUtil.isObject(value.getClass())) {
            return ValueUtil.asJSONObject((Object)value).map(obj -> {
                Optional level = ValueUtil.getIntegerCoerced((Object)obj.get("level"));
                Optional speed = ValueUtil.getIntegerCoerced((Object)obj.get("speed"));
                return level.isPresent() && speed.isPresent() ? new Pair((Object)((Integer)level.get()), (Object)((Integer)speed.get())) : null;
            });
        }
        return Optional.empty();
    }

    public static enum ChannelState {
        OFF,
        ON,
        LAST,
        HALT;


        public static Optional<ChannelState> fromValue(Object value) {
            if (value == null) {
                return Optional.of(LAST);
            }
            if (value instanceof Boolean) {
                return ChannelState.fromBoolean((Boolean)value);
            }
            return EnumUtil.enumFromValue(ChannelState.class, (Object)value);
        }

        public static Optional<ChannelState> fromBoolean(Boolean value) {
            if (value == null) {
                return Optional.of(LAST);
            }
            if (value.booleanValue()) {
                return Optional.of(ON);
            }
            return Optional.of(OFF);
        }
    }
}

