/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus.device;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openremote.agent.protocol.velbus.VelbusPacket;
import org.openremote.agent.protocol.velbus.device.FeatureProcessor;
import org.openremote.agent.protocol.velbus.device.VelbusDevice;
import org.openremote.agent.protocol.velbus.device.VelbusDeviceType;
import org.openremote.model.value.ValueType;

public class AnalogInputProcessor
extends FeatureProcessor {
    protected static final String EMPTY_SENSOR_TEXT = "               ";
    protected static final List<FeatureProcessor.PropertyDescriptor> METEO_PROPERTIES = Arrays.asList(new FeatureProcessor.PropertyDescriptor("rainfall", "Rainfall", "RAINFALL", ValueType.POSITIVE_NUMBER, true), new FeatureProcessor.PropertyDescriptor("lightLevel", "Light Level", "LIGHT", ValueType.POSITIVE_NUMBER, true), new FeatureProcessor.PropertyDescriptor("windSpeed", "Wind Speed", "WIND", ValueType.POSITIVE_INTEGER, true));
    protected static final List<FeatureProcessor.PropertyDescriptor> IO_PROPERTIES = Arrays.asList(new FeatureProcessor.PropertyDescriptor("sensor1", "Sensor 1", "SENSOR1", ValueType.NUMBER, true), new FeatureProcessor.PropertyDescriptor("sensor2", "Sensor 2", "SENSOR2", ValueType.NUMBER, true), new FeatureProcessor.PropertyDescriptor("sensor3", "Sensor 3", "SENSOR3", ValueType.NUMBER, true), new FeatureProcessor.PropertyDescriptor("sensor4", "Sensor 4", "SENSOR4", ValueType.NUMBER, true), new FeatureProcessor.PropertyDescriptor("sensor1Text", "Sensor 1 Text", "SENSOR1_TEXT", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("sensor2Text", "Sensor 2 Text", "SENSOR2_TEXT", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("sensor3Text", "Sensor 3 Text", "SENSOR3_TEXT", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("sensor4Text", "Sensor 4 Text", "SENSOR4_TEXT", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("sensor1Type", "Sensor 1 Type", "SENSOR1_TYPE", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("sensor2Type", "Sensor 2 Type", "SENSOR2_TYPE", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("sensor3Type", "Sensor 3 Type", "SENSOR3_TYPE", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("sensor4Type", "Sensor 4 Type", "SENSOR4_TYPE", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("sensor1Mode", "Sensor 1 Mode", "SENSOR1_MODE", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("sensor2Mode", "Sensor 2 Mode", "SENSOR2_MODE", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("sensor3Mode", "Sensor 3 Mode", "SENSOR3_MODE", ValueType.TEXT, true), new FeatureProcessor.PropertyDescriptor("sensor4Mode", "Sensor 4 Mode", "SENSOR4_MODE", ValueType.TEXT, true));

    @Override
    public List<FeatureProcessor.PropertyDescriptor> getPropertyDescriptors(VelbusDeviceType deviceType) {
        return deviceType == VelbusDeviceType.VMBMETEO ? METEO_PROPERTIES : IO_PROPERTIES;
    }

    @Override
    public List<VelbusPacket> getStatusRequestPackets(VelbusDevice device) {
        if (device.getDeviceType() == VelbusDeviceType.VMBMETEO) {
            return Collections.singletonList(new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.SENSOR_READOUT.getCode(), 15, 0));
        }
        if (device.getDeviceType() == VelbusDeviceType.VMB4AN) {
            device.setProperty("SENSOR1_TEXT", EMPTY_SENSOR_TEXT);
            device.setProperty("SENSOR2_TEXT", EMPTY_SENSOR_TEXT);
            device.setProperty("SENSOR3_TEXT", EMPTY_SENSOR_TEXT);
            device.setProperty("SENSOR4_TEXT", EMPTY_SENSOR_TEXT);
            return Arrays.asList(new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.SENSOR_READOUT.getCode(), 8, 0), new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.SENSOR_READOUT.getCode(), 9, 0), new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.SENSOR_READOUT.getCode(), 10, 0), new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.SENSOR_READOUT.getCode(), 11, 0), new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.SENSOR_SETTINGS.getCode(), 8), new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.SENSOR_SETTINGS.getCode(), 9), new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.SENSOR_SETTINGS.getCode(), 10), new VelbusPacket(device.getBaseAddress(), VelbusPacket.OutboundCommand.SENSOR_SETTINGS.getCode(), 11));
        }
        return null;
    }

    @Override
    public List<VelbusPacket> getPropertyWritePackets(VelbusDevice device, String property, Object value) {
        return null;
    }

    @Override
    public boolean processReceivedPacket(VelbusDevice device, VelbusPacket packet) {
        VelbusPacket.InboundCommand packetCommand = VelbusPacket.InboundCommand.fromCode(packet.getCommand());
        switch (packetCommand) {
            case SENSOR_STATUS: {
                if (device.getDeviceType() != VelbusDeviceType.VMB4AN) break;
                int channel = (packet.getByte(1) & 0xFF) - 7;
                SensorType type = SensorType.fromCode(packet.getByte(2) & 3);
                SensorMode mode = SensorMode.fromCode(packet.getByte(2) & 0x30);
                String sensorName = "SENSOR" + channel;
                device.setProperty(sensorName + "_TYPE", (Object)type);
                device.setProperty(sensorName + "_MODE", (Object)mode);
                return true;
            }
            case RAW_SENSOR_STATUS: {
                if (device.getDeviceType() == VelbusDeviceType.VMBMETEO) {
                    int rainValue = Math.abs((packet.getByte(1) << 8) + packet.getByte(2));
                    int light = Math.abs((packet.getByte(3) << 8) + packet.getByte(4));
                    int windValue = Math.abs((packet.getByte(5) << 8) + packet.getByte(6));
                    double wind = 0.1 * (double)windValue;
                    double rain = 0.1 * (double)rainValue;
                    device.setProperty("RAINFALL", rain);
                    device.setProperty("LIGHT", light);
                    device.setProperty("WIND", wind);
                    return true;
                }
                if (device.getDeviceType() != VelbusDeviceType.VMB4AN) break;
                int channel = (packet.getByte(1) & 0xFF) - 7;
                SensorType type = SensorType.fromCode(packet.getByte(2) & 0xFF);
                double value = ((packet.getByte(3) & 0xFF) << 16) + ((packet.getByte(4) & 0xFF) << 8) + (packet.getByte(5) & 0xFF);
                value = type.getResolution() * value;
                String sensorName = "SENSOR" + channel;
                device.setProperty(sensorName, value);
                device.setProperty(sensorName + "_TYPE", (Object)type);
                return true;
            }
            case RAW_SENSOR_TEXT_STATUS: {
                if (device.getDeviceType() != VelbusDeviceType.VMB4AN) break;
                int channel = (packet.getByte(1) & 0xFF) - 7;
                String sensorText = (String)device.getPropertyValue("SENSOR" + channel + "_TEXT");
                try {
                    byte[] textBytes = sensorText.getBytes(StandardCharsets.ISO_8859_1);
                    int pos = packet.getByte(2) & 0xFF;
                    for (int i = 0; i < 5; ++i) {
                        int c = packet.getByte(3 + i) & 0xFF;
                        if (c == 0) {
                            for (int j = pos + i; j < 15; ++j) {
                                textBytes[j] = 32;
                            }
                            break;
                        }
                        textBytes[pos + i] = (byte)c;
                    }
                    sensorText = new String(textBytes, StandardCharsets.ISO_8859_1);
                }
                catch (Exception e) {
                    sensorText = EMPTY_SENSOR_TEXT;
                }
                device.setProperty("SENSOR" + channel + "_TEXT", sensorText);
                return true;
            }
        }
        return false;
    }

    public static enum SensorType {
        VOLTAGE(0, 2.5E-4),
        CURRENT(1, 5.0E-6),
        RESISTANCE(2, 0.25),
        PERIOD(3, 5.0E-7);

        private final int code;
        private final double resolution;

        private SensorType(int code, double resolution) {
            this.code = code;
            this.resolution = resolution;
        }

        public double getResolution() {
            return this.resolution;
        }

        public int getCode() {
            return this.code;
        }

        public static SensorType fromCode(int code) {
            for (SensorType type : SensorType.values()) {
                if (type.getCode() != code) continue;
                return type;
            }
            return VOLTAGE;
        }
    }

    public static enum SensorMode {
        SAFE(0),
        NIGHT(16),
        DAY(32),
        COMFORT(48);

        private final int code;

        private SensorMode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static SensorMode fromCode(int code) {
            for (SensorMode type : SensorMode.values()) {
                if (type.getCode() != code) continue;
                return type;
            }
            return SAFE;
        }
    }
}

