/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus;

import io.netty.channel.ChannelHandler;
import java.util.Objects;
import org.openremote.agent.protocol.io.AbstractNettyIOClient;
import org.openremote.agent.protocol.io.IOClient;
import org.openremote.agent.protocol.tcp.TCPIOClient;
import org.openremote.agent.protocol.velbus.AbstractVelbusProtocol;
import org.openremote.agent.protocol.velbus.VelbusPacket;
import org.openremote.agent.protocol.velbus.VelbusPacketDecoder;
import org.openremote.agent.protocol.velbus.VelbusPacketEncoder;
import org.openremote.agent.protocol.velbus.VelbusTCPAgent;
import org.openremote.model.util.TextUtil;

public class VelbusTCPProtocol
extends AbstractVelbusProtocol<VelbusTCPProtocol, VelbusTCPAgent> {
    public static final String PROTOCOL_DISPLAY_NAME = "VELBUS TCP";

    public VelbusTCPProtocol(VelbusTCPAgent agent) {
        super(agent);
    }

    public String getProtocolName() {
        return PROTOCOL_DISPLAY_NAME;
    }

    @Override
    protected IOClient<VelbusPacket> createIoClient(VelbusTCPAgent agent) throws RuntimeException {
        String host = agent.getHost().orElse(null);
        Integer port = agent.getPort().orElse(null);
        TextUtil.requireNonNullAndNonEmpty((String)host, (String)"Host cannot be null or empty");
        Objects.requireNonNull(port, "Port cannot be null");
        TCPIOClient<VelbusPacket> client = new TCPIOClient<VelbusPacket>(host, port);
        client.setEncoderDecoderProvider(() -> new ChannelHandler[]{new VelbusPacketEncoder(), new VelbusPacketDecoder(), new AbstractNettyIOClient.MessageToMessageDecoder<VelbusPacket>(VelbusPacket.class, client)});
        return client;
    }
}

