/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus;

import io.netty.channel.ChannelHandler;
import org.openremote.agent.protocol.io.AbstractNettyIOClient;
import org.openremote.agent.protocol.io.IOClient;
import org.openremote.agent.protocol.serial.SerialIOClient;
import org.openremote.agent.protocol.velbus.AbstractVelbusProtocol;
import org.openremote.agent.protocol.velbus.VelbusPacket;
import org.openremote.agent.protocol.velbus.VelbusPacketDecoder;
import org.openremote.agent.protocol.velbus.VelbusPacketEncoder;
import org.openremote.agent.protocol.velbus.VelbusSerialAgent;
import org.openremote.model.util.TextUtil;

public class VelbusSerialProtocol
extends AbstractVelbusProtocol<VelbusSerialProtocol, VelbusSerialAgent> {
    public static final String PROTOCOL_DISPLAY_NAME = "VELBUS Serial";
    public static final int DEFAULT_BAUDRATE = 38400;

    public VelbusSerialProtocol(VelbusSerialAgent agent) {
        super(agent);
    }

    public String getProtocolName() {
        return PROTOCOL_DISPLAY_NAME;
    }

    @Override
    protected IOClient<VelbusPacket> createIoClient(VelbusSerialAgent agent) throws RuntimeException {
        String port = agent.getSerialPort().orElse(null);
        int baudRate = agent.getSerialBaudrate().orElse(38400);
        TextUtil.requireNonNullAndNonEmpty((String)port, (String)"Port cannot be null or empty");
        SerialIOClient<VelbusPacket> client = new SerialIOClient<VelbusPacket>(port, baudRate);
        client.setEncoderDecoderProvider(() -> new ChannelHandler[]{new VelbusPacketEncoder(), new VelbusPacketDecoder(), new AbstractNettyIOClient.MessageToMessageDecoder<VelbusPacket>(VelbusPacket.class, client)});
        return client;
    }
}

