/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.openremote.agent.protocol.velbus.VelbusPacket;

public final class VelbusPacketDecoder
extends ByteToMessageDecoder {
    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> messages) throws Exception {
        int startIndex = buf.indexOf(0, buf.capacity() - 1, (byte)15);
        if (startIndex < 0) {
            return;
        }
        if (startIndex > 0) {
            buf.readerIndex(startIndex);
            buf.discardReadBytes();
        }
        if (buf.readableBytes() < 4) {
            return;
        }
        byte dataSize = buf.getByte(3);
        if (buf.readableBytes() < 6 + dataSize) {
            return;
        }
        int endIndex = buf.indexOf(4 + dataSize, 14, (byte)4);
        if (endIndex < 0) {
            if (buf.readableBytes() > 14) {
                buf.readerIndex(14);
                buf.discardReadBytes();
            }
            return;
        }
        byte[] packetBytes = new byte[endIndex + 1];
        buf.readBytes(packetBytes);
        buf.discardReadBytes();
        VelbusPacket packet = new VelbusPacket(packetBytes);
        if (packet.isValid()) {
            messages.add(packet);
        }
    }
}

