/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus;

import java.util.Objects;

public class VelbusPacket {
    public static final int MIN_PACKET_SIZE = 6;
    public static final int MAX_PACKET_SIZE = 14;
    public static final byte STX = 15;
    public static final byte ETX = 4;
    private byte[] rawPacket = new byte[14];
    private boolean handled;

    public VelbusPacket(byte[] content) {
        this.rawPacket = content;
    }

    public VelbusPacket() {
        this(0);
    }

    public VelbusPacket(int address) {
        this(address, PacketPriority.LOW, 0, false);
    }

    public VelbusPacket(int address, int command, byte ... dataBytes) {
        this(address, command, PacketPriority.LOW, dataBytes);
    }

    public VelbusPacket(int address, int command, PacketPriority priority, byte ... dataBytes) {
        this(address);
        this.setCommand(command);
        this.setDataSize(dataBytes.length + 1);
        this.setPriority(priority);
        for (int i = 0; i < dataBytes.length; i = (int)((byte)(i + 1))) {
            this.setByte(i + 1, dataBytes[i]);
        }
    }

    public VelbusPacket(int address, PacketPriority priority, int dataSize, boolean rtr) {
        this.setAddress(address);
        this.setPriority(PacketPriority.LOW);
        this.setDataSize(dataSize);
        this.setRtr(rtr);
    }

    public static byte calculateChecksum(VelbusPacket packet) {
        int checksum = 0;
        for (int i = 0; i <= packet.getSize() - 3; ++i) {
            checksum = (byte)(checksum + packet.rawPacket[i]);
        }
        return (byte)(-checksum);
    }

    public int getAddress() {
        return this.rawPacket[2] & 0xFF;
    }

    public void setAddress(int address) {
        this.rawPacket[2] = (byte)address;
    }

    public int getTypeCode() {
        return this.rawPacket[5] & 0xFF;
    }

    public void setTypeCode(int typeCode) {
        this.rawPacket[5] = (byte)typeCode;
    }

    public int getDataSize() {
        return this.rawPacket[3] & 0xF;
    }

    public void setDataSize(int dataSize) {
        this.rawPacket[3] = (byte)((this.rawPacket[3] & 0xF0) + dataSize);
    }

    public int getSize() {
        return this.getDataSize() + 6;
    }

    public byte getChecksum() {
        return this.rawPacket[this.rawPacket.length - 2];
    }

    public PacketPriority getPriority() {
        return this.rawPacket[1] == 248 ? PacketPriority.HIGH : PacketPriority.LOW;
    }

    public void setPriority(PacketPriority priority) {
        this.rawPacket[1] = (byte)priority.getValue();
    }

    public boolean getRtr() {
        return (this.rawPacket[3] & 0x40) == 64;
    }

    public void setRtr(boolean rtr) {
        this.rawPacket[3] = rtr ? (byte)(this.rawPacket[3] | 0x40) : (byte)(this.rawPacket[3] & 0xF);
    }

    public byte getByte(int index) {
        return this.rawPacket[4 + index];
    }

    public void setByte(int index, byte value) {
        this.rawPacket[4 + index] = value;
    }

    public int getInt(int index) {
        return this.getByte(index) & 0xFF;
    }

    public int getCommand() {
        if (this.getDataSize() <= 0) {
            return -1;
        }
        return this.getByte(0) & 0xFF;
    }

    public void setCommand(int command) {
        this.setByte(0, (byte)command);
    }

    public boolean hasCommand() {
        return this.getDataSize() >= 1;
    }

    public boolean isHandled() {
        return this.handled;
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    public byte[] pack() {
        this.rawPacket[0] = 15;
        this.rawPacket[this.getSize() - 1] = 4;
        this.rawPacket[this.getSize() - 2] = VelbusPacket.calculateChecksum(this);
        return this.rawPacket;
    }

    public VelbusPacket clone() {
        try {
            VelbusPacket packet = new VelbusPacket();
            for (int i = 0; i < this.getSize(); ++i) {
                packet.rawPacket[i] = this.rawPacket[i];
            }
            return packet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isValid() {
        return this.getSize() <= this.rawPacket.length && this.getChecksum() == VelbusPacket.calculateChecksum(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] packed = this.pack();
        for (int i = 0; i < 14; ++i) {
            if (i != 0) {
                stringBuilder.append(" ");
            }
            if (packed.length > i) {
                stringBuilder.append(String.format("%02X", packed[i] & 0xFF));
                continue;
            }
            stringBuilder.append("00");
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof VelbusPacket)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public static VelbusPacket fromString(String packetStr) {
        if (packetStr == null || packetStr.isEmpty()) {
            return null;
        }
        String[] byteStrs = packetStr.split("\\s");
        byte[] bytes = new byte[byteStrs.length];
        for (int i = 0; i < byteStrs.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(byteStrs[i], 16);
        }
        return new VelbusPacket(bytes);
    }

    public static enum PacketPriority {
        HIGH(248),
        LOW(251);

        private int value;

        private PacketPriority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum OutboundCommand {
        UNKNOWN(-1),
        MODULE_STATUS(250),
        REALTIME_CLOCK_SET(216),
        REALTIME_DATE_SET(183),
        DAYLIGHT_SAVING_SET(175),
        BUTTON_STATUS(0),
        RELAY_ON_TIMER(3),
        RELAY_BLINK_TIMER(13),
        RELAY_OFF(1),
        RELAY_ON(2),
        FORCE_ON(20),
        FORCE_ON_CANCEL(21),
        INHIBIT(22),
        INHIBIT_CANCEL(23),
        LOCK(18),
        LOCK_CANCEL(19),
        LED_OFF(245),
        LED_ON(246),
        LED_SLOW(247),
        LED_FAST(248),
        LED_VERYFAST(249),
        SENSOR_SETTINGS(231),
        READ_MEMORY(253),
        READ_MEMORY_BLOCK(201),
        WRITE_MEMORY(252),
        TEMP_SET(228),
        TEMP_MODE1_HEAT(224),
        TEMP_MODE1_COOL(223),
        TEMP_MODE2_COMFORT(219),
        TEMP_MODE2_DAY(220),
        TEMP_MODE2_NIGHT(221),
        TEMP_MODE2_SAFE(222),
        SET_ALARM(195),
        SET_LEVEL(7),
        SET_VALUE(7),
        SET_LEVEL_LAST(17),
        SET_LEVEL_HALT(16),
        LEVEL_ON_TIMER(8),
        BLIND_POSITION(28),
        BLIND_UP(5),
        BLIND_DOWN(6),
        BLIND_HALT(4),
        BLIND_LOCK(26),
        BLIND_LOCK_CANCEL(27),
        BLIND_FORCE_UP(18),
        BLIND_FORCE_UP_CANCEL(19),
        BLIND_FORCE_DOWN(20),
        BLIND_FORCE_DOWN_CANCEL(21),
        BLIND_INHIBIT_UP(24),
        BLIND_INHIBIT_DOWN(25),
        MEMO_TEXT(172),
        COUNTER_STATUS(189),
        COUNTER_RESET(173),
        PROGRAM_SELECT(179),
        SENSOR_READOUT(229),
        PROGRAM_STEPS_ENABLE(178),
        PROGRAM_STEPS_DISABLE(177),
        SET_SUNRISE_SUNSET(174);

        private int code;

        private OutboundCommand(int code) {
            this.code = code;
        }

        public static OutboundCommand fromCode(int code) {
            for (OutboundCommand type : OutboundCommand.values()) {
                if (type.getCode() != code) continue;
                return type;
            }
            return UNKNOWN;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum InboundCommand {
        UNKNOWN(-1),
        PUSH_BUTTON_STATUS(0),
        RELAY_STATUS(251),
        MODULE_TYPE(255),
        MODULE_SUBADDRESSES(176),
        MODULE_STATUS(237),
        SENSOR_STATUS(234),
        CURRENT_TEMP_STATUS(230),
        TEMP_SETTINGS1(232),
        TEMP_SETTINGS2(233),
        TIME_REQUEST(215),
        MEMORY_DATA(254),
        MEMORY_BLOCK_DUMP(204),
        DIMMER_LEVEL_STATUS(15),
        DIMMER_STATUS(238),
        OUT_LEVEL_STATUS(184),
        BLIND_STATUS(236),
        LED_OFF(245),
        LED_ON(246),
        LED_SLOW(247),
        LED_FAST(248),
        LED_VERYFAST(249),
        LED_STATUS(244),
        COUNTER_STATUS(190),
        RAW_SENSOR_STATUS(169),
        RAW_SENSOR_TEXT_STATUS(172);

        private int code;

        private InboundCommand(int code) {
            this.code = code;
        }

        public static InboundCommand fromCode(int code) {
            for (InboundCommand type : InboundCommand.values()) {
                if (type.getCode() != code) continue;
                return type;
            }
            return UNKNOWN;
        }

        public int getCode() {
            return this.code;
        }
    }
}

