/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.openremote.agent.protocol.io.IOClient;
import org.openremote.agent.protocol.velbus.AbstractVelbusProtocol;
import org.openremote.agent.protocol.velbus.VelbusPacket;
import org.openremote.agent.protocol.velbus.device.VelbusDevice;
import org.openremote.model.asset.agent.ConnectionStatus;

public class VelbusNetwork {
    protected static int DELAY_BETWEEN_PACKET_WRITES_MILLISECONDS = 100;
    protected final Integer timeInjectionIntervalSeconds;
    protected IOClient<VelbusPacket> client;
    protected final Queue<VelbusPacket> messageQueue = new ArrayDeque<VelbusPacket>();
    protected List<ScheduledFuture<?>> scheduledTasks = new ArrayList();
    protected ScheduledFuture<?> timeInjector;
    protected VelbusDevice[] devices = new VelbusDevice[254];
    protected VelbusDevice[] subAddressDevices = new VelbusDevice[254];
    protected ScheduledFuture<?> queueProcessingTask;
    protected ScheduledExecutorService executorService;
    protected final List<Consumer<ConnectionStatus>> connectionStatusConsumers = new ArrayList<Consumer<ConnectionStatus>>();

    public VelbusNetwork(IOClient<VelbusPacket> client, ScheduledExecutorService executorService, Integer timeInjectionIntervalSeconds) {
        this.client = client;
        this.executorService = executorService;
        this.timeInjectionIntervalSeconds = timeInjectionIntervalSeconds;
        client.addConnectionStatusConsumer(this::onConnectionStatusChanged);
        client.addMessageConsumer(this::onPacketReceived);
        this.onConnectionStatusChanged(this.getConnectionStatus());
        if (timeInjectionIntervalSeconds != null) {
            this.timeInjector = this.getExecutorService().scheduleWithFixedDelay(this::doTimeInjection, timeInjectionIntervalSeconds.intValue(), timeInjectionIntervalSeconds.intValue(), TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnectionStatusConsumer(Consumer<ConnectionStatus> connectionStatusConsumer) {
        List<Consumer<ConnectionStatus>> list = this.connectionStatusConsumers;
        synchronized (list) {
            this.connectionStatusConsumers.add(connectionStatusConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnectionStatusConsumer(Consumer<ConnectionStatus> connectionStatusConsumer) {
        List<Consumer<ConnectionStatus>> list = this.connectionStatusConsumers;
        synchronized (list) {
            this.connectionStatusConsumers.remove(connectionStatusConsumer);
        }
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPackets(VelbusPacket ... packets) {
        Object object = this;
        synchronized (object) {
            if (this.getConnectionStatus() != ConnectionStatus.CONNECTED) {
                return;
            }
        }
        object = this.messageQueue;
        synchronized (object) {
            this.messageQueue.addAll(Arrays.asList(packets));
            if (this.queueProcessingTask == null) {
                this.startSendingPackets();
            }
        }
    }

    public void connect() {
        if (this.client == null) {
            return;
        }
        this.client.connect();
    }

    public void disconnect() {
        this.scheduledTasks.forEach(task -> task.cancel(true));
        this.scheduledTasks.clear();
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.timeInjector != null) {
            this.timeInjector.cancel(true);
            this.timeInjector = null;
        }
        List<Consumer<ConnectionStatus>> list = this.connectionStatusConsumers;
        synchronized (list) {
            this.connectionStatusConsumers.clear();
        }
        this.disconnect();
        if (this.client != null) {
            this.client.removeConnectionStatusConsumer(this::onConnectionStatusChanged);
            this.client.removeMessageConsumer(this::onPacketReceived);
            this.client = null;
        }
    }

    public ConnectionStatus getConnectionStatus() {
        return this.client.getConnectionStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConnectionStatusChanged(ConnectionStatus status) {
        List<Consumer<ConnectionStatus>> object = this.connectionStatusConsumers;
        synchronized (object) {
            this.connectionStatusConsumers.forEach(consumer -> consumer.accept(status));
        }
        if (status == ConnectionStatus.CONNECTED) {
            Queue<VelbusPacket> queue = this.messageQueue;
            synchronized (queue) {
                this.messageQueue.clear();
            }
            for (VelbusDevice device : this.devices) {
                if (device == null) continue;
                device.initialise();
            }
        } else {
            for (VelbusDevice device : this.devices) {
                if (device == null) continue;
                device.reset();
            }
            Arrays.fill(this.subAddressDevices, null);
            Queue<VelbusPacket> queue = this.messageQueue;
            synchronized (queue) {
                this.messageQueue.clear();
                if (this.queueProcessingTask != null) {
                    this.queueProcessingTask.cancel(false);
                    this.queueProcessingTask = null;
                }
            }
        }
    }

    protected void onPacketReceived(VelbusPacket packet) {
        int address = packet.getAddress();
        if (address > 254 || address < 1) {
            return;
        }
        VelbusDevice matchingDevice = this.devices[address - 1];
        VelbusPacket.InboundCommand command = VelbusPacket.InboundCommand.fromCode(packet.getCommand());
        AbstractVelbusProtocol.LOG.finest("Received packet " + command + " : " + packet);
        if (matchingDevice != null) {
            matchingDevice.processReceivedPacket(packet);
        } else {
            matchingDevice = this.subAddressDevices[address - 1];
            if (matchingDevice != null) {
                matchingDevice.processReceivedPacket(packet);
            }
        }
    }

    public void addPropertyValueConsumer(int deviceAddress, String property, Consumer<Object> propertyValueConsumer) {
        boolean deviceExists;
        if (deviceAddress < 1 || deviceAddress > 254) {
            AbstractVelbusProtocol.LOG.warning("Invalid device address: " + deviceAddress);
            return;
        }
        VelbusDevice device = this.getDevice(deviceAddress);
        boolean bl = deviceExists = device != null;
        if (!deviceExists) {
            this.devices[deviceAddress - 1] = device = new VelbusDevice(deviceAddress, this);
        }
        device.addPropertyValueConsumer(property, propertyValueConsumer);
        if (!deviceExists && this.getConnectionStatus() == ConnectionStatus.CONNECTED) {
            device.initialise();
        }
    }

    public void removePropertyValueConsumer(int deviceAddress, String property, Consumer<Object> propertyValueConsumer) {
        if (deviceAddress < 1 || deviceAddress > 254) {
            AbstractVelbusProtocol.LOG.warning("Invalid device address: " + deviceAddress);
            return;
        }
        VelbusDevice device = this.getDevice(deviceAddress);
        if (device != null) {
            device.removePropertyValueConsumer(property, propertyValueConsumer);
        }
    }

    protected void removeAllDevices() {
        for (VelbusDevice device : this.devices) {
            if (device == null) continue;
            device.removeAllPropertyValueConsumers();
        }
    }

    public void writeProperty(int deviceAddress, String property, Object value) {
        if (this.getConnectionStatus() != ConnectionStatus.CONNECTED) {
            return;
        }
        if (deviceAddress < 1 || deviceAddress > 254) {
            AbstractVelbusProtocol.LOG.warning("Invalid device address: " + deviceAddress);
            return;
        }
        VelbusDevice device = this.getDevice(deviceAddress);
        if (device != null) {
            device.writeProperty(property, value);
        }
    }

    public void registerSubAddress(VelbusDevice velbusDevice, int subAddress) {
        if (subAddress < 1 || subAddress > 254) {
            AbstractVelbusProtocol.LOG.warning("Invalid device subaddress '" + subAddress + "' for device: " + velbusDevice.getBaseAddress());
            return;
        }
        this.subAddressDevices[subAddress - 1] = velbusDevice;
    }

    protected VelbusDevice getDevice(int address) {
        return this.devices[address - 1];
    }

    protected void startSendingPackets() {
        this.queueProcessingTask = this.getExecutorService().scheduleWithFixedDelay(this::doSendPacket, 0L, DELAY_BETWEEN_PACKET_WRITES_MILLISECONDS, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSendPacket() {
        VelbusPacket packet;
        if (this.getConnectionStatus() != ConnectionStatus.CONNECTED) {
            return;
        }
        Queue<VelbusPacket> queue = this.messageQueue;
        synchronized (queue) {
            packet = this.messageQueue.poll();
        }
        if (packet == null) {
            this.queueProcessingTask.cancel(false);
            this.queueProcessingTask = null;
            return;
        }
        VelbusPacket.OutboundCommand command = VelbusPacket.OutboundCommand.fromCode(packet.getCommand());
        AbstractVelbusProtocol.LOG.finest("Sending packet " + command + " : " + packet);
        this.client.sendMessage(packet);
    }

    public ScheduledFuture<?> scheduleTask(Runnable runnable, int delayMillis) {
        this.scheduledTasks.removeIf(Future::isDone);
        if (this.getConnectionStatus() == ConnectionStatus.CONNECTED) {
            ScheduledFuture<?> future = this.getExecutorService().schedule(runnable, (long)delayMillis, TimeUnit.MILLISECONDS);
            this.scheduledTasks.add(future);
            return future;
        }
        return null;
    }

    protected void doTimeInjection() {
        this.sendPackets(VelbusDevice.createTimeInjectionPackets());
    }
}

