/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.openremote.model.asset.agent.AgentLink;

public class VelbusAgentLink
extends AgentLink<VelbusAgentLink> {
    @NotBlank
    protected String deviceValueLink;
    @Min(value=1L)
    @Max(value=255L)
    @NotNull
    protected @Min(value=1L) @Max(value=255L) @NotNull Integer deviceAddress;

    protected VelbusAgentLink() {
    }

    @JsonCreator
    public VelbusAgentLink(@JsonProperty(value="id") String id, @JsonProperty(value="deviceAddress") Integer deviceAddress, @JsonProperty(value="deviceValueLink") String deviceValueLink) {
        super(id);
        this.deviceValueLink = deviceValueLink;
        this.deviceAddress = deviceAddress;
    }

    public Optional<String> getDeviceValueLink() {
        return Optional.ofNullable(this.deviceValueLink);
    }

    public VelbusAgentLink setDeviceValueLink(String deviceValueLink) {
        this.deviceValueLink = deviceValueLink;
        return this;
    }

    public Optional<Integer> getDeviceAddress() {
        return Optional.ofNullable(this.deviceAddress);
    }

    public VelbusAgentLink setDeviceAddress(Integer deviceAddress) {
        this.deviceAddress = deviceAddress;
        return this;
    }
}

