/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.velbus;

import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openremote.agent.protocol.AbstractProtocol;
import org.openremote.agent.protocol.io.IOClient;
import org.openremote.agent.protocol.velbus.VelbusAgent;
import org.openremote.agent.protocol.velbus.VelbusAgentLink;
import org.openremote.agent.protocol.velbus.VelbusNetwork;
import org.openremote.agent.protocol.velbus.VelbusPacket;
import org.openremote.agent.protocol.velbus.device.VelbusDeviceType;
import org.openremote.model.Container;
import org.openremote.model.asset.AssetTreeNode;
import org.openremote.model.asset.agent.AgentLink;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.asset.impl.ThingAsset;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.attribute.AttributeState;
import org.openremote.model.attribute.MetaItem;
import org.openremote.model.protocol.ProtocolAssetImport;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.EnumUtil;
import org.openremote.model.util.TextUtil;
import org.openremote.model.value.MetaItemType;
import org.openremote.model.value.ValueType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class AbstractVelbusProtocol<S extends AbstractVelbusProtocol<S, T>, T extends VelbusAgent<T, S>>
extends AbstractProtocol<T, VelbusAgentLink>
implements ProtocolAssetImport {
    public static final int DEFAULT_TIME_INJECTION_INTERVAL_SECONDS = 21600;
    public static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, AbstractVelbusProtocol.class);
    protected VelbusNetwork network;
    protected final Map<AttributeRef, Consumer<Object>> attributePropertyValueConsumers = new HashMap<AttributeRef, Consumer<Object>>();

    protected AbstractVelbusProtocol(T agent) {
        super(agent);
    }

    public String getProtocolInstanceUri() {
        return this.network != null && this.network.client != null ? this.network.client.getClientUri() : "";
    }

    @Override
    protected void doStart(Container container) throws Exception {
        try {
            IOClient<VelbusPacket> messageProcessor = this.createIoClient((VelbusAgent)this.agent);
            int timeInjectionSeconds = ((VelbusAgent)this.agent).getTimeInjectionInterval().orElse(21600);
            LOG.fine("Creating new VELBUS network instance for protocol instance: " + this.agent);
            this.network = new VelbusNetwork(messageProcessor, this.executorService, timeInjectionSeconds);
            this.network.connect();
            this.network.addConnectionStatusConsumer(x$0 -> this.setConnectionStatus((ConnectionStatus)x$0));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to create IO client for protocol instance: " + this.agent, e);
            this.setConnectionStatus(ConnectionStatus.ERROR);
            throw e;
        }
    }

    @Override
    protected void doStop(Container container) throws Exception {
        if (this.network != null) {
            this.network.removeConnectionStatusConsumer(x$0 -> this.setConnectionStatus((ConnectionStatus)x$0));
            this.network.disconnect();
            this.network.close();
        }
    }

    @Override
    protected void doLinkAttribute(String assetId, Attribute<?> attribute, VelbusAgentLink agentLink) {
        int deviceAddress = (Integer)AgentLink.getOrThrowAgentLinkProperty(agentLink.getDeviceAddress(), (String)"device address");
        String property = (String)AgentLink.getOrThrowAgentLinkProperty(agentLink.getDeviceValueLink(), (String)"device value");
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        LOG.fine("Linking attribute to device '" + deviceAddress + "' and property '" + property + "': " + attributeRef);
        Consumer<Object> propertyValueConsumer = propertyValue -> this.updateLinkedAttribute(new AttributeState(attributeRef, propertyValue));
        this.attributePropertyValueConsumers.put(attributeRef, propertyValueConsumer);
        this.network.addPropertyValueConsumer(deviceAddress, property, propertyValueConsumer);
    }

    @Override
    protected void doUnlinkAttribute(String assetId, Attribute<?> attribute, VelbusAgentLink agentLink) {
        int deviceAddress = (Integer)AgentLink.getOrThrowAgentLinkProperty(agentLink.getDeviceAddress(), (String)"device address");
        String property = (String)AgentLink.getOrThrowAgentLinkProperty(agentLink.getDeviceValueLink(), (String)"device value");
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        Consumer<Object> propertyValueConsumer = this.attributePropertyValueConsumers.remove(attributeRef);
        this.network.removePropertyValueConsumer(deviceAddress, property, propertyValueConsumer);
    }

    @Override
    protected void doLinkedAttributeWrite(Attribute<?> attribute, VelbusAgentLink agentLink, AttributeEvent event, Object processedValue) {
        int deviceAddress = (Integer)AgentLink.getOrThrowAgentLinkProperty(agentLink.getDeviceAddress(), (String)"device address");
        String property = (String)AgentLink.getOrThrowAgentLinkProperty(agentLink.getDeviceValueLink(), (String)"device value");
        this.network.writeProperty(deviceAddress, property, event.getValue().orElse(null));
    }

    protected abstract IOClient<VelbusPacket> createIoClient(T var1) throws RuntimeException;

    public Future<Void> startAssetImport(byte[] fileData, Consumer<AssetTreeNode[]> assetConsumer) {
        return this.executorService.submit(() -> {
            Document xmlDoc;
            try {
                String xmlStr = new String(fileData, StandardCharsets.UTF_8);
                LOG.info("Parsing VELBUS project file");
                xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(xmlStr)));
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to convert VELBUS project file into XML", e);
                return;
            }
            xmlDoc.getDocumentElement().normalize();
            NodeList modules = xmlDoc.getElementsByTagName("Module");
            LOG.info("Found " + modules.getLength() + " module(s)");
            ArrayList<ThingAsset> devices = new ArrayList<ThingAsset>(modules.getLength());
            for (int i = 0; i < modules.getLength(); ++i) {
                Element module = (Element)modules.item(i);
                Optional deviceType = EnumUtil.enumFromString(VelbusDeviceType.class, (String)module.getAttribute("type").replaceAll("-", ""));
                if (!deviceType.isPresent()) {
                    LOG.info("Module device type '" + module.getAttribute("type") + "' is not supported so ignoring");
                    continue;
                }
                String[] addresses = module.getAttribute("address").split(",");
                int baseAddress = Integer.parseInt(addresses[0], 16);
                String build = module.getAttribute("build");
                String serial = module.getAttribute("serial");
                String name = module.getElementsByTagName("Caption").item(0).getTextContent();
                name = TextUtil.isNullOrEmpty((String)name) ? deviceType.toString() : name;
                ThingAsset device = new ThingAsset(name);
                device.addAttributes(new Attribute[]{new Attribute("build", ValueType.TEXT, (Object)build).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Build"), new MetaItem(MetaItemType.READ_ONLY, (Object)true)}), new Attribute("serialNumber", ValueType.TEXT, (Object)serial).addMeta(new MetaItem[]{new MetaItem(MetaItemType.LABEL, (Object)"Serial No"), new MetaItem(MetaItemType.READ_ONLY, (Object)true)})});
                device.addAttributes(deviceType.flatMap(type -> Optional.ofNullable(type.getFeatureProcessors()).map(processors -> (Attribute[])Arrays.stream(processors).flatMap(processor -> processor.getPropertyDescriptors((VelbusDeviceType)((Object)((Object)type))).stream().map(descriptor -> {
                    VelbusAgentLink agentLink = new VelbusAgentLink(((VelbusAgent)this.agent).getId(), baseAddress, descriptor.getLinkName());
                    Attribute attribute = new Attribute(descriptor.getName(), descriptor.getAttributeValueDescriptor()).addMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, (Object)agentLink), new MetaItem(MetaItemType.LABEL, (Object)descriptor.getDisplayName())});
                    if (descriptor.isReadOnly()) {
                        attribute.addMeta(new MetaItem[]{new MetaItem(MetaItemType.READ_ONLY, (Object)true)});
                    }
                    return attribute;
                })).toArray(Attribute[]::new))).orElse(new Attribute[0]));
                devices.add(device);
            }
            assetConsumer.accept((AssetTreeNode[])devices.stream().map(AssetTreeNode::new).toArray(AssetTreeNode[]::new));
        }, null);
    }
}

