/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.udp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.logging.Logger;
import org.openremote.agent.protocol.io.AbstractNettyIOClient;
import org.openremote.model.syslog.SyslogCategory;

public class UDPIOClient<T>
extends AbstractNettyIOClient<T, InetSocketAddress> {
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, UDPIOClient.class);
    protected String host;
    protected int port;
    protected int bindPort;

    public UDPIOClient(String host, Integer port, Integer bindPort) {
        if (port == null) {
            port = 0;
        } else if (port < 1 || port > 65536) {
            throw new IllegalArgumentException("Port must be between 1 and 65536");
        }
        if (bindPort == null) {
            bindPort = 0;
        } else if (bindPort < 1 || bindPort > 65536) {
            throw new IllegalArgumentException("Bind port must be between 1 and 65536");
        }
        this.host = host;
        this.port = port;
        this.bindPort = bindPort;
    }

    @Override
    protected void addEncodersDecoders(Channel channel) {
        channel.pipeline().addLast(new ChannelHandler[]{new MessageToMessageEncoder<ByteBuf>(){

            protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
                out.add(new DatagramPacket(msg.retain(), UDPIOClient.this.host != null ? new InetSocketAddress(UDPIOClient.this.host, UDPIOClient.this.port) : new InetSocketAddress(UDPIOClient.this.port)));
            }
        }});
        super.addEncodersDecoders(channel);
        channel.pipeline().addFirst(new ChannelHandler[]{new MessageToMessageDecoder<DatagramPacket>(){

            protected void decode(ChannelHandlerContext ctx, DatagramPacket msg, List<Object> out) throws Exception {
                out.add(((ByteBuf)msg.content()).retain());
            }
        }});
    }

    @Override
    protected ChannelFuture startChannel() {
        return this.bootstrap.bind("0.0.0.0", this.bindPort);
    }

    @Override
    protected Class<? extends Channel> getChannelClass() {
        return NioDatagramChannel.class;
    }

    @Override
    public String getClientUri() {
        return "udp://" + (this.host != null ? this.host : "0.0.0.0") + ":" + this.port + " (bindPort: " + this.bindPort + ")";
    }

    @Override
    protected EventLoopGroup getWorkerGroup() {
        return new NioEventLoopGroup(1);
    }

    @Override
    protected void configureChannel() {
        super.configureChannel();
        this.bootstrap.option(ChannelOption.SO_BROADCAST, (Object)true);
    }
}

