/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.udp;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.DatagramPacketEncoder;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.logging.Level;
import org.openremote.agent.protocol.io.AbstractNettyIOServer;

public abstract class AbstractUDPServer<T>
extends AbstractNettyIOServer<T, DatagramChannel, Bootstrap, InetSocketAddress> {
    protected InetSocketAddress localAddress;
    protected InetSocketAddress lastMessageSender;

    public AbstractUDPServer(InetSocketAddress localAddress) {
        this.localAddress = localAddress;
    }

    @Override
    protected String getSocketAddressString() {
        return this.localAddress == null ? null : "udp://" + this.localAddress;
    }

    @Override
    protected String getClientDescriptor(DatagramChannel client) {
        return null;
    }

    @Override
    protected Bootstrap createAndConfigureBootstrap() {
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)new NioEventLoopGroup())).channel(NioDatagramChannel.class)).localAddress((SocketAddress)this.localAddress)).option(ChannelOption.SO_BROADCAST, (Object)true);
        return b;
    }

    @Override
    protected void initChannel(final DatagramChannel channel) {
        super.initChannel(channel);
        channel.pipeline().addLast(new ChannelHandler[]{new MessageToMessageDecoder<DatagramPacket>(){

            protected void decode(ChannelHandlerContext ctx, DatagramPacket msg, List<Object> out) throws Exception {
                AbstractUDPServer.this.lastMessageSender = (InetSocketAddress)msg.sender();
                out.add(((ByteBuf)msg.content()).retain());
            }
        }});
        this.addDecoders(channel);
        channel.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<T>(){

            protected void channelRead0(ChannelHandlerContext ctx, T msg) {
                AbstractUDPServer.this.handleMessageReceived(channel, msg);
            }
        }});
        channel.pipeline().addLast(new ChannelHandler[]{new MessageToMessageEncoder<AddressedEnvelope<ByteBuf, InetSocketAddress>>(){

            protected void encode(ChannelHandlerContext ctx, AddressedEnvelope<ByteBuf, InetSocketAddress> msg, List<Object> out) throws Exception {
                if (msg instanceof DatagramPacket) {
                    out.add(msg.retain());
                } else {
                    out.add(new DatagramPacket((ByteBuf)msg.content(), (InetSocketAddress)msg.recipient(), (InetSocketAddress)msg.sender()));
                }
            }
        }});
        this.addEncoders(channel);
    }

    @Override
    public void sendMessage(T message) {
        this.sendMessage(message, new InetSocketAddress("255.255.255.255", this.localAddress.getPort()));
    }

    @Override
    public void sendMessage(T message, DatagramChannel client) {
        throw new IllegalStateException("Sending to a channel not supported for UDP");
    }

    @Override
    public void sendMessage(T message, InetSocketAddress destination) {
        try {
            this.channelFuture.channel().writeAndFlush((Object)new DefaultAddressedEnvelope(message, (SocketAddress)destination, (SocketAddress)this.localAddress));
            LOG.finest("Message sent to client: " + destination.toString());
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Message send failed", e);
        }
    }

    @Override
    protected void addEncoder(DatagramChannel channel, ChannelOutboundHandler encoder) {
        if (encoder instanceof DatagramPacketEncoder) {
            super.addEncoder(channel, encoder);
            return;
        }
        if (!(encoder instanceof MessageToMessageEncoder)) {
            throw new IllegalArgumentException("Only MessageToMessage encoders can be used with UDP");
        }
        MessageToMessageEncoder mEncoder = (MessageToMessageEncoder)encoder;
        super.addEncoder(channel, (ChannelOutboundHandler)new DatagramPacketEncoder(mEncoder));
    }

    @Override
    protected void handleMessageReceived(DatagramChannel channel, T message) {
        InetSocketAddress sender = this.lastMessageSender;
        this.lastMessageSender = null;
        this.onMessageReceived(message, channel, sender);
    }
}

