/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tradfri.util;

import org.openremote.model.value.impl.ColourRGB;

public class ColourXY {
    private Integer X;
    private Integer Y;

    public ColourXY(Integer X, Integer Y) {
        this.X = X;
        this.Y = Y;
    }

    public ColourXY() {
    }

    public Integer getX() {
        return this.X;
    }

    public Integer getY() {
        return this.Y;
    }

    public void setX(Integer X) {
        this.X = X;
    }

    public void setY(Integer Y) {
        this.Y = Y;
    }

    public static ColourXY fromRGB(ColourRGB colourRGB) {
        double red = Math.max(Math.min(colourRGB.getR(), 255), 0);
        double green = Math.max(Math.min(colourRGB.getG(), 255), 0);
        double blue = Math.max(Math.min(colourRGB.getB(), 255), 0);
        red = red > 0.04045 ? Math.pow((red + 0.055) / 1.055, 2.4) : (red /= 255.0) / 12.92;
        green = green > 0.04045 ? Math.pow((green + 0.055) / 1.055, 2.4) : (green /= 255.0) / 12.92;
        blue = blue > 0.04045 ? Math.pow((blue + 0.055) / 1.055, 2.4) : (blue /= 255.0) / 12.92;
        double X = red * 0.4124564 + green * 0.3575761 + blue * 0.1804375;
        double Y = red * 0.2126729 + green * 0.7151522 + blue * 0.072175;
        double Z = red * 0.0193339 + green * 0.119192 + blue * 0.9503041;
        double total = X + Y + Z;
        double x = 0.0;
        double y = 0.0;
        if (total != 0.0) {
            x = X / total;
            y = Y / total;
        }
        int xNormalised = (int)(x * 65535.0 + 0.5);
        int yNormalised = (int)(y * 65535.0 + 0.5);
        return new ColourXY(xNormalised, yNormalised);
    }
}

