/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tradfri.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.eclipse.californium.core.CoapHandler;
import org.eclipse.californium.core.CoapObserveRelation;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.EndpointManager;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedSinglePskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.openremote.agent.protocol.tradfri.util.Credentials;
import org.openremote.model.util.ValueUtil;

public class CoapClient {
    private final ObjectMapper objectMapper = ValueUtil.JSON;
    private Credentials credentials;
    private Endpoint dtlsEndpoint;
    private long timeout = 20000L;

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
        try {
            this.updateDtlsConnector();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateDtlsConnector() throws IOException {
        if (this.dtlsEndpoint != null) {
            this.dtlsEndpoint.destroy();
        }
        DtlsConnectorConfig.Builder builder = new DtlsConnectorConfig.Builder(new Configuration());
        builder.setAddress(new InetSocketAddress(0));
        AdvancedSinglePskStore pskStore = new AdvancedSinglePskStore(this.credentials.getIdentity(), SecretUtil.create((byte[])this.credentials.getKey().getBytes(), (String)"PSK"));
        builder.setAdvancedPskStore((AdvancedPskStore)pskStore);
        DTLSConnector dtlsconnector = new DTLSConnector(builder.build());
        CoapEndpoint.Builder endpointBuilder = new CoapEndpoint.Builder();
        endpointBuilder.setConnector((Connector)dtlsconnector);
        this.dtlsEndpoint = endpointBuilder.build();
        this.dtlsEndpoint.start();
        EndpointManager.getEndpointManager().setDefaultEndpoint(this.dtlsEndpoint);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private <T> T request(Request request, String endpoint, Class<T> responseType) {
        try {
            request.setURI(endpoint);
            request.send();
            Response response = request.waitForResponse(this.timeout);
            if (response == null) {
                return null;
            }
            String responsePayload = response.getPayloadString();
            if (responseType == String.class) {
                return (T)responsePayload;
            }
            return (T)this.objectMapper.readValue(responsePayload, responseType);
        }
        catch (JsonProcessingException | InterruptedException e) {
            return null;
        }
    }

    private <T> T requestWithPayload(Request request, String endpoint, Object payload, Class<T> responseType) {
        try {
            String requestPayload = this.objectMapper.writeValueAsString(payload);
            request.setPayload(requestPayload);
            request.getOptions().setContentFormat(50);
            return this.request(request, endpoint, responseType);
        }
        catch (IOException e) {
            return null;
        }
    }

    public CoapObserveRelation requestObserve(String endpoint, CoapHandler handler) {
        org.eclipse.californium.core.CoapClient client = new org.eclipse.californium.core.CoapClient();
        client.setTimeout(Long.valueOf(this.timeout));
        Request request = Request.newGet();
        request.setURI(endpoint);
        request.setObserve();
        return client.observe(request, handler);
    }

    public <T> T get(String endpoint, Class<T> responseType) {
        Request request = Request.newGet();
        return this.request(request, endpoint, responseType);
    }

    public <T> T post(String endpoint, Object payload, Class<T> responseType) {
        Request request = Request.newPost();
        return this.requestWithPayload(request, endpoint, payload, responseType);
    }

    public <T> T put(String endpoint, Object payload, Class<T> responseType) {
        Request request = Request.newPut();
        return this.requestWithPayload(request, endpoint, payload, responseType);
    }
}

