/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tradfri.device;

import org.openremote.agent.protocol.tradfri.device.Device;
import org.openremote.agent.protocol.tradfri.device.DeviceInfo;
import org.openremote.agent.protocol.tradfri.device.DeviceProperties;
import org.openremote.agent.protocol.tradfri.device.PlugProperties;
import org.openremote.agent.protocol.tradfri.payload.DeviceRequest;
import org.openremote.agent.protocol.tradfri.util.ApiEndpoint;
import org.openremote.agent.protocol.tradfri.util.CoapClient;

public class Plug
extends Device {
    private PlugProperties properties;
    private PlugProperties newProperties;

    public Plug(String name, Long creationDate, Integer instanceId, DeviceInfo deviceInfo, PlugProperties properties, CoapClient coapClient) {
        super(name, creationDate, instanceId, deviceInfo, coapClient);
        this.properties = properties;
        this.newProperties = new PlugProperties();
    }

    @Override
    public PlugProperties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(DeviceProperties properties) {
        if (properties instanceof PlugProperties) {
            this.properties = (PlugProperties)properties;
        }
    }

    public Boolean getOn() {
        return this.properties.getOn();
    }

    public void updateOn(Boolean on) {
        this.newProperties.setOn(on);
    }

    public boolean setOn(Boolean on) {
        PlugProperties newProperties = new PlugProperties();
        newProperties.setOn(on);
        return this.applyUpdate(newProperties);
    }

    private boolean applyUpdate(PlugProperties newProperties) {
        DeviceRequest request = new DeviceRequest();
        request.setPlugProperties(new PlugProperties[]{newProperties});
        String response = this.coapClient.put(ApiEndpoint.getUri("15001", String.valueOf(this.getInstanceId())), request, String.class);
        return response != null;
    }

    public boolean applyUpdates() {
        boolean success = this.applyUpdate(this.newProperties);
        this.newProperties = new PlugProperties();
        return success;
    }
}

