/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tradfri.device;

import org.eclipse.californium.core.CoapHandler;
import org.eclipse.californium.core.CoapObserveRelation;
import org.eclipse.californium.core.CoapResponse;
import org.openremote.agent.protocol.tradfri.util.CoapClient;

public abstract class Observer
implements CoapHandler {
    private String endpoint;
    private CoapClient coapClient;
    private CoapObserveRelation coapObserveRelation;

    public Observer(String endpoint, CoapClient coapClient) {
        this.endpoint = endpoint;
        this.coapClient = coapClient;
    }

    public boolean start() {
        if (this.coapObserveRelation == null || this.coapObserveRelation.isCanceled()) {
            this.coapObserveRelation = this.coapClient.requestObserve(this.endpoint, this);
            return true;
        }
        return false;
    }

    public boolean stop() {
        if (this.coapObserveRelation != null && !this.coapObserveRelation.isCanceled()) {
            this.coapObserveRelation.proactiveCancel();
            return true;
        }
        return false;
    }

    protected boolean checkChanges(Object oldValue, Object newValue) {
        return oldValue == null && newValue != null || newValue == null && oldValue != null || oldValue != null && !oldValue.equals(newValue);
    }

    public void onLoad(CoapResponse coapResponse) {
        if (!coapResponse.isSuccess()) {
            return;
        }
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
                this.callEventHandlers(coapResponse.getResponseText());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).start();
    }

    public void onError() {
    }

    public abstract void callEventHandlers(String var1);
}

