/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tradfri.device;

import org.openremote.agent.protocol.tradfri.device.Device;
import org.openremote.agent.protocol.tradfri.device.DeviceInfo;
import org.openremote.agent.protocol.tradfri.device.DeviceProperties;
import org.openremote.agent.protocol.tradfri.device.LightProperties;
import org.openremote.agent.protocol.tradfri.payload.DeviceRequest;
import org.openremote.agent.protocol.tradfri.util.ApiEndpoint;
import org.openremote.agent.protocol.tradfri.util.CoapClient;
import org.openremote.agent.protocol.tradfri.util.ColourXY;
import org.openremote.model.value.impl.ColourRGB;

public class Light
extends Device {
    private LightProperties properties;
    private LightProperties newProperties;

    public Light(String name, Long creationDate, Integer instanceId, DeviceInfo deviceInfo, LightProperties properties, CoapClient coapClient) {
        super(name, creationDate, instanceId, deviceInfo, coapClient);
        this.properties = properties;
        this.newProperties = new LightProperties();
    }

    @Override
    public LightProperties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(DeviceProperties properties) {
        if (properties instanceof LightProperties) {
            this.properties = (LightProperties)properties;
        }
    }

    public Boolean getOn() {
        return this.properties.getOn();
    }

    public Integer getBrightness() {
        return this.properties.getBrightness();
    }

    public String getColourHex() {
        return this.properties.getColourHex();
    }

    public Integer getHue() {
        return this.properties.getHue();
    }

    public Integer getSaturation() {
        return this.properties.getSaturation();
    }

    public Integer getColourX() {
        return this.properties.getColourX();
    }

    public Integer getColourY() {
        return this.properties.getColourY();
    }

    public ColourXY getColourXY() {
        return new ColourXY(this.properties.getColourX(), this.properties.getColourY());
    }

    public ColourRGB getColourRGB() {
        return ColourRGB.fromHS((int)(this.properties.getHue() != null ? this.properties.getHue() : 0), (int)(this.properties.getSaturation() != null ? this.properties.getSaturation() : 0));
    }

    public Integer getColourTemperature() {
        return this.properties.getColourTemperature();
    }

    public void updateOn(Boolean on) {
        this.newProperties.setOn(on);
    }

    public void updateBrightness(Integer brightness) {
        this.newProperties.setBrightness(brightness);
    }

    public void updateColourHex(String colourHex) {
        this.newProperties.setColourHex(colourHex);
        this.newProperties.setHue(null);
        this.newProperties.setSaturation(null);
        this.newProperties.setColourX(null);
        this.newProperties.setColourY(null);
        this.newProperties.setColourTemperature(null);
    }

    public void updateHue(Integer hue) {
        this.newProperties.setHue(hue);
        this.newProperties.setColourX(null);
        this.newProperties.setColourY(null);
        this.newProperties.setColourHex(null);
        this.newProperties.setColourTemperature(null);
    }

    public void updateSaturation(Integer saturation) {
        this.newProperties.setSaturation(saturation);
        this.newProperties.setColourX(null);
        this.newProperties.setColourY(null);
        this.newProperties.setColourHex(null);
        this.newProperties.setColourTemperature(null);
    }

    public void updateColourXY(Integer colourX, Integer colourY) {
        this.newProperties.setColourX(colourX);
        this.newProperties.setColourY(colourY);
        this.newProperties.setColourHex(null);
        this.newProperties.setHue(null);
        this.newProperties.setSaturation(null);
        this.newProperties.setColourTemperature(null);
    }

    public void updateColour(ColourXY colourXY) {
        this.newProperties.setColourX(colourXY.getX());
        this.newProperties.setColourY(colourXY.getY());
        this.newProperties.setColourHex(null);
        this.newProperties.setHue(null);
        this.newProperties.setSaturation(null);
        this.newProperties.setColourTemperature(null);
    }

    public void updateColour(ColourRGB colourRGB) {
        this.updateColour(ColourXY.fromRGB(colourRGB));
    }

    public void updateColourRGB(int colourRed, int colourGreen, int colourBlue) {
        this.updateColour(new ColourRGB(colourRed, colourGreen, colourBlue));
    }

    public void updateColourTemperature(Integer colourTemperature) {
        this.newProperties.setColourTemperature(colourTemperature);
        this.newProperties.setColourHex(null);
        this.newProperties.setHue(null);
        this.newProperties.setSaturation(null);
        this.newProperties.setColourX(null);
        this.newProperties.setColourY(null);
    }

    public void updateTransitionTime(Integer transitionTime) {
        this.newProperties.setTransitionTime(transitionTime);
    }

    public boolean setOn(Boolean on, Integer transitionTime) {
        LightProperties newProperties = new LightProperties();
        newProperties.setOn(on);
        newProperties.setTransitionTime(transitionTime);
        return this.applyUpdate(newProperties);
    }

    public boolean setOn(Boolean on) {
        return this.setOn(on, null);
    }

    public boolean setBrightness(Integer brightness, Integer transitionTime) {
        LightProperties newProperties = new LightProperties();
        newProperties.setBrightness(brightness);
        newProperties.setTransitionTime(transitionTime);
        return this.applyUpdate(newProperties);
    }

    public boolean setBrightness(Integer brightness) {
        return this.setBrightness(brightness, null);
    }

    public boolean setColourHex(String colourHex, Integer transitionTime) {
        LightProperties newProperties = new LightProperties();
        newProperties.setColourHex(colourHex);
        newProperties.setTransitionTime(transitionTime);
        return this.applyUpdate(newProperties);
    }

    public boolean setColourHex(String colourHex) {
        return this.setColourHex(colourHex, null);
    }

    public boolean setHue(Integer hue, Integer transitionTime) {
        LightProperties newProperties = new LightProperties();
        newProperties.setHue(hue);
        newProperties.setTransitionTime(transitionTime);
        return this.applyUpdate(newProperties);
    }

    public boolean setHue(Integer hue) {
        return this.setHue(hue, null);
    }

    public boolean setSaturation(Integer saturation, Integer transitionTime) {
        LightProperties newProperties = new LightProperties();
        newProperties.setSaturation(saturation);
        newProperties.setTransitionTime(transitionTime);
        return this.applyUpdate(newProperties);
    }

    public boolean setSaturation(Integer saturation) {
        return this.setSaturation(saturation, null);
    }

    public boolean setColourXY(Integer colourX, Integer colourY, Integer transitionTime) {
        LightProperties newProperties = new LightProperties();
        newProperties.setColourX(colourX);
        newProperties.setColourY(colourY);
        newProperties.setTransitionTime(transitionTime);
        return this.applyUpdate(newProperties);
    }

    public boolean setColourXY(Integer colourX, Integer colourY) {
        return this.setColourXY(colourX, colourY, null);
    }

    public boolean setColour(ColourXY colourXY, Integer transitionTime) {
        return this.setColourXY(colourXY.getX(), colourXY.getY(), transitionTime);
    }

    public boolean setColour(ColourXY colourXY) {
        return this.setColour(colourXY, null);
    }

    public boolean setColour(ColourRGB colourRGB, Integer transitionTime) {
        return this.setColour(ColourXY.fromRGB(colourRGB), transitionTime);
    }

    public boolean setColour(ColourRGB colourRGB) {
        return this.setColour(colourRGB, null);
    }

    public boolean setColourRGB(int colourRed, int colourGreen, int colourBlue, Integer transitionTime) {
        return this.setColour(new ColourRGB(colourRed, colourGreen, colourBlue), transitionTime);
    }

    public boolean setColourRGB(int colourRed, int colourGreen, int colourBlue) {
        return this.setColour(new ColourRGB(colourRed, colourGreen, colourBlue));
    }

    public boolean setColourTemperature(Integer colourTemperature, Integer transitionTime) {
        LightProperties newProperties = new LightProperties();
        newProperties.setColourTemperature(colourTemperature);
        newProperties.setTransitionTime(transitionTime);
        return this.applyUpdate(newProperties);
    }

    public boolean setColourTemperature(Integer colourTemperature) {
        return this.setColourTemperature(colourTemperature, null);
    }

    private boolean applyUpdate(LightProperties newProperties) {
        DeviceRequest request = new DeviceRequest();
        request.setLightProperties(new LightProperties[]{newProperties});
        String response = this.coapClient.put(ApiEndpoint.getUri("15001", String.valueOf(this.getInstanceId())), request, String.class);
        return response != null;
    }

    public boolean applyUpdates() {
        boolean success = this.applyUpdate(this.newProperties);
        this.newProperties = new LightProperties();
        return success;
    }

    public boolean applyUpdates(Integer transitionTime) {
        this.newProperties.setTransitionTime(transitionTime);
        return this.applyUpdates();
    }
}

