/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tradfri.device;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import org.openremote.agent.protocol.tradfri.device.Device;
import org.openremote.agent.protocol.tradfri.device.Gateway;
import org.openremote.agent.protocol.tradfri.device.Observer;
import org.openremote.agent.protocol.tradfri.device.event.EventHandler;
import org.openremote.agent.protocol.tradfri.device.event.GatewayEvent;
import org.openremote.agent.protocol.tradfri.util.ApiEndpoint;
import org.openremote.agent.protocol.tradfri.util.CoapClient;

public class GatewayObserver
extends Observer {
    private Gateway gateway;
    private HashMap<Integer, Device> devices;
    private ObjectMapper objectMapper;

    public GatewayObserver(Gateway gateway, CoapClient coapClient) {
        super(ApiEndpoint.getUri("15001"), coapClient);
        this.gateway = gateway;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public boolean start() {
        Device[] devices = this.gateway.getDevices();
        this.devices = new HashMap();
        for (Device device : devices) {
            this.devices.put(device.getInstanceId(), device);
        }
        return super.start();
    }

    @Override
    public void callEventHandlers(String payload) {
        try {
            int[] deviceIds = (int[])this.objectMapper.readValue(payload, int[].class);
            ArrayList called = new ArrayList();
            GatewayEvent event = new GatewayEvent(this.gateway);
            for (EventHandler<?> eventHandler : this.gateway.getEventHandlers()) {
                if (!eventHandler.getEventType().isAssignableFrom(event.getClass()) || called.contains(eventHandler)) continue;
                eventHandler.handle(event);
                called.add(eventHandler);
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }
}

