/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tradfri.device;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.openremote.agent.protocol.tradfri.device.Device;
import org.openremote.agent.protocol.tradfri.device.GatewayObserver;
import org.openremote.agent.protocol.tradfri.device.Light;
import org.openremote.agent.protocol.tradfri.device.Plug;
import org.openremote.agent.protocol.tradfri.device.event.EventHandler;
import org.openremote.agent.protocol.tradfri.payload.AuthenticateRequest;
import org.openremote.agent.protocol.tradfri.payload.AuthenticateResponse;
import org.openremote.agent.protocol.tradfri.payload.DeviceResponse;
import org.openremote.agent.protocol.tradfri.util.ApiEndpoint;
import org.openremote.agent.protocol.tradfri.util.CoapClient;
import org.openremote.agent.protocol.tradfri.util.Credentials;

public class Gateway {
    private CoapClient coapClient;
    private GatewayObserver observer;
    private final List<EventHandler<?>> eventHandlers;

    public Gateway(String ip) {
        ApiEndpoint.setGatewayIp(ip);
        this.coapClient = new CoapClient();
        this.eventHandlers = new ArrayList();
    }

    public Credentials connect(String securityCode) {
        String identity = RandomStringUtils.randomAlphanumeric((int)16);
        AuthenticateRequest request = new AuthenticateRequest();
        request.setIdentity(identity);
        this.setCredentials("Client_identity", securityCode);
        AuthenticateResponse response = this.coapClient.post(ApiEndpoint.getUri("15011/9063"), request, AuthenticateResponse.class);
        if (response == null) {
            return null;
        }
        Credentials credentials = new Credentials(identity, response.getPresharedKey());
        this.setCredentials(credentials);
        return credentials;
    }

    public Credentials connect(Credentials credentials) {
        this.setCredentials(credentials);
        return credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.coapClient.setCredentials(credentials);
    }

    public void setCredentials(String identity, String key) {
        Credentials credentials = new Credentials(identity, key);
        this.setCredentials(credentials);
    }

    public Credentials getCredentials() {
        return this.coapClient.getCredentials();
    }

    public long getTimeout() {
        return this.coapClient.getTimeout();
    }

    public void setTimeout(long timeout) {
        this.coapClient.setTimeout(timeout);
    }

    public int[] getDeviceIds() {
        return this.coapClient.get(ApiEndpoint.getUri("15001"), int[].class);
    }

    public Device getDevice(int id) {
        DeviceResponse response = this.coapClient.get(ApiEndpoint.getUri("15001", String.valueOf(id)), DeviceResponse.class);
        if (response == null) {
            return null;
        }
        if (response.getLightProperties() != null && response.getLightProperties().length > 0) {
            return new Light(response.getName(), response.getCreationDate(), response.getInstanceId(), response.getDeviceInfo(), response.getLightProperties()[0], this.coapClient);
        }
        if (response.getPlugProperties() != null && response.getPlugProperties().length > 0) {
            return new Plug(response.getName(), response.getCreationDate(), response.getInstanceId(), response.getDeviceInfo(), response.getPlugProperties()[0], this.coapClient);
        }
        return new Device(response.getName(), response.getCreationDate(), response.getInstanceId(), response.getDeviceInfo(), this.coapClient);
    }

    public Device[] getDevices() {
        ArrayList<Device> deviceList = new ArrayList<Device>();
        int[] deviceIds = this.getDeviceIds();
        if (deviceIds == null) {
            return null;
        }
        for (int deviceId : deviceIds) {
            Device device = this.getDevice(deviceId);
            deviceList.add(device);
        }
        Device[] devices = new Device[deviceList.size()];
        deviceList.toArray(devices);
        return devices;
    }

    public boolean enableObserve() {
        if (this.observer == null) {
            this.observer = new GatewayObserver(this, this.coapClient);
        }
        return this.observer.start();
    }

    public boolean disableObserve() {
        if (this.observer == null) {
            return false;
        }
        return this.observer.stop();
    }

    public List<EventHandler<?>> getEventHandlers() {
        return this.eventHandlers;
    }

    public void addEventHandler(EventHandler<?> eventHandler) {
        this.eventHandlers.add(eventHandler);
    }

    public void removeEventHandler(EventHandler<?> eventHandler) {
        this.eventHandlers.remove(eventHandler);
    }
}

