/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tradfri.device;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import org.openremote.agent.protocol.tradfri.device.Device;
import org.openremote.agent.protocol.tradfri.device.LightProperties;
import org.openremote.agent.protocol.tradfri.device.Observer;
import org.openremote.agent.protocol.tradfri.device.PlugProperties;
import org.openremote.agent.protocol.tradfri.device.event.DeviceEvent;
import org.openremote.agent.protocol.tradfri.device.event.EventHandler;
import org.openremote.agent.protocol.tradfri.device.event.LightChangeBrightnessEvent;
import org.openremote.agent.protocol.tradfri.device.event.LightChangeColourEvent;
import org.openremote.agent.protocol.tradfri.device.event.LightChangeColourTemperatureEvent;
import org.openremote.agent.protocol.tradfri.device.event.LightChangeEvent;
import org.openremote.agent.protocol.tradfri.device.event.LightChangeOnEvent;
import org.openremote.agent.protocol.tradfri.device.event.LightEvent;
import org.openremote.agent.protocol.tradfri.device.event.PlugChangeEvent;
import org.openremote.agent.protocol.tradfri.device.event.PlugChangeOnEvent;
import org.openremote.agent.protocol.tradfri.device.event.PlugEvent;
import org.openremote.agent.protocol.tradfri.payload.DeviceResponse;
import org.openremote.agent.protocol.tradfri.util.CoapClient;
import org.openremote.model.util.ValueUtil;

public class DeviceObserver
extends Observer {
    private final Device device;
    private final ObjectMapper objectMapper = ValueUtil.JSON;

    public DeviceObserver(Device device, CoapClient coapClient) {
        super(device.getEndpoint(), coapClient);
        this.device = device;
    }

    @Override
    public void callEventHandlers(String payload) {
        try {
            DeviceResponse response = (DeviceResponse)this.objectMapper.readValue(payload, DeviceResponse.class);
            ArrayList<DeviceEvent> events = new ArrayList<DeviceEvent>();
            ArrayList called = new ArrayList();
            if (this.device.isLight()) {
                oldProperties = (LightProperties)this.device.getProperties();
                if (response.getLightProperties() != null && response.getLightProperties().length > 0) {
                    this.device.setProperties(response.getLightProperties()[0]);
                }
                newProperties = (LightProperties)this.device.getProperties();
                events.add(new LightEvent(this.device.toLight()));
                ArrayList<LightChangeEvent> changeEvents = new ArrayList<LightChangeEvent>();
                if (this.checkChanges(((LightProperties)oldProperties).getOn(), ((LightProperties)newProperties).getOn())) {
                    changeEvents.add(new LightChangeOnEvent(this.device.toLight(), (LightProperties)oldProperties, (LightProperties)newProperties));
                }
                if (this.checkChanges(((LightProperties)oldProperties).getBrightness(), ((LightProperties)newProperties).getBrightness())) {
                    changeEvents.add(new LightChangeBrightnessEvent(this.device.toLight(), (LightProperties)oldProperties, (LightProperties)newProperties));
                }
                if (this.checkChanges(((LightProperties)oldProperties).getColourX(), ((LightProperties)newProperties).getColourX()) || this.checkChanges(((LightProperties)oldProperties).getColourY(), ((LightProperties)newProperties).getColourY()) || this.checkChanges(((LightProperties)oldProperties).getHue(), ((LightProperties)newProperties).getHue()) || this.checkChanges(((LightProperties)oldProperties).getSaturation(), ((LightProperties)newProperties).getSaturation())) {
                    changeEvents.add(new LightChangeColourEvent(this.device.toLight(), (LightProperties)oldProperties, (LightProperties)newProperties));
                }
                if (this.checkChanges(((LightProperties)oldProperties).getColourTemperature(), ((LightProperties)newProperties).getColourTemperature())) {
                    changeEvents.add(new LightChangeColourTemperatureEvent(this.device.toLight(), (LightProperties)oldProperties, (LightProperties)newProperties));
                }
                if (changeEvents.size() > 0) {
                    events.add(new LightChangeEvent(this.device.toLight(), (LightProperties)oldProperties, (LightProperties)newProperties));
                    events.addAll(changeEvents);
                }
            } else if (this.device.isPlug()) {
                oldProperties = (PlugProperties)this.device.getProperties();
                if (response.getPlugProperties() != null && response.getPlugProperties().length > 0) {
                    this.device.setProperties(response.getPlugProperties()[0]);
                }
                newProperties = (PlugProperties)this.device.getProperties();
                events.add(new PlugEvent(this.device.toPlug()));
                if (this.checkChanges(((PlugProperties)oldProperties).getOn(), ((PlugProperties)newProperties).getOn())) {
                    events.add(new PlugChangeEvent(this.device.toPlug(), (PlugProperties)oldProperties, (PlugProperties)newProperties));
                    events.add(new PlugChangeOnEvent(this.device.toPlug(), (PlugProperties)oldProperties, (PlugProperties)newProperties));
                }
            }
            for (EventHandler<?> eventHandler : this.device.getEventHandlers()) {
                for (DeviceEvent event : events) {
                    if (!eventHandler.getEventType().isAssignableFrom(event.getClass()) || called.contains(eventHandler)) continue;
                    eventHandler.handle(event);
                    called.add(eventHandler);
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }
}

