/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tradfri.device;

import java.util.ArrayList;
import java.util.List;
import org.openremote.agent.protocol.tradfri.device.DeviceInfo;
import org.openremote.agent.protocol.tradfri.device.DeviceObserver;
import org.openremote.agent.protocol.tradfri.device.DeviceProperties;
import org.openremote.agent.protocol.tradfri.device.Light;
import org.openremote.agent.protocol.tradfri.device.Plug;
import org.openremote.agent.protocol.tradfri.device.event.EventHandler;
import org.openremote.agent.protocol.tradfri.util.ApiEndpoint;
import org.openremote.agent.protocol.tradfri.util.CoapClient;

public class Device {
    private String name;
    private Long creationDate;
    private Integer instanceId;
    private DeviceInfo deviceInfo;
    private DeviceProperties properties;
    protected CoapClient coapClient;
    private DeviceObserver observer;
    private final List<EventHandler<?>> eventHandlers;

    public Device(String name, Long creationDate, Integer instanceId, DeviceInfo deviceInfo, CoapClient coapClient) {
        this.name = name;
        this.creationDate = creationDate;
        this.instanceId = instanceId;
        this.deviceInfo = deviceInfo;
        this.coapClient = coapClient;
        this.eventHandlers = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public Long getCreationDate() {
        return this.creationDate;
    }

    public Integer getInstanceId() {
        return this.instanceId;
    }

    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public void setInstanceId(Integer instanceId) {
        this.instanceId = instanceId;
    }

    public DeviceProperties getProperties() {
        return this.properties;
    }

    public void setProperties(DeviceProperties properties) {
        this.properties = properties;
    }

    public String getEndpoint() {
        return ApiEndpoint.getUri("15001", String.valueOf(this.getInstanceId()));
    }

    public boolean enableObserve() {
        if (this.observer == null) {
            this.observer = new DeviceObserver(this, this.coapClient);
        }
        return this.observer.start();
    }

    public boolean disableObserve() {
        if (this.observer == null) {
            return false;
        }
        return this.observer.stop();
    }

    public List<EventHandler<?>> getEventHandlers() {
        return this.eventHandlers;
    }

    public void addEventHandler(EventHandler<?> eventHandler) {
        this.eventHandlers.add(eventHandler);
    }

    public void removeEventHandler(EventHandler<?> eventHandler) {
        this.eventHandlers.remove(eventHandler);
    }

    public boolean isLight() {
        return this instanceof Light;
    }

    public Light toLight() {
        if (this.isLight()) {
            return (Light)this;
        }
        return null;
    }

    public boolean isPlug() {
        return this instanceof Plug;
    }

    public Plug toPlug() {
        if (this.isPlug()) {
            return (Plug)this;
        }
        return null;
    }
}

