/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tradfri;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openremote.agent.protocol.AbstractProtocol;
import org.openremote.agent.protocol.tradfri.TradfriAgent;
import org.openremote.agent.protocol.tradfri.TradfriAsset;
import org.openremote.agent.protocol.tradfri.TradfriConnection;
import org.openremote.agent.protocol.tradfri.TradfriLightAsset;
import org.openremote.agent.protocol.tradfri.TradfriPlugAsset;
import org.openremote.agent.protocol.tradfri.device.Device;
import org.openremote.agent.protocol.tradfri.device.Gateway;
import org.openremote.agent.protocol.tradfri.device.event.EventHandler;
import org.openremote.agent.protocol.tradfri.device.event.GatewayEvent;
import org.openremote.container.util.UniqueIdentifierGenerator;
import org.openremote.model.Container;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.asset.agent.DefaultAgentLink;
import org.openremote.model.asset.impl.LightAsset;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.MetaItem;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.TextUtil;
import org.openremote.model.value.MetaItemType;

public class TradfriProtocol
extends AbstractProtocol<TradfriAgent, DefaultAgentLink> {
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, TradfriProtocol.class);
    public static final String PROTOCOL_DISPLAY_NAME = "IKEA TR\u00c5DFRI";
    protected TradfriConnection tradfriConnection;
    protected HashMap<String, Device> tradfriDevices = new HashMap();

    public TradfriProtocol(TradfriAgent agent) {
        super(agent);
    }

    public String getProtocolName() {
        return PROTOCOL_DISPLAY_NAME;
    }

    public String getProtocolInstanceUri() {
        return "tradfri://" + ((TradfriAgent)this.agent).getHost();
    }

    @Override
    protected void doStart(Container container) throws Exception {
        String host = (String)((TradfriAgent)this.agent).getHost().orElseThrow(() -> {
            String msg = "Host is not defined so cannot start protocol: " + this;
            LOG.warning(msg);
            return new IllegalArgumentException(msg);
        });
        String securityCode = ((TradfriAgent)this.agent).getSecurityCode().orElse("");
        this.tradfriConnection = new TradfriConnection(host, securityCode, this.executorService);
        this.tradfriConnection.addConnectionStatusConsumer(x$0 -> this.setConnectionStatus((ConnectionStatus)x$0));
        LOG.fine("Connecting the gateway: " + this);
        Gateway gateway = this.tradfriConnection.connect();
        if (gateway != null) {
            EventHandler<GatewayEvent> gatewayEventHandler = new EventHandler<GatewayEvent>(){

                @Override
                public void handle(GatewayEvent event) {
                    Device[] newDevices = event.getGateway().getDevices();
                    if (newDevices == null) {
                        return;
                    }
                    TradfriProtocol.this.synchroniseAssets(newDevices);
                }
            };
            gateway.addEventHandler(gatewayEventHandler);
            Device[] devices = gateway.getDevices();
            if (devices != null) {
                this.synchroniseAssets(devices);
            }
        } else {
            this.setConnectionStatus(ConnectionStatus.ERROR);
        }
    }

    @Override
    protected void doStop(Container container) throws Exception {
        if (this.tradfriConnection == null) {
            return;
        }
        this.tradfriConnection.removeConnectionStatusConsumer(x$0 -> this.setConnectionStatus((ConnectionStatus)x$0));
        for (Device device : this.tradfriDevices.values()) {
            device.getEventHandlers().clear();
            device.disableObserve();
        }
        this.tradfriDevices.clear();
        this.tradfriConnection.disconnect();
    }

    @Override
    protected void doLinkAttribute(String assetId, Attribute<?> attribute, DefaultAgentLink agentLink) {
    }

    @Override
    protected void doUnlinkAttribute(String assetId, Attribute<?> attribute, DefaultAgentLink agentLink) {
    }

    @Override
    protected void doLinkedAttributeWrite(Attribute<?> attribute, DefaultAgentLink agentLink, AttributeEvent event, Object processedValue) {
        Device device = this.tradfriDevices.get(event.getAttributeRef().getId());
        if (device != null) {
            this.tradfriConnection.controlDevice(device, event);
        }
    }

    protected void synchroniseAssets(Device[] devices) {
        boolean isFirstRun;
        LOG.fine("Synchronising assets with gateway devices: " + this);
        boolean bl = isFirstRun = this.tradfriDevices == null;
        if (isFirstRun) {
            this.tradfriDevices = new HashMap(devices.length);
            List<Asset<?>> childAssets = this.assetService.findAssets(((TradfriAgent)this.agent).getId(), new AssetQuery().attributeName(TradfriAsset.DEVICE_ID.getName()));
            List<String> obsoleteAssetIds = childAssets.stream().map(asset -> {
                Integer deviceId = (Integer)asset.getAttributes().getValueOrDefault(TradfriAsset.DEVICE_ID);
                boolean isObsolete = deviceId != null && Arrays.stream(devices).noneMatch(device -> deviceId.equals(device.getInstanceId()));
                return isObsolete ? asset.getId() : null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (!obsoleteAssetIds.isEmpty()) {
                LOG.finer("Removing " + obsoleteAssetIds.size() + " obsolete asset(s): " + this);
                this.assetService.deleteAssets(obsoleteAssetIds.toArray(new String[0]));
            }
            Arrays.stream(devices).forEach(device -> {
                String assetId = this.getDeviceAssetId((Device)device);
                Optional<Asset> existingAsset = childAssets.stream().filter(asset -> asset.getId().equals(assetId)).findFirst();
                existingAsset.ifPresent(asset -> this.addDevice((TradfriAsset)asset, (Device)device));
            });
        } else {
            ArrayList obsoleteAssetIds = new ArrayList();
            this.tradfriDevices.forEach((key, value) -> {
                boolean isObsolete = Arrays.stream(devices).noneMatch(device -> Objects.equals(device.getInstanceId(), value.getInstanceId()));
                if (isObsolete) {
                    LOG.info("Removing obsolete device asset: " + key);
                    obsoleteAssetIds.add(key);
                }
            });
            if (!obsoleteAssetIds.isEmpty()) {
                LOG.finer("Removing " + obsoleteAssetIds.size() + " obsolete asset(s): " + this);
                obsoleteAssetIds.forEach(this::removeDevice);
                this.assetService.deleteAssets(obsoleteAssetIds.toArray(new String[0]));
            }
        }
        Arrays.stream(devices).filter(device -> !this.tradfriDevices.containsKey(this.getDeviceAssetId((Device)device))).forEach(device -> {
            LOG.info("Creating device asset for device ID=" + device.getInstanceId());
            Asset<?> asset = this.createDeviceAsset((Device)device);
            this.addDevice((TradfriAsset)asset, (Device)device);
            if (asset == null) {
                LOG.warning("Failed to create asset for device ID=" + device.getInstanceId());
                return;
            }
            this.assetService.mergeAsset(asset);
        });
    }

    protected void addDevice(TradfriAsset asset, Device device) {
        this.tradfriDevices.put(asset != null ? asset.getId() : this.getDeviceAssetId(device), device);
        if (asset != null) {
            asset.initialiseAttributes(device);
            this.assetService.mergeAsset((Asset)asset);
        }
    }

    protected void removeDevice(String assetId) {
        Device device = this.tradfriDevices.remove(assetId);
        device.disableObserve();
        device.getEventHandlers().clear();
    }

    private Asset<?> createDeviceAsset(Device device) {
        TradfriAsset asset = null;
        String name = (!TextUtil.isNullOrEmpty((String)device.getName()) ? device.getName() : "Unnamed") + " " + device.getInstanceId();
        if (device.isPlug()) {
            TradfriPlugAsset plugAsset = new TradfriPlugAsset(name);
            plugAsset.setDeviceId(device.getInstanceId());
            asset = plugAsset;
        } else if (device.isLight()) {
            TradfriLightAsset lightAsset = new TradfriLightAsset(name);
            lightAsset.setDeviceId(device.getInstanceId());
            lightAsset.getAttributes().get(LightAsset.BRIGHTNESS).ifPresent(attribute -> attribute.addOrReplaceMeta(new MetaItem[]{new MetaItem(MetaItemType.AGENT_LINK, (Object)new DefaultAgentLink(((TradfriAgent)this.agent).getId()))}));
            asset = lightAsset;
        }
        if (asset != null) {
            asset.setId(this.getDeviceAssetId(device));
            asset.setParentId(((TradfriAgent)this.agent).getId());
        }
        return asset;
    }

    protected String getDeviceAssetId(Device device) {
        return UniqueIdentifierGenerator.generateId((String)("tradfri_" + ((TradfriAgent)this.agent).getId() + device.getInstanceId()));
    }
}

