/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tradfri;

import java.util.function.Consumer;
import javax.persistence.Entity;
import org.openremote.agent.protocol.tradfri.TradfriAsset;
import org.openremote.agent.protocol.tradfri.device.Device;
import org.openremote.agent.protocol.tradfri.device.Plug;
import org.openremote.agent.protocol.tradfri.device.event.EventHandler;
import org.openremote.agent.protocol.tradfri.device.event.PlugChangeOnEvent;
import org.openremote.model.asset.AssetDescriptor;
import org.openremote.model.asset.impl.PlugAsset;
import org.openremote.model.attribute.AttributeEvent;

@Entity
public class TradfriPlugAsset
extends PlugAsset
implements TradfriAsset {
    public static final AssetDescriptor<TradfriPlugAsset> DESCRIPTOR = new AssetDescriptor("plug", "e6688a", TradfriPlugAsset.class);

    protected TradfriPlugAsset() {
    }

    public TradfriPlugAsset(String name) {
        super(name);
    }

    @Override
    public void addEventHandlers(Device device, final Consumer<AttributeEvent> attributeEventConsumer) {
        final Plug plug = device.toPlug();
        if (plug == null) {
            return;
        }
        EventHandler<PlugChangeOnEvent> plugOnOffEventHandler = new EventHandler<PlugChangeOnEvent>(){

            @Override
            public void handle(PlugChangeOnEvent event) {
                attributeEventConsumer.accept(new AttributeEvent(TradfriPlugAsset.this.getId(), PlugAsset.ON_OFF.getName(), (Object)plug.getOn()));
            }
        };
        device.addEventHandler(plugOnOffEventHandler);
    }

    @Override
    public void initialiseAttributes(Device device) {
        Plug plug = device.toPlug();
        if (plug == null) {
            return;
        }
        this.getAttributes().get(ON_OFF).ifPresent(attribute -> attribute.setValue((Object)plug.getOn()));
    }
}

