/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tradfri;

import java.util.function.Consumer;
import javax.persistence.Entity;
import org.openremote.agent.protocol.tradfri.TradfriAsset;
import org.openremote.agent.protocol.tradfri.device.Device;
import org.openremote.agent.protocol.tradfri.device.Light;
import org.openremote.agent.protocol.tradfri.device.event.EventHandler;
import org.openremote.agent.protocol.tradfri.device.event.LightChangeBrightnessEvent;
import org.openremote.agent.protocol.tradfri.device.event.LightChangeColourEvent;
import org.openremote.agent.protocol.tradfri.device.event.LightChangeColourTemperatureEvent;
import org.openremote.agent.protocol.tradfri.device.event.LightChangeOnEvent;
import org.openremote.model.asset.AssetDescriptor;
import org.openremote.model.asset.impl.LightAsset;
import org.openremote.model.attribute.AttributeEvent;

@Entity
public class TradfriLightAsset
extends LightAsset
implements TradfriAsset {
    public static final AssetDescriptor<TradfriLightAsset> DESCRIPTOR = new AssetDescriptor("lightbulb", "e6688a", TradfriLightAsset.class);

    protected TradfriLightAsset() {
    }

    public TradfriLightAsset(String name) {
        super(name);
    }

    @Override
    public void addEventHandlers(Device device, final Consumer<AttributeEvent> attributeEventConsumer) {
        final Light light = device.toLight();
        if (light == null) {
            return;
        }
        EventHandler<LightChangeOnEvent> lightOnOffEventHandler = new EventHandler<LightChangeOnEvent>(){

            @Override
            public void handle(LightChangeOnEvent event) {
                attributeEventConsumer.accept(new AttributeEvent(TradfriLightAsset.this.getId(), LightAsset.ON_OFF.getName(), (Object)light.getOn()));
            }
        };
        EventHandler<LightChangeBrightnessEvent> lightBrightnessEventHandler = new EventHandler<LightChangeBrightnessEvent>(){

            @Override
            public void handle(LightChangeBrightnessEvent event) {
                attributeEventConsumer.accept(new AttributeEvent(TradfriLightAsset.this.getId(), LightAsset.BRIGHTNESS.getName(), (Object)TradfriLightAsset.convertBrightness(light.getBrightness(), true)));
            }
        };
        EventHandler<LightChangeColourEvent> lightColourChangeEventHandler = new EventHandler<LightChangeColourEvent>(){

            @Override
            public void handle(LightChangeColourEvent event) {
                attributeEventConsumer.accept(new AttributeEvent(TradfriLightAsset.this.getId(), LightAsset.COLOUR_RGB.getName(), (Object)light.getColourRGB()));
            }
        };
        EventHandler<LightChangeColourTemperatureEvent> lightColorTemperatureEventHandler = new EventHandler<LightChangeColourTemperatureEvent>(){

            @Override
            public void handle(LightChangeColourTemperatureEvent event) {
                attributeEventConsumer.accept(new AttributeEvent(TradfriLightAsset.this.getId(), LightAsset.COLOUR_TEMPERATURE.getName(), (Object)light.getColourTemperature()));
            }
        };
        light.addEventHandler(lightOnOffEventHandler);
        light.addEventHandler(lightBrightnessEventHandler);
        light.addEventHandler(lightColourChangeEventHandler);
        light.addEventHandler(lightColorTemperatureEventHandler);
    }

    @Override
    public void initialiseAttributes(Device device) {
        Light light = device.toLight();
        if (light == null) {
            return;
        }
        this.getAttributes().get(ON_OFF).ifPresent(attribute -> attribute.setValue((Object)light.getOn()));
        this.getAttributes().get(BRIGHTNESS).ifPresent(attribute -> attribute.setValue((Object)TradfriLightAsset.convertBrightness(light.getBrightness(), true)));
        this.getAttributes().get(COLOUR_RGB).ifPresent(attribute -> attribute.setValue((Object)light.getColourRGB()));
        this.getAttributes().get(COLOUR_TEMPERATURE).ifPresent(attribute -> attribute.setValue((Object)light.getColourTemperature()));
    }

    public static Integer convertBrightness(Integer value, boolean toPercentage) {
        if (value == null) {
            return null;
        }
        if (toPercentage) {
            return (int)Math.round(Double.valueOf(value.intValue()) / 254.0 * 100.0);
        }
        return (int)Math.round(Double.valueOf(value.intValue()) / 100.0 * 254.0);
    }
}

