/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tradfri;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.openremote.agent.protocol.tradfri.TradfriLightAsset;
import org.openremote.agent.protocol.tradfri.device.Device;
import org.openremote.agent.protocol.tradfri.device.Gateway;
import org.openremote.agent.protocol.tradfri.device.Light;
import org.openremote.agent.protocol.tradfri.device.Plug;
import org.openremote.agent.protocol.tradfri.util.Credentials;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.asset.impl.LightAsset;
import org.openremote.model.asset.impl.PlugAsset;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.impl.ColourRGB;

public class TradfriConnection {
    protected ConnectionStatus connectionStatus = ConnectionStatus.DISCONNECTED;
    protected final List<Consumer<ConnectionStatus>> connectionStatusConsumers = new ArrayList<Consumer<ConnectionStatus>>();
    protected final ScheduledExecutorService executorService;
    protected final String gatewayIp;
    protected final String securityCode;
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, TradfriConnection.class);
    private Gateway gateway;

    public TradfriConnection(String gatewayIp, String securityCode, ScheduledExecutorService executorService) {
        this.gatewayIp = gatewayIp;
        this.securityCode = securityCode;
        this.executorService = executorService;
    }

    public synchronized Gateway connect() {
        if (this.connectionStatus == ConnectionStatus.CONNECTED || this.connectionStatus == ConnectionStatus.CONNECTING) {
            LOG.finest("Already connected or connection in progress");
        }
        this.onConnectionStatusChanged(ConnectionStatus.CONNECTING);
        try {
            Gateway gateway = new Gateway(this.gatewayIp);
            gateway.setTimeout(10000L);
            Credentials credentials = gateway.connect(this.securityCode);
            if (credentials != null && gateway.enableObserve()) {
                this.gateway = gateway;
                this.onConnectionStatusChanged(ConnectionStatus.CONNECTED);
                return gateway;
            }
        }
        catch (Exception exception) {
            LOG.warning("An exception occurred when connecting to Tradfri gateway: " + exception);
        }
        return null;
    }

    protected synchronized void onConnectionStatusChanged(ConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus;
        this.connectionStatusConsumers.forEach(consumer -> consumer.accept(connectionStatus));
    }

    public synchronized void addConnectionStatusConsumer(Consumer<ConnectionStatus> connectionStatusConsumer) {
        if (!this.connectionStatusConsumers.contains(connectionStatusConsumer)) {
            this.connectionStatusConsumers.add(connectionStatusConsumer);
        }
    }

    public synchronized void disconnect() {
        if (this.connectionStatus != ConnectionStatus.CONNECTED) {
            return;
        }
        LOG.finest("Disconnecting");
        this.onConnectionStatusChanged(ConnectionStatus.DISCONNECTING);
        if (this.gateway.disableObserve()) {
            this.onConnectionStatusChanged(ConnectionStatus.DISCONNECTED);
        }
    }

    public synchronized void removeConnectionStatusConsumer(Consumer<ConnectionStatus> connectionStatusConsumer) {
        this.connectionStatusConsumers.remove(connectionStatusConsumer);
    }

    public void controlDevice(Device device, AttributeEvent event) {
        try {
            if (this.connectionStatus == ConnectionStatus.CONNECTED && event.getValue().isPresent()) {
                if (device.isLight()) {
                    Light light = device.toLight();
                    if (event.getAttributeName().equals(LightAsset.BRIGHTNESS.getName())) {
                        int value = ValueUtil.getInteger((Object)event.getValue()).orElse(0);
                        light.setBrightness(TradfriLightAsset.convertBrightness(value, false));
                    } else if (event.getAttributeName().equals(LightAsset.ON_OFF.getName())) {
                        light.setOn(ValueUtil.getBooleanCoerced((Object)event.getValue()).orElse(false));
                    } else if (event.getAttributeName().equals(LightAsset.COLOUR_RGB.getName())) {
                        light.setColour((ColourRGB)ValueUtil.convert((Object)event.getValue(), ColourRGB.class));
                    } else if (event.getAttributeName().equals(LightAsset.COLOUR_TEMPERATURE.getName())) {
                        light.setColourTemperature(ValueUtil.getInteger((Object)event.getValue()).orElse(0));
                    }
                } else if (device.isPlug()) {
                    Plug plug = device.toPlug();
                    if (event.getAttributeName().equals(PlugAsset.ON_OFF.getName())) {
                        plug.setOn(ValueUtil.getBooleanCoerced((Object)event.getValue()).orElse(false));
                    }
                }
            }
        }
        catch (Exception exception) {
            LOG.severe(exception.getMessage());
        }
    }
}

