/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tcp;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.net.InetSocketAddress;
import org.openremote.agent.protocol.tcp.AbstractTCPServer;

public class TCPStringServer
extends AbstractTCPServer<String> {
    protected String delimiter;
    protected int maxFrameLength;
    protected boolean stripDelimiter;

    public TCPStringServer(InetSocketAddress localAddress, String delimiter, int maxFrameLength, boolean stripDelimiter) {
        super(localAddress);
        this.delimiter = delimiter;
        this.maxFrameLength = maxFrameLength;
        this.stripDelimiter = stripDelimiter;
    }

    @Override
    protected void addDecoders(SocketChannel channel) {
        this.addDecoder(channel, (ChannelInboundHandler)new DelimiterBasedFrameDecoder(this.maxFrameLength, this.stripDelimiter, Unpooled.wrappedBuffer((byte[])this.delimiter.getBytes())));
        this.addDecoder(channel, (ChannelInboundHandler)new StringDecoder());
    }

    @Override
    protected void addEncoders(SocketChannel channel) {
        this.addEncoder(channel, (ChannelOutboundHandler)new StringEncoder());
    }
}

