/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tcp;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.openremote.agent.protocol.io.AbstractNettyIOClient;
import org.openremote.model.util.TextUtil;

public class TCPIOClient<T>
extends AbstractNettyIOClient<T, InetSocketAddress> {
    protected String host;
    protected int port;

    public TCPIOClient(String host, int port) {
        TextUtil.requireNonNullAndNonEmpty((String)host);
        this.host = host;
        this.port = port;
    }

    @Override
    protected Class<? extends Channel> getChannelClass() {
        return NioSocketChannel.class;
    }

    @Override
    public String getClientUri() {
        return "tcp://" + this.host + ":" + this.port;
    }

    @Override
    protected EventLoopGroup getWorkerGroup() {
        return new NioEventLoopGroup(1);
    }

    @Override
    protected ChannelFuture startChannel() {
        return this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.host, this.port));
    }

    @Override
    protected void configureChannel() {
        super.configureChannel();
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
    }
}

