/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tcp;

import java.util.function.Consumer;
import java.util.logging.Logger;
import org.openremote.agent.protocol.AbstractProtocol;
import org.openremote.agent.protocol.io.AbstractNettyIOServer;
import org.openremote.agent.protocol.tcp.AbstractTCPServer;
import org.openremote.agent.protocol.tcp.AbstractTCPServerAgent;
import org.openremote.model.Container;
import org.openremote.model.asset.agent.AgentLink;
import org.openremote.model.asset.agent.ConnectionStatus;

public abstract class AbstractTCPServerProtocol<R, S extends AbstractTCPServer<R>, T extends AbstractTCPServerProtocol<R, S, T, U, V>, U extends AbstractTCPServerAgent<U, T, V>, V extends AgentLink<?>>
extends AbstractProtocol<U, V> {
    private static final Logger LOG = Logger.getLogger(AbstractTCPServerProtocol.class.getName());
    protected S tcpServer;

    public AbstractTCPServerProtocol(U agent) {
        super(agent);
    }

    @Override
    protected void doStart(Container container) throws Exception {
        int port = (Integer)((AbstractTCPServerAgent)((Object)this.getAgent())).getBindPort().orElseThrow(() -> new IllegalArgumentException("Missing or invalid attribute: " + AbstractTCPServerAgent.BIND_PORT));
        String bindAddress = ((AbstractTCPServerAgent)((Object)this.getAgent())).getBindHost().orElse(null);
        LOG.info("Creating TCP server instance");
        this.tcpServer = this.createTcpServer(port, bindAddress, (AbstractTCPServerAgent)this.agent);
        Consumer<ConnectionStatus> connectionStatusConsumer = this::onServerConnectionStatusChanged;
        ((AbstractNettyIOServer)this.tcpServer).addConnectionStatusConsumer(connectionStatusConsumer);
        this.startTcpServer();
    }

    protected void onServerConnectionStatusChanged(ConnectionStatus connectionStatus) {
        this.setConnectionStatus(connectionStatus);
    }

    @Override
    protected void doStop(Container container) throws Exception {
        if (this.tcpServer == null) {
            return;
        }
        LOG.info("Removing TCP server instance");
        ((AbstractNettyIOServer)this.tcpServer).removeAllConnectionStatusConsumers();
        this.stopTcpServer();
    }

    protected abstract S createTcpServer(int var1, String var2, U var3);

    protected void startTcpServer() {
        LOG.info("Starting TCP server instance");
        ((AbstractNettyIOServer)this.tcpServer).start();
    }

    protected void stopTcpServer() {
        LOG.info("Stopping TCP server instance");
        ((AbstractNettyIOServer)this.tcpServer).stop();
    }
}

