/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.openremote.agent.protocol.io.AbstractNettyIOServer;

public abstract class AbstractTCPServer<T>
extends AbstractNettyIOServer<T, SocketChannel, ServerBootstrap, InetSocketAddress> {
    protected SocketAddress localAddress;

    public AbstractTCPServer(InetSocketAddress localAddress) {
        this.localAddress = localAddress;
    }

    @Override
    protected String getSocketAddressString() {
        return this.localAddress == null ? null : "tcp://" + this.localAddress;
    }

    @Override
    protected ServerBootstrap createAndConfigureBootstrap() {
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.channel(NioServerSocketChannel.class);
        bootstrap.group(this.workerGroup);
        bootstrap.localAddress(this.localAddress);
        bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.clientLimit);
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) {
                AbstractTCPServer.this.initClientChannel((Channel)channel);
            }
        });
        return bootstrap;
    }

    @Override
    protected String getClientDescriptor(SocketChannel client) {
        return client == null || client.remoteAddress() == null ? null : "tcp://" + client.remoteAddress();
    }
}

