/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.snmp;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.snmp.SnmpMessage;
import org.openremote.agent.protocol.AbstractProtocol;
import org.openremote.agent.protocol.snmp.SNMPAgent;
import org.openremote.agent.protocol.snmp.SNMPAgentLink;
import org.openremote.model.Container;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.attribute.AttributeState;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.ValueUtil;
import org.snmp4j.PDU;

public class SNMPProtocol
extends AbstractProtocol<SNMPAgent, SNMPAgentLink> {
    public static final String PROTOCOL_DISPLAY_NAME = "SNMP Client";
    protected static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, SNMPProtocol.class);
    protected final Map<String, AttributeRef> oidMap = new HashMap<String, AttributeRef>();

    public SNMPProtocol(SNMPAgent agent) {
        super(agent);
    }

    public String getProtocolName() {
        return PROTOCOL_DISPLAY_NAME;
    }

    public String getProtocolInstanceUri() {
        return String.format("snmp:%s:%d?protocol=udp&type=TRAP&snmpVersion=%s", ((SNMPAgent)this.agent).getBindHost().orElse(""), ((SNMPAgent)this.agent).getBindPort().orElse(162), ((SNMPAgent)this.agent).getSNMPVersion().orElse(SNMPAgent.SNMPVersion.V2c).getValue());
    }

    @Override
    protected void doStart(Container container) throws Exception {
        String snmpBindHost = (String)((SNMPAgent)this.agent).getBindHost().orElseThrow(() -> {
            String msg = "No SNMP bind host provided for protocol: " + this;
            LOG.info(msg);
            return new IllegalArgumentException(msg);
        });
        Integer snmpBindPort = ((SNMPAgent)this.agent).getBindPort().orElse(162);
        SNMPAgent.SNMPVersion snmpVersion = ((SNMPAgent)this.agent).getSNMPVersion().orElse(SNMPAgent.SNMPVersion.V2c);
        final String snmpUri = String.format("snmp:%s:%d?protocol=udp&type=TRAP&snmpVersion=%d", snmpBindHost, snmpBindPort, snmpVersion.getVersion());
        this.messageBrokerContext.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from(snmpUri).routeId(SNMPProtocol.this.getProtocolName() + ((SNMPAgent)((Object)SNMPProtocol.this.getAgent())).getId()).process(exchange -> {
                    SnmpMessage msg = (SnmpMessage)exchange.getIn(SnmpMessage.class);
                    LOG.fine(String.format("Message received: %s", msg));
                    PDU pdu = msg.getSnmpMessage();
                    AttributeRef wildCardAttributeRef = SNMPProtocol.this.oidMap.get("*");
                    if (wildCardAttributeRef != null) {
                        ObjectNode wildCardValue = ValueUtil.createJsonObject();
                        pdu.getVariableBindings().forEach(variableBinding -> wildCardValue.put(variableBinding.getOid().format(), variableBinding.toValueString()));
                        SNMPProtocol.this.updateLinkedAttribute(new AttributeState(wildCardAttributeRef, (Object)wildCardValue));
                    }
                    pdu.getVariableBindings().forEach(variableBinding -> {
                        AttributeRef attributeRef = SNMPProtocol.this.oidMap.get(variableBinding.getOid().format());
                        if (attributeRef != null) {
                            SNMPProtocol.this.updateLinkedAttribute(new AttributeState(attributeRef, (Object)variableBinding.toValueString()));
                        }
                    });
                });
            }
        });
        this.setConnectionStatus(ConnectionStatus.CONNECTED);
    }

    @Override
    protected void doStop(Container container) throws Exception {
        this.setConnectionStatus(ConnectionStatus.STOPPED);
    }

    @Override
    protected void doLinkAttribute(String assetId, Attribute<?> attribute, SNMPAgentLink agentLink) throws RuntimeException {
        String oid = agentLink.getOID().orElseThrow(() -> {
            String msg = "No OID provided for protocol: " + this;
            LOG.info(msg);
            return new IllegalArgumentException(msg);
        });
        if (oid.equals("*") && this.oidMap.get("*") != null) {
            String msg = "Attribute with wildcard OID already provided for protocol: " + this;
            LOG.info(msg);
            throw new IllegalArgumentException(msg);
        }
        this.oidMap.put(oid, new AttributeRef(assetId, attribute.getName()));
    }

    @Override
    protected void doUnlinkAttribute(String assetId, Attribute<?> attribute, SNMPAgentLink agentLink) {
        agentLink.getOID().ifPresent(this.oidMap::remove);
    }

    @Override
    protected void doLinkedAttributeWrite(Attribute<?> attribute, SNMPAgentLink agentLink, AttributeEvent event, Object processedValue) {
    }
}

